/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.console;

import java.io.IOException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.Script;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.console.ScriptConsolePageParticipant;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.themes.IThemeManager;

public class ScriptConsole
extends IOConsole
implements IExecutionListener,
IScriptEngineProvider,
IPropertyChangeListener {
    private static final String TITLE_TERMINATED = " [terminated]";
    public static final String CONSOLE_ACTIVE = "ACTIVE";
    private IOConsoleOutputStream fOutputStream = null;
    private IOConsoleOutputStream fErrorStream = null;
    private IScriptEngine fEngine = null;
    private ILaunch fLaunch = null;
    private ScriptConsolePageParticipant fScriptConsolePageParticipant;

    public static ScriptConsole create(String title, IScriptEngine engine) {
        ScriptConsole console = new ScriptConsole(title, engine);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
        return console;
    }

    public static ScriptConsole create(IScriptEngine engine) {
        return ScriptConsole.create(engine.getName(), engine);
    }

    private ScriptConsole(String name, IScriptEngine engine) {
        this(name, ScriptConsole.getConsoleType(), null, engine);
    }

    private ScriptConsole(String name, String consoleType, ImageDescriptor imageDescriptor, IScriptEngine engine) {
        super(name, consoleType, imageDescriptor, true);
        this.setScriptEngine(engine);
        this.initializeStreams();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void init() {
        super.init();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        if (store.getBoolean("Console.wrap")) {
            this.setConsoleWidth(store.getInt("Console.width"));
        }
        this.setTabWidth(store.getInt("Console.console_tab_width"));
        if (store.getBoolean("Console.limitConsoleOutput")) {
            int highWater = store.getInt("Console.highWaterMark");
            int lowWater = store.getInt("Console.lowWaterMark");
            this.setWaterMarks(lowWater, highWater);
        }
        Display.getDefault().asyncExec(() -> {
            this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
            this.setBackground(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.consoleBackground"));
        });
    }

    private void initializeStreams() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        IOConsoleOutputStream outputStream = this.getOutputStream();
        outputStream.setActivateOnWrite(store.getBoolean("org.eclipse.ease.console.prefs." + this.getName() + "." + "consoleOpenOnOut"));
        IOConsoleOutputStream errorStream = this.getErrorStream();
        errorStream.setActivateOnWrite(store.getBoolean("org.eclipse.ease.console.prefs." + this.getName() + "." + "consoleOpenOnErr"));
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ColorRegistry colorRegistry = themeManager.getCurrentTheme().getColorRegistry();
        errorStream.setColor(colorRegistry.get("ERROR_COLOR"));
        this.getInputStream().setColor(colorRegistry.get("CONSOLE_INPUT_COLOR"));
    }

    public static String getConsoleType() {
        return "Text console type";
    }

    public IOConsoleOutputStream getErrorStream() {
        if (this.fErrorStream == null || this.fErrorStream.isClosed()) {
            this.fErrorStream = this.newOutputStream();
        }
        return this.fErrorStream;
    }

    public IOConsoleOutputStream getOutputStream() {
        if (this.fOutputStream == null || this.fOutputStream.isClosed()) {
            this.fOutputStream = this.newOutputStream();
        }
        return this.fOutputStream;
    }

    protected void dispose() {
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.setScriptEngine(null);
        super.dispose();
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        if (engine.equals(this.getScriptEngine())) {
            switch (status) {
                case 2: {
                    this.terminate();
                }
            }
        }
    }

    public synchronized void terminate() {
        Display.getDefault().asyncExec(() -> this.setName(String.valueOf(this.getName()) + TITLE_TERMINATED));
        this.setScriptEngine(null);
        this.closeStreams();
    }

    private void closeStreams() {
        try {
            if (this.fOutputStream != null) {
                this.fOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.fErrorStream != null) {
                this.fErrorStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public IScriptEngine getScriptEngine() {
        return this.fEngine;
    }

    public void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public void propertyChange(PropertyChangeEvent event) {
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        String property = event.getProperty();
        if (property.equals("org.eclipse.ease.console.prefs." + this.getName() + "." + "consoleOpenOnOut")) {
            this.getOutputStream().setActivateOnWrite(((Boolean)event.getNewValue()).booleanValue());
        } else if (property.equals("org.eclipse.ease.console.prefs." + this.getName() + "." + "consoleOpenOnErr")) {
            this.getErrorStream().setActivateOnWrite(((Boolean)event.getNewValue()).booleanValue());
        } else if (property.equals("Console.wrap") || property.equals("Console.width")) {
            boolean fixedWidth = store.getBoolean("Console.wrap");
            if (fixedWidth) {
                int width = store.getInt("Console.width");
                this.setConsoleWidth(width);
            } else {
                this.setConsoleWidth(-1);
            }
        } else if (property.equals("Console.limitConsoleOutput") || property.equals("Console.highWaterMark") || property.equals("Console.lowWaterMark")) {
            boolean limitBufferSize = store.getBoolean("Console.limitConsoleOutput");
            if (limitBufferSize) {
                int lowWater;
                int highWater = store.getInt("Console.highWaterMark");
                if (highWater > (lowWater = store.getInt("Console.lowWaterMark"))) {
                    this.setWaterMarks(lowWater, highWater);
                }
            } else {
                this.setWaterMarks(-1, -1);
            }
        } else if (property.equals("Console.console_tab_width")) {
            int tabWidth = store.getInt("Console.console_tab_width");
            this.setTabWidth(tabWidth);
        } else if (property.equals("org.eclipse.debug.ui.outColor")) {
            if (this.fOutputStream != null) {
                this.fOutputStream.setColor(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.outColor"));
            }
        } else if (property.equals("org.eclipse.debug.ui.errorColor")) {
            if (this.fErrorStream != null) {
                this.fErrorStream.setColor(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.errorColor"));
            }
        } else if (!property.equals("org.eclipse.debug.ui.inColor")) {
            if (property.equals("org.eclipse.debug.ui.consoleFont")) {
                this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
            } else if (property.equals("org.eclipse.debug.ui.consoleBackground")) {
                this.setBackground(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.consoleBackground"));
            }
        }
    }

    public synchronized void setScriptEngine(IScriptEngine scriptEngine) {
        if (scriptEngine == null || !scriptEngine.equals(this.fEngine)) {
            if (this.fEngine != null) {
                this.fEngine.removeExecutionListener((IExecutionListener)this);
                this.closeStreams();
            }
            this.fEngine = scriptEngine;
            if (this.fEngine != null) {
                this.fEngine.addExecutionListener((IExecutionListener)this);
            }
            if (this.fScriptConsolePageParticipant != null) {
                this.fScriptConsolePageParticipant.engineChanged();
            }
        }
    }

    public void setPageParticipant(ScriptConsolePageParticipant scriptConsolePageParticipant) {
        this.fScriptConsolePageParticipant = scriptConsolePageParticipant;
    }
}

