/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.dispatcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.DebugTracer;
import org.eclipse.ease.debugging.IScriptRegistry;
import org.eclipse.ease.debugging.ScriptRegistry;
import org.eclipse.ease.debugging.dispatcher.IEventProcessor;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.debugger.IDebuggerEvent;
import org.eclipse.ease.debugging.events.model.IModelRequest;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class EventDispatchJob
extends Job
implements IScriptRegistry {
    private final List<IDebugEvent> fEvents = new ArrayList<IDebugEvent>();
    private final IEventProcessor fModel;
    private final IEventProcessor fDebugger;
    private final IScriptRegistry fScriptRegistry;

    public EventDispatchJob(IEventProcessor host, IEventProcessor debugger) {
        this(host, debugger, new ScriptRegistry());
    }

    protected EventDispatchJob(IEventProcessor host, IEventProcessor debugger, IScriptRegistry scriptRegistry) {
        super(debugger + " event dispatcher");
        this.fModel = host;
        this.fDebugger = debugger;
        this.fModel.setDispatcher(this);
        this.fDebugger.setDispatcher(this);
        this.fScriptRegistry = scriptRegistry;
        this.setSystem(true);
    }

    protected IScriptRegistry getScriptRegistry() {
        return this.fScriptRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(IDebugEvent event) {
        DebugTracer.debug("Dispatcher", "[+] " + event);
        List<IDebugEvent> list = this.fEvents;
        synchronized (list) {
            this.fEvents.add(event);
            this.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        ArrayList<IDebugEvent> events = new ArrayList<IDebugEvent>();
        List<IDebugEvent> list = this.fEvents;
        synchronized (list) {
            events.addAll(this.fEvents);
            this.fEvents.clear();
        }
        for (IDebugEvent event : events) {
            if (monitor.isCanceled()) continue;
            try {
                this.handleEvent(event);
            }
            catch (Throwable e) {
                DebugTracer.debug("Dispatcher", "Error detected: " + e.getClass().getName() + ": " + e.getMessage());
                Logger.error("org.eclipse.ease", "The debug session encountered an error", e);
                Status status = new Status(4, "org.eclipse.ease", "The debug session encountered an error. We try to gracefully continue the session.", e);
                Display.getDefault().asyncExec(() -> {
                    int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug session error", (String)"The debug session encountered an error. We try to gracefully continue the session.", (IStatus)status);
                });
            }
        }
        return Status.OK_STATUS;
    }

    private void handleEvent(IDebugEvent event) {
        if (event instanceof IDebuggerEvent) {
            DebugTracer.debug("Dispatcher", "debugger -> " + event + " -> model");
            this.fModel.handleEvent(event);
        } else if (event instanceof IModelRequest) {
            DebugTracer.debug("Dispatcher", "debugger <- " + event + " <- model");
            this.fDebugger.handleEvent(event);
        } else {
            throw new RuntimeException("Unknown event detected: " + event);
        }
    }

    @Override
    public Script getScript(IResource resource) {
        return this.fScriptRegistry.getScript(resource);
    }

    @Override
    public IResource getResource(Script script) {
        return this.fScriptRegistry.getResource(script);
    }

    @Override
    public void put(Script script) {
        this.fScriptRegistry.put(script);
    }
}

