/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class FusedVMEventHandlerUtils {
    private FusedVMEventHandlerUtils() {
    }

    private static int getNodeCPUs(ITmfStateSystemBuilder ssb) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"CPUs"});
    }

    private static int getNodeThreads(ITmfStateSystemBuilder ssb, String machineName) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"Threads", machineName});
    }

    static int getMachinesNode(ITmfStateSystemBuilder ssb) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"Hosts"});
    }

    static int getCurrentCPUNode(Integer cpuNumber, ITmfStateSystemBuilder ss) {
        return ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getNodeCPUs(ss), new String[]{cpuNumber.toString()});
    }

    public static int getCurrentThreadNode(Integer cpuNumber, ITmfStateSystemBuilder ss) {
        int quark = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getCurrentCPUNode(cpuNumber, ss), new String[]{"Current_thread"});
        Object value = ss.queryOngoing(quark);
        int thread = value instanceof Integer ? (Integer)value : -1;
        quark = ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getCurrentCPUNode(cpuNumber, ss), new String[]{"Machine_name"});
        String machineName = (String)ss.queryOngoing(quark);
        return ss.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getNodeThreads(ss, machineName), new String[]{FusedVMEventHandlerUtils.buildThreadAttributeName(thread, cpuNumber)});
    }

    public static @Nullable String buildThreadAttributeName(int threadId, @Nullable Integer cpuId) {
        if (threadId == 0) {
            if (cpuId == null) {
                return null;
            }
            return "0_" + String.valueOf(cpuId);
        }
        return String.valueOf(threadId);
    }

    public static int getNodeIRQs(int cpuNumber, ITmfStateSystemBuilder ss) {
        return ss.getQuarkAbsoluteAndAdd(new String[]{"CPUs", Integer.toString(cpuNumber), "IRQs"});
    }

    public static long getTimestamp(ITmfEvent event) {
        return event.getTimestamp().toNanos();
    }

    public static void setProcessToRunning(long timestamp, int currentThreadNode, ITmfStateSystemBuilder ssb) throws TimeRangeException, StateValueTypeException {
        int quark = ssb.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"System_call"});
        Integer value = ssb.queryOngoingState(quark).isNull() ? Integer.valueOf(2) : Integer.valueOf(3);
        quark = ssb.getQuarkRelativeAndAdd(currentThreadNode, new String[]{"Status"});
        ssb.modifyAttribute(timestamp, (Object)value, quark);
    }

    public static void cpuExitInterrupt(long timestamp, Integer cpuNumber, ITmfStateSystemBuilder ssb) throws StateValueTypeException, TimeRangeException {
        int currentCPUNode = FusedVMEventHandlerUtils.getCurrentCPUNode(cpuNumber, ssb);
        int quark = ssb.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
        Integer value = FusedVMEventHandlerUtils.getCpuStatus(ssb, currentCPUNode);
        ssb.modifyAttribute(timestamp, (Object)value, quark);
    }

    private static @Nullable Integer getCpuStatus(ITmfStateSystemBuilder ssb, int cpuQuark) {
        int irqQuarks = ssb.getQuarkRelativeAndAdd(cpuQuark, new String[]{"IRQs"});
        List irqs = ssb.getSubAttributes(irqQuarks, false);
        for (Integer quark : irqs) {
            Object irqState = ssb.queryOngoing(quark.intValue());
            if (!(irqState instanceof Integer)) continue;
            return (Integer)irqState;
        }
        int softIrqQuarks = ssb.getQuarkRelativeAndAdd(cpuQuark, new String[]{"Soft_IRQs"});
        List softIrqs = ssb.getSubAttributes(softIrqQuarks, false);
        for (Integer quark : softIrqs) {
            Object softIrqState = ssb.queryOngoing(quark.intValue());
            if (!(softIrqState instanceof Integer)) continue;
            return (Integer)softIrqState;
        }
        int currentThreadQuark = ssb.getQuarkRelativeAndAdd(cpuQuark, new String[]{"Current_thread"});
        Object currentThreadState = ssb.queryOngoing(currentThreadQuark);
        if (!(currentThreadState instanceof Integer)) {
            return null;
        }
        int tid = (Integer)currentThreadState;
        if (tid == 0) {
            return 0;
        }
        int currentMachineQuark = ssb.getQuarkRelativeAndAdd(cpuQuark, new String[]{"Machine_name"});
        String machineName = (String)ssb.queryOngoing(currentMachineQuark);
        int threadSystemCallQuark = ssb.getQuarkRelativeAndAdd(FusedVMEventHandlerUtils.getNodeThreads(ssb, machineName), new String[]{Integer.toString(tid), "System_call"});
        return ssb.queryOngoingState(threadSystemCallQuark).isNull() ? 2 : 4;
    }

    public static int getMachineCPUsNode(ITmfStateSystemBuilder ssq, String hostId) {
        return ssq.getQuarkAbsoluteAndAdd(new String[]{"Hosts", hostId, "CPUs"});
    }

    public static int getMachinepCPUsNode(ITmfStateSystemBuilder ssq, String hostId) {
        return ssq.getQuarkAbsoluteAndAdd(new String[]{"Hosts", hostId, "pCPUs"});
    }

    public static int getNodeThreads(ITmfStateSystemBuilder ss) {
        return ss.getQuarkAbsoluteAndAdd(new String[]{"Threads"});
    }

    public static int saveContainerThreadID(ITmfStateSystemBuilder ss, int quark, int tid) {
        return ss.getQuarkRelativeAndAdd(quark, new String[]{"Threads", Integer.toString(tid)});
    }

    public static int getNodeSoftIRQs(int cpuNumber, ITmfStateSystemBuilder ss) {
        return ss.getQuarkAbsoluteAndAdd(new String[]{"CPUs", Integer.toString(cpuNumber), "Soft_IRQs"});
    }

    public static List<Long> getProcessNSIDs(ITmfStateSystemBuilder ss, int threadQuark) {
        ArrayList<Long> namespaces = new ArrayList<Long>();
        int maxLvQuark = ss.optQuarkRelative(threadQuark, new String[]{"ns_max_level"});
        if (maxLvQuark == -2) {
            return namespaces;
        }
        Object value = ss.queryOngoing(maxLvQuark);
        if (value == null) {
            return namespaces;
        }
        int nsMaxLevel = (Integer)value;
        if (nsMaxLevel > 1) {
            int currentLevel = 1;
            int vtidQuark = threadQuark;
            while (currentLevel < nsMaxLevel) {
                if ((vtidQuark = ss.optQuarkRelative(vtidQuark, new String[]{"VTID"})) == -2) {
                    return namespaces;
                }
                int namespaceIDQuark = ss.optQuarkRelative(vtidQuark, new String[]{"ns_inum"});
                if (namespaceIDQuark == -2) {
                    return namespaces;
                }
                ++currentLevel;
                long namespaceID = ss.queryOngoingState(namespaceIDQuark).unboxLong();
                namespaces.add(namespaceID);
            }
        }
        return namespaces;
    }

    public static String formatTime(long time) {
        return FusedVMEventHandlerUtils.formatTimeAbs(time);
    }

    private static String formatNs(long srcTime) {
        StringBuffer str = new StringBuffer();
        long ns = Math.abs(srcTime % 1000000000L);
        String nanos = Long.toString(ns);
        str.append("000000000".substring(nanos.length()));
        str.append(nanos);
        return str.substring(0, 9);
    }

    private static String formatTimeAbs(long time) {
        StringBuffer str = new StringBuffer();
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        String stime = timeFormat.format(new Date(time / 1000000L));
        str.append(stime);
        str.append('.');
        str.append(FusedVMEventHandlerUtils.formatNs(time));
        return str.toString();
    }
}

