/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.core.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.antlr.runtime.RecognitionException;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.tracecompass.incubator.internal.filters.core.Activator;
import org.eclipse.tracecompass.incubator.internal.filters.core.server.AutoCompletion;
import org.eclipse.tracecompass.incubator.internal.filters.core.server.FilterValidation;
import org.eclipse.tracecompass.incubator.internal.filters.core.server.LanguageFilterServer;
import org.eclipse.tracecompass.incubator.internal.filters.core.server.SyntaxHighlighting;

public class FilterBoxService
implements TextDocumentService {
    private Map<String, String> fFiltersInputs = new HashMap<String, String>();
    private final LanguageFilterServer fLSPServer;

    protected FilterBoxService(LanguageFilterServer server) {
        this.fLSPServer = server;
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams completionParams) {
        ArrayList<CompletionItem> completions = new ArrayList<CompletionItem>();
        try {
            String uri = completionParams.getTextDocument().getUri();
            String input = this.fFiltersInputs.get(uri);
            if (input == null) {
                return CompletableFuture.completedFuture(Either.forLeft(completions));
            }
            Position cursor = completionParams.getPosition();
            List<String> suggestions = AutoCompletion.autoCompletion(input, cursor);
            int i = 0;
            while (i < suggestions.size()) {
                Position start = new Position(0, 0);
                Position end = new Position(0, input.length());
                CompletionItem item = new CompletionItem();
                TextEdit textEdit = new TextEdit(new Range(start, end), suggestions.get(i));
                item.setTextEdit(Either.forLeft((Object)textEdit));
                completions.add(item);
                ++i;
            }
        }
        catch (IOException error) {
            Activator.getInstance().logError(error.getMessage());
        }
        return CompletableFuture.completedFuture(Either.forLeft(completions));
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Hover> hover(HoverParams position) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams position) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams position) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams position) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<ColorInformation>> documentColor(DocumentColorParams params) {
        try {
            String uri = params.getTextDocument().getUri();
            String input = this.fFiltersInputs.get(uri);
            List<ColorInformation> colorInformation = SyntaxHighlighting.getColorInformationList(input);
            return CompletableFuture.completedFuture(colorInformation);
        }
        catch (IOException error) {
            Activator.getInstance().logError(error.getMessage());
            return CompletableFuture.completedFuture(null);
        }
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        throw new UnsupportedOperationException();
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        this.fFiltersInputs.put(params.getTextDocument().getUri(), "");
    }

    public void didChange(DidChangeTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        TextDocumentContentChangeEvent contentChange = (TextDocumentContentChangeEvent)params.getContentChanges().get(0);
        if (contentChange == null) {
            throw new NullPointerException("Event change param cannot be null");
        }
        String input = ((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText();
        this.fFiltersInputs.put(uri, input);
        try {
            List<Diagnostic> diagnostics = FilterValidation.validate(input);
            PublishDiagnosticsParams pd = new PublishDiagnosticsParams(uri, diagnostics);
            pd.setDiagnostics(diagnostics);
            LanguageClient client = this.fLSPServer.getClient();
            if (client != null) {
                client.publishDiagnostics(pd);
            }
        }
        catch (IOException | RecognitionException error) {
            Activator.getInstance().logError(error.getMessage());
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        throw new UnsupportedOperationException();
    }

    public void didSave(DidSaveTextDocumentParams params) {
        throw new UnsupportedOperationException();
    }
}

