/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow;

import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.IRos2MessageFlowVisitor;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messageflow.Ros2MessageFlowSegment;

public class Ros2MessageFlowTraverser {
    private final IRos2MessageFlowVisitor fVisitor;

    public Ros2MessageFlowTraverser(IRos2MessageFlowVisitor visitor) {
        this.fVisitor = visitor;
    }

    public void traverse(Ros2MessageFlowSegment initialSegment) {
        this.traverse(initialSegment, true, true);
    }

    public void traverse(Ros2MessageFlowSegment initialSegment, boolean bothDirections, boolean skipDuplicateInitialSegment) {
        this.traverseDirection(initialSegment, true, false);
        if (bothDirections) {
            this.traverseDirection(initialSegment, false, skipDuplicateInitialSegment);
        }
        this.fVisitor.postVisit();
    }

    private void traverseDirection(Ros2MessageFlowSegment segment, boolean isForward, boolean doSkip) {
        if (!doSkip) {
            this.fVisitor.visit(segment, isForward);
        }
        for (Ros2MessageFlowSegment nextSegment : isForward ? segment.getNext() : segment.getPrevious()) {
            this.traverseDirection(nextSegment, isForward, false);
        }
    }
}

