/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.IRemoteUIConnectionWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.INewConnectionDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;

public class NewConnectionDialog
extends Dialog
implements INewConnectionDialog {
    private static final int BUTTONS_NUMBER_OF_COLUMNS = 3;
    private static final int LABEL_WIDTH_CHARS = 4;
    private static final int CONNECTIONTREE_HEIGHT_CHARS = 10;
    private static final int CONNECTIONTREE_WIDTH_CHARS = 40;
    private static final String TARGET_NEW_CONNECTION_ICON_FILE = "icons/elcl16/target_add.gif";
    private static final String PROVIDERS_ICON_FILE = "icons/obj16/providers.gif";
    private static final String CONNECTION_ICON_FILE = "icons/obj16/target_connected.gif";
    private TreeViewer fConnectionTree = null;
    private Button fNewButton = null;
    private Button fEditButton = null;
    private IRemoteConnection fConnection;

    public NewConnectionDialog(Shell shell) {
        super(shell);
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_NewDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(TARGET_NEW_CONNECTION_ICON_FILE));
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.fConnectionTree.setAutoExpandLevel(2);
        this.fConnectionTree.setInput((Object)this);
        IRemoteServicesManager manager = (IRemoteServicesManager)TmfRemoteConnectionFactory.getService(IRemoteServicesManager.class);
        if (manager == null) {
            return result;
        }
        List providers = manager.getAllConnectionTypes();
        if (!providers.isEmpty()) {
            IRemoteConnectionType provider = (IRemoteConnectionType)providers.get(0);
            IRemoteConnection[] connections = ConnectionContentProvider.getConnections(provider);
            if (connections.length > 0) {
                this.fConnectionTree.setSelection((ISelection)new StructuredSelection((Object)connections[0]));
            } else {
                this.fConnectionTree.setSelection((ISelection)new StructuredSelection((Object)provider));
            }
        } else {
            this.onSelectionChanged();
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        dialogComposite.setLayout((Layout)layout);
        dialogComposite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(dialogComposite, 0);
        label.setText(Messages.TraceControl_NewNodeExistingConnectionGroupName);
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        gd.widthHint = label.computeSize((int)-1, (int)-1).x + this.convertWidthInCharsToPixels(4);
        this.fConnectionTree = new TreeViewer(dialogComposite);
        gd = new GridData(4, 4, true, true);
        this.fConnectionTree.getTree().setLayoutData((Object)gd);
        gd.widthHint = this.convertWidthInCharsToPixels(40);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        this.fConnectionTree.setLabelProvider((IBaseLabelProvider)new ConnectionTreeLabelProvider());
        this.fConnectionTree.setContentProvider((IContentProvider)new ConnectionContentProvider());
        this.fConnectionTree.addSelectionChangedListener(event -> this.onSelectionChanged());
        this.fConnectionTree.addDoubleClickListener(event -> this.okPressed());
        Composite buttons = new Composite(dialogComposite, 0);
        layout = new GridLayout(3, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        new Label(buttons, 0);
        this.fEditButton = new Button(buttons, 8);
        this.fEditButton.setText(Messages.TraceControl_NewNodeEditButtonName);
        this.setButtonLayoutData(this.fEditButton);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConnectionDialog.this.onEditConnection();
            }
        });
        this.fNewButton = new Button(buttons, 8);
        this.fNewButton.setText(Messages.TraceControl_NewNodeCreateButtonText);
        this.setButtonLayoutData(this.fNewButton);
        this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConnectionDialog.this.onNewConnection();
            }
        });
        return dialogComposite;
    }

    private void onSelectionChanged() {
        this.setConnection();
        this.getButton(0).setEnabled(this.fConnection != null);
        this.fEditButton.setEnabled(NewConnectionDialog.canEdit(this.fConnection));
        this.fNewButton.setEnabled(this.getServiceForCreation() != null);
    }

    private IRemoteConnectionType getServiceForCreation() {
        Object o = ((IStructuredSelection)this.fConnectionTree.getSelection()).getFirstElement();
        IRemoteConnectionType result = null;
        if (o instanceof IRemoteConnectionType) {
            result = (IRemoteConnectionType)o;
        } else if (o instanceof IRemoteConnection) {
            result = ((IRemoteConnection)o).getConnectionType();
        } else {
            return null;
        }
        if (!result.canAdd()) {
            return null;
        }
        return result;
    }

    private static boolean canEdit(IRemoteConnection conn) {
        if (conn == null) {
            return false;
        }
        return conn.getConnectionType().canEdit();
    }

    private void onNewConnection() {
        IRemoteConnectionWorkingCopy wc;
        IRemoteUIConnectionWizard wiz;
        IRemoteUIConnectionService uiService;
        IRemoteConnectionType rs = this.getServiceForCreation();
        if (rs != null && (uiService = (IRemoteUIConnectionService)rs.getService(IRemoteUIConnectionService.class)) != null && (wiz = uiService.getConnectionWizard(this.getShell())) != null && (wc = wiz.open()) != null) {
            IRemoteConnection conn = null;
            try {
                conn = wc.save();
            }
            catch (RemoteConnectionException e) {
                Activator.getDefault().logWarning("Connection configuration could not be saved for " + this.fConnection.getName(), e);
            }
            if (conn != null) {
                this.fConnectionTree.refresh();
                this.fConnectionTree.setSelection((ISelection)new StructuredSelection((Object)conn), true);
            }
        }
    }

    private void onEditConnection() {
        IRemoteUIConnectionService ui;
        this.setConnection();
        if (this.fConnection != null && (ui = (IRemoteUIConnectionService)this.fConnection.getConnectionType().getService(IRemoteUIConnectionService.class)) != null) {
            IRemoteUIConnectionWizard wiz = ui.getConnectionWizard(this.getShell());
            wiz.setConnection(this.fConnection.getWorkingCopy());
            IRemoteConnectionWorkingCopy result = wiz.open();
            if (result != null) {
                try {
                    result.save();
                }
                catch (RemoteConnectionException e) {
                    Activator.getDefault().logWarning("Connection configuration could not be saved for " + this.fConnection.getName(), e);
                }
                this.fConnectionTree.refresh();
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        this.setConnection();
        if (this.fConnection != null) {
            super.okPressed();
        }
    }

    private void setConnection() {
        Object o = ((IStructuredSelection)this.fConnectionTree.getSelection()).getFirstElement();
        this.fConnection = o instanceof IRemoteConnection ? (IRemoteConnection)o : null;
    }

    @Override
    public IRemoteConnection getConnection() {
        return this.fConnection;
    }

    private static String getConnectionLabel(IRemoteConnection rc) {
        StringBuffer label = new StringBuffer();
        label.append(rc.getName());
        if (rc.hasService(IRemoteConnectionHostService.class)) {
            IRemoteConnectionHostService service = (IRemoteConnectionHostService)NonNullUtils.checkNotNull((Object)((IRemoteConnectionHostService)rc.getService(IRemoteConnectionHostService.class)));
            label.append(MessageFormat.format(" [{0}]", service.getHostname()));
        }
        return label.toString();
    }

    static /* synthetic */ String access$0(IRemoteConnection iRemoteConnection) {
        return NewConnectionDialog.getConnectionLabel(iRemoteConnection);
    }

    private static final class ConnectionContentProvider
    implements ITreeContentProvider {
        private static final Object[] NO_CHILDREN = new Object[0];

        private ConnectionContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList children = new ArrayList();
            IRemoteServicesManager manager = (IRemoteServicesManager)TmfRemoteConnectionFactory.getService(IRemoteServicesManager.class);
            if (manager != null) {
                children.addAll(manager.getAllConnectionTypes());
            }
            return children.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IRemoteConnectionType) {
                return ConnectionContentProvider.getConnections((IRemoteConnectionType)parentElement);
            }
            return NO_CHILDREN;
        }

        private static IRemoteConnection[] getConnections(IRemoteConnectionType parentElement) {
            List connectionList = parentElement.getConnections();
            IRemoteConnection[] result = connectionList.toArray(new IRemoteConnection[connectionList.size()]);
            Arrays.sort(result, (o1, o2) -> NewConnectionDialog.getConnectionLabel(o1).compareTo(NewConnectionDialog.getConnectionLabel(o2)));
            return result;
        }

        public Object getParent(Object element) {
            if (element instanceof IRemoteConnection) {
                return ((IRemoteConnection)element).getConnectionType();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    private final class ConnectionTreeLabelProvider
    extends LabelProvider {
        private ConnectionTreeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IRemoteConnection) {
                IRemoteConnection rc = (IRemoteConnection)element;
                return NewConnectionDialog.getConnectionLabel(rc);
            }
            if (element instanceof IRemoteConnectionType) {
                IRemoteConnectionType rs = (IRemoteConnectionType)element;
                return rs.getName();
            }
            return Messages.TraceControl_UnknownNode;
        }

        public Image getImage(Object element) {
            if (element instanceof IRemoteConnection) {
                return Activator.getDefault().loadIcon(NewConnectionDialog.CONNECTION_ICON_FILE);
            }
            return Activator.getDefault().loadIcon(NewConnectionDialog.PROVIDERS_ICON_FILE);
        }
    }
}

