/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;

public class ProceedOnErrorGen
extends Gen {
    private Context context;

    public static void preRegister(Context context) {
        context.put(Gen.genKey, ProceedOnErrorGen::new);
    }

    protected ProceedOnErrorGen(Context context) {
        super(context);
        this.context = context;
    }

    private JCTree.JCNewClass newRuntimeException() {
        TreeMaker treeMaker = TreeMaker.instance(this.context);
        JCTree.JCNewClass res = treeMaker.NewClass(null, null, treeMaker.Ident(Names.instance(this.context).fromString(RuntimeException.class.getSimpleName())), List.of(treeMaker.Literal("Compile Error")), null);
        Attr.instance(this.context).attribStat(res, this.getAttrEnv());
        res.type = res.clazz.type;
        return res;
    }

    @Override
    public boolean genClass(Env<AttrContext> env, JCTree.JCClassDecl cdef) {
        try {
            return super.genClass(env, cdef) && this.verifyClassComplete(cdef.sym);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean verifyClassComplete(Symbol.ClassSymbol sym) {
        return sym.type != null && !sym.type.isErroneous() && !sym.getSuperclass().isErroneous() && sym.getInterfaces().stream().noneMatch(Type::isErroneous) && !sym.members().getSymbols(member -> {
            if (member instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol field = (Symbol.VarSymbol)member;
                if (field.type.isErroneous()) return true;
            }
            if (!(member instanceof Symbol.MethodSymbol)) return false;
            Symbol.MethodSymbol method = (Symbol.MethodSymbol)member;
            if (method.type.isErroneous()) return true;
            if (method.getReturnType().isErroneous()) return true;
            if (method.params != null) {
                if (method.params.stream().map(param -> param.type).anyMatch(Type::isErroneous)) return true;
            }
            if (!method.getThrownTypes().stream().anyMatch(Type::isErroneous)) return false;
            return true;
        }).iterator().hasNext();
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous that) {
        this.visitNewClass(this.newRuntimeException());
        this.getCode().emitop0(191);
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        if (tree.sym == null || tree.sym.kind == Kinds.Kind.ERR || tree.sym.kind == Kinds.Kind.STATICERR) {
            this.visitErroneous(null);
        } else {
            super.visitIdent(tree);
        }
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        if (tree.type == null || tree.type.isErroneous()) {
            this.visitErroneous(null);
        } else {
            super.visitLiteral(tree);
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        if (tree.type == null || tree.type.isErroneous() || tree.args.stream().anyMatch(arg -> arg.type == null || arg.type.isErroneous())) {
            this.visitErroneous(null);
        } else {
            super.visitNewClass(tree);
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        if (tree.type.isErroneous() || tree.args.stream().anyMatch(arg -> arg.type == null || arg.type.isErroneous())) {
            this.visitErroneous(null);
        } else {
            Symbol meth1 = tree == null ? null : TreeInfo.symbol(tree.meth);
            Symbol base = meth1 == null ? null : meth1.baseSymbol();
            boolean isMethSym = base instanceof Symbol.MethodSymbol;
            if (!isMethSym) {
                return;
            }
            super.visitApply(tree);
        }
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        if (tree.type.isErroneous()) {
            this.visitErroneous(null);
        } else {
            super.visitSelect(tree);
        }
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        if (tree.expr == null || tree.expr instanceof JCTree.JCErroneous || tree.expr.type.isErroneous()) {
            this.visitErroneous(null);
        } else {
            super.visitExec(tree);
        }
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        if (tree.lhs.type.isErroneous() || tree.rhs == null || tree.rhs.type == null || tree.rhs.type.isErroneous()) {
            this.visitErroneous(null);
        } else {
            super.visitAssign(tree);
        }
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        if (tree.type.isErroneous() || tree.getIndex() == null || tree.getIndex().type == null || tree.getIndex().type.isErroneous()) {
            this.visitErroneous(null);
        } else {
            super.visitIndexed(tree);
        }
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        if (tree.getExpression() == null || tree.getExpression().type instanceof Type.ErrorType) {
            this.visitErroneous(null);
        } else {
            super.visitTypeTest(tree);
        }
    }

    private boolean isValid(JCTree.JCExpression exp) {
        return exp != null && !(exp instanceof JCTree.JCErroneous) && exp.type != null && !exp.type.isErroneous();
    }

    @Override
    public void visitThrow(JCTree.JCThrow th) {
        if (!this.isValid(th.expr)) {
            this.visitErroneous(null);
        } else {
            super.visitThrow(th);
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl varDef) {
        if (varDef.type == null || varDef.type.isErroneous()) {
            this.visitErroneous(null);
        } else {
            super.visitVarDef(varDef);
        }
    }

    @Override
    public void visitBinary(JCTree.JCBinary binary) {
        if (!this.isValid(binary.lhs) || !this.isValid(binary.rhs)) {
            this.visitErroneous(null);
        } else {
            super.visitBinary(binary);
        }
    }

    @Override
    public void visitParens(JCTree.JCParens parens) {
        if (!this.isValid(parens) || !this.isValid(parens.expr)) {
            this.visitErroneous(null);
        } else {
            super.visitParens(parens);
        }
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        if (tree == null || tree.getExpression() != null && !this.isValid(tree.getExpression())) {
            this.visitErroneous(null);
        } else {
            super.visitReturn(tree);
        }
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        if (tree == null || !this.isValid(tree.getCondition())) {
            this.visitErroneous(null);
        } else {
            super.visitIf(tree);
        }
    }
}

