/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.groups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.groups.GroupLaunch;
import org.eclipse.debug.internal.core.groups.GroupLaunchElement;
import org.eclipse.debug.internal.core.groups.observer.ProcessObserver;
import org.eclipse.debug.internal.core.groups.observer.StreamObserver;
import org.eclipse.osgi.util.NLS;

public class GroupLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate2 {
    public static final int CODE_GROUP_LAUNCH_START = 233;
    public static final int CODE_GROUP_LAUNCH_DONE = 234;
    private static final int CODE_BUILD_BEFORE_LAUNCH = 206;
    private static final String NAME_PROP = "name";
    private static final String ENABLED_PROP = "enabled";
    private static final String ADOPT_PROP = "adoptIfRunning";
    private static final String MODE_PROP = "mode";
    private static final String ACTION_PROP = "action";
    private static final String ACTION_PARAM_PROP = "actionParam";
    private static final String MULTI_LAUNCH_CONSTANTS_PREFIX = "org.eclipse.debug.core.launchGroup";
    private static final String DEBUG_CORE = "org.eclipse.debug.core";
    private static final Status UNSUPPORTED_MODE = new Status(4, "org.eclipse.debug.core", 230, "", null);
    private static final Status GROUP_ELEMENT_STARTED = new Status(0, "org.eclipse.debug.core", 231, "", null);
    private static final Status GROUP_CYCLE = new Status(4, "org.eclipse.debug.core", 232, "", null);
    private static final Status GROUP_LAUNCH_START = new Status(1, "org.eclipse.debug.core", 233, "", null);
    private static final Status GROUP_LAUNCH_DONE = new Status(1, "org.eclipse.debug.core", 234, "", null);
    private static final Status BUILD_BEFORE_LAUNCH = new Status(1, "org.eclipse.debug.core", 206, "", null);

    @Override
    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return new GroupLaunch(configuration, mode);
    }

    @Override
    public void launch(ILaunchConfiguration groupConfig, String mode, ILaunch groupLaunch, IProgressMonitor monitor) throws CoreException {
        GroupLaunch group = (GroupLaunch)groupLaunch;
        IStatusHandler groupStateHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)GROUP_LAUNCH_START);
        groupStateHandler.handleStatus((IStatus)GROUP_LAUNCH_START, group);
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)DebugCoreMessages.GroupLaunchConfigurationDelegate_Launching, (Object)groupConfig.getName()), (int)1000);
            List<GroupLaunchElement> launches = GroupLaunchConfigurationDelegate.createLaunchElements(groupConfig);
            int nbEnabledLaunches = launches.stream().filter(l -> l.enabled).toList().size();
            int i = 0;
            while (i < launches.size()) {
                ILaunchConfiguration conf;
                GroupLaunchElement le = launches.get(i);
                if (le.enabled && (conf = GroupLaunchConfigurationDelegate.findLaunchConfiguration(le.name)) != null) {
                    String localMode = !le.mode.equals("inherit") ? le.mode : mode;
                    if (!conf.supportsMode(localMode)) {
                        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)UNSUPPORTED_MODE);
                        handler.handleStatus((IStatus)UNSUPPORTED_MODE, new String[]{conf.getName(), localMode});
                    } else {
                        if (groupConfig.getName().equals(conf.getName())) {
                            IStatusHandler cycleHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)GROUP_CYCLE);
                            cycleHandler.handleStatus((IStatus)GROUP_CYCLE, conf.getName());
                        } else if (!this.launchChild(progress.newChild(1000 / nbEnabledLaunches), group, le, conf, localMode, i == nbEnabledLaunches - 1)) break;
                        if (group.isTerminated()) break;
                    }
                }
                ++i;
            }
            if (!group.hasChildren()) {
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(group);
            }
        }
        finally {
            group.markLaunched();
            groupStateHandler.handleStatus((IStatus)GROUP_LAUNCH_DONE, group);
            monitor.done();
        }
    }

    private boolean launchChild(SubMonitor monitor, GroupLaunch group, GroupLaunchElement le, ILaunchConfiguration child, String localMode, boolean lastConfig) throws CoreException {
        Set running = le.adoptIfRunning ? GroupLaunchConfigurationDelegate.findRunningLaunch(le.name) : Collections.emptySet();
        ILaunch subLaunch = running.stream().findFirst().orElse(null);
        boolean launched = false;
        if (subLaunch == null) {
            boolean build = true;
            IStatusHandler buildHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)BUILD_BEFORE_LAUNCH);
            try {
                Object resolution = buildHandler.handleStatus((IStatus)BUILD_BEFORE_LAUNCH, child);
                if (resolution instanceof Boolean) {
                    build = (Boolean)resolution;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            subLaunch = child.launch(localMode, (IProgressMonitor)monitor, build);
            launched = true;
        }
        group.addSubLaunch(subLaunch);
        group.launchChanged(subLaunch);
        if (launched) {
            IStatusHandler postLaunchHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)GROUP_ELEMENT_STARTED);
            postLaunchHandler.handleStatus((IStatus)GROUP_ELEMENT_STARTED, new ILaunch[]{group, subLaunch});
        }
        if (lastConfig) {
            group.markLaunched();
        }
        if (launched) {
            return this.postLaunchAction(subLaunch, le, (IProgressMonitor)monitor);
        }
        return true;
    }

    private boolean postLaunchAction(ILaunch subLaunch, GroupLaunchElement le, IProgressMonitor monitor) {
        switch (le.action) {
            case NONE: {
                return true;
            }
            case WAIT_FOR_TERMINATION: {
                monitor.subTask(NLS.bind((String)DebugCoreMessages.GroupLaunchConfigurationDelegate_Waiting_for_termination, (Object)subLaunch.getLaunchConfiguration().getName()));
                while (!subLaunch.isTerminated() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                monitor.subTask("");
                break;
            }
            case DELAY: {
                Integer waitSecs = (Integer)le.actionParam;
                if (waitSecs == null) break;
                monitor.subTask(NLS.bind((String)DebugCoreMessages.GroupLaunchConfigurationDelegate_Delaying, (Object)waitSecs.toString()));
                try {
                    Thread.sleep(waitSecs * 1000);
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            case OUTPUT_REGEXP: {
                String regexp = (String)le.actionParam;
                if (regexp == null) break;
                monitor.subTask(NLS.bind((String)DebugCoreMessages.GroupLaunchConfigurationDelegate_waiting, (Object)regexp, (Object)subLaunch.getLaunchConfiguration().getName()));
                if (this.waitForOutputMatching(subLaunch, monitor, regexp)) break;
                return false;
            }
            default: {
                assert (false) : "new post launch action type is missing logic";
                break;
            }
        }
        return true;
    }

    private boolean waitForOutputMatching(ILaunch launch, IProgressMonitor m, String regexp) {
        int processCount = launch.getProcesses().length;
        ExecutorService executor = Executors.newCachedThreadPool();
        CountDownLatch countDownLatch = new CountDownLatch(processCount);
        Future<Integer> process = null;
        IProcess[] iProcessArray = launch.getProcesses();
        int n = iProcessArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess p = iProcessArray[n2];
            process = executor.submit(new ProcessObserver(m, p, countDownLatch));
            executor.submit(new StreamObserver(m, p, regexp, countDownLatch));
            ++n2;
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        executor.shutdown();
        return process != null && !process.isDone();
    }

    @Override
    protected void buildProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    protected static ILaunchConfiguration findLaunchConfiguration(String name) throws CoreException {
        ILaunchConfiguration[] launchConfigurations;
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = launchManager.getLaunchConfigurations();
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (config.getName().equals(name)) {
                return config;
            }
            ++n2;
        }
        return null;
    }

    protected static Set<ILaunch> findRunningLaunch(String name) {
        HashSet<ILaunch> result = new HashSet<ILaunch>();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] iLaunchArray = launchManager.getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch l = iLaunchArray[n2];
            if (!l.isTerminated() && l.getLaunchConfiguration().getName().equals(name)) {
                result.add(l);
            }
            ++n2;
        }
        return result;
    }

    public static List<GroupLaunchElement> createLaunchElements(ILaunchConfiguration configuration) {
        ArrayList<GroupLaunchElement> result = new ArrayList<GroupLaunchElement>();
        try {
            Map<String, Object> attrs = configuration.getAttributes();
            for (Map.Entry<String, Object> entry : attrs.entrySet()) {
                String attr = entry.getKey();
                try {
                    GroupLaunchElement.GroupElementPostLaunchAction action;
                    if (!attr.startsWith(MULTI_LAUNCH_CONSTANTS_PREFIX)) continue;
                    String prop = attr.substring(MULTI_LAUNCH_CONSTANTS_PREFIX.length() + 1);
                    int k = prop.indexOf(46);
                    String num = prop.substring(0, k);
                    int index = Integer.parseInt(num);
                    String name = prop.substring(k + 1);
                    if (!name.equals(NAME_PROP)) continue;
                    GroupLaunchElement el = new GroupLaunchElement();
                    el.index = index;
                    el.name = (String)entry.getValue();
                    Object actionParam = null;
                    String actionStr = (String)attrs.get(GroupLaunchConfigurationDelegate.getProp(index, ACTION_PROP));
                    try {
                        action = GroupLaunchElement.GroupElementPostLaunchAction.valueOf(actionStr);
                    }
                    catch (Exception e) {
                        action = GroupLaunchElement.GroupElementPostLaunchAction.NONE;
                    }
                    if (action == GroupLaunchElement.GroupElementPostLaunchAction.DELAY) {
                        try {
                            actionParam = Integer.parseInt((String)attrs.get(GroupLaunchConfigurationDelegate.getProp(index, ACTION_PARAM_PROP)));
                        }
                        catch (NumberFormatException exc) {
                            DebugPlugin.log(exc);
                        }
                    }
                    if (action == GroupLaunchElement.GroupElementPostLaunchAction.OUTPUT_REGEXP) {
                        actionParam = attrs.get(GroupLaunchConfigurationDelegate.getProp(index, ACTION_PARAM_PROP));
                    }
                    el.action = action;
                    el.actionParam = actionParam;
                    if (attrs.containsKey(GroupLaunchConfigurationDelegate.getProp(index, ADOPT_PROP))) {
                        el.adoptIfRunning = (Boolean)attrs.get(GroupLaunchConfigurationDelegate.getProp(index, ADOPT_PROP));
                    }
                    el.mode = (String)attrs.get(GroupLaunchConfigurationDelegate.getProp(index, MODE_PROP));
                    el.enabled = (Boolean)attrs.get(GroupLaunchConfigurationDelegate.getProp(index, ENABLED_PROP));
                    try {
                        el.data = GroupLaunchConfigurationDelegate.findLaunchConfiguration(el.name);
                    }
                    catch (Exception e) {
                        el.data = null;
                    }
                    while (index >= result.size()) {
                        result.add(null);
                    }
                    result.set(index, el);
                }
                catch (Exception e) {
                    DebugPlugin.log(e);
                }
            }
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
        }
        return result;
    }

    public static void storeLaunchElements(ILaunchConfigurationWorkingCopy configuration, List<GroupLaunchElement> input) {
        int i = 0;
        GroupLaunchConfigurationDelegate.removeLaunchElements(configuration);
        for (GroupLaunchElement el : input) {
            if (el == null) continue;
            configuration.setAttribute(GroupLaunchConfigurationDelegate.getProp(i, NAME_PROP), el.name);
            configuration.setAttribute(GroupLaunchConfigurationDelegate.getProp(i, ACTION_PROP), el.action.toString());
            configuration.setAttribute(GroupLaunchConfigurationDelegate.getProp(i, ADOPT_PROP), el.adoptIfRunning);
            configuration.setAttribute(GroupLaunchConfigurationDelegate.getProp(i, ACTION_PARAM_PROP), el.actionParam != null ? el.actionParam.toString() : null);
            configuration.setAttribute(GroupLaunchConfigurationDelegate.getProp(i, MODE_PROP), el.mode);
            configuration.setAttribute(GroupLaunchConfigurationDelegate.getProp(i, ENABLED_PROP), el.enabled);
            ++i;
        }
    }

    public static void removeLaunchElements(ILaunchConfigurationWorkingCopy configuration) {
        try {
            for (String attr : configuration.getAttributes().keySet()) {
                try {
                    if (!attr.startsWith(MULTI_LAUNCH_CONSTANTS_PREFIX)) continue;
                    configuration.removeAttribute(attr);
                }
                catch (Exception e) {
                    DebugPlugin.log(e);
                }
            }
        }
        catch (CoreException e) {
            DebugPlugin.log(e);
        }
    }

    public static String getProp(int index, String string) {
        return "org.eclipse.debug.core.launchGroup." + index + "." + string;
    }
}

