/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.MethodNode;

public class GeneratorContext {
    private int innerClassIdx = 1;
    private int closureClassIdx = 1;
    private int syntheticMethodIdx = 0;
    private final CompileUnit compileUnit;
    private static final boolean[] CHARACTERS_TO_ENCODE;
    private static final int MIN_ENCODING;
    private static final int MAX_ENCODING;

    static {
        char[] chars = new char[]{' ', '!', '\"', '#', '$', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '@', '[', '\\', ']', '^', '{', '}', '~'};
        MIN_ENCODING = chars[0];
        MAX_ENCODING = chars[chars.length - 1];
        CHARACTERS_TO_ENCODE = new boolean[MAX_ENCODING - MIN_ENCODING + 1];
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            GeneratorContext.CHARACTERS_TO_ENCODE[c - GeneratorContext.MIN_ENCODING] = true;
            ++n2;
        }
    }

    public GeneratorContext(CompileUnit compileUnit) {
        this.compileUnit = compileUnit;
    }

    public GeneratorContext(CompileUnit compileUnit, int innerClassOffset) {
        this.compileUnit = compileUnit;
        this.innerClassIdx = innerClassOffset;
    }

    public int getNextInnerClassIdx() {
        return this.innerClassIdx++;
    }

    public CompileUnit getCompileUnit() {
        return this.compileUnit;
    }

    public String getNextClosureInnerName(ClassNode owner, ClassNode enclosingClass, MethodNode enclosingMethod) {
        return this.getNextInnerName(owner, enclosingClass, enclosingMethod, "closure");
    }

    public String getNextLambdaInnerName(ClassNode owner, ClassNode enclosingClass, MethodNode enclosingMethod) {
        return this.getNextInnerName(owner, enclosingClass, enclosingMethod, "lambda");
    }

    private String getNextInnerName(ClassNode owner, ClassNode enclosingClass, MethodNode enclosingMethod, String classifier) {
        String methodName = "";
        if (enclosingMethod != null) {
            methodName = enclosingMethod.getName();
            methodName = enclosingClass.isDerivedFrom(ClassHelper.CLOSURE_TYPE) ? "" : "_" + GeneratorContext.encodeAsValidClassName(methodName);
        }
        return String.valueOf(methodName) + "_" + classifier + this.closureClassIdx++;
    }

    public String getNextConstructorReferenceSyntheticMethodName(MethodNode enclosingMethodNode) {
        return "ctorRef$" + (enclosingMethodNode == null ? "" : String.valueOf(enclosingMethodNode.getName().replace("<", "").replace(">", "")) + "$") + this.syntheticMethodIdx++;
    }

    public static String encodeAsValidClassName(String name) {
        if (name.equals("module-info") || name.equals("package-info")) {
            return name;
        }
        int lastEscape = -1;
        StringBuilder b = null;
        int n = name.length();
        int i = 0;
        while (i < n) {
            int encodeIndex = name.charAt(i) - MIN_ENCODING;
            if (encodeIndex >= 0 && encodeIndex < CHARACTERS_TO_ENCODE.length && CHARACTERS_TO_ENCODE[encodeIndex]) {
                if (b == null) {
                    b = new StringBuilder(name.length() + 3);
                    b.append(name, 0, i);
                } else {
                    b.append(name, lastEscape + 1, i);
                }
                b.append('_');
                lastEscape = i;
            }
            ++i;
        }
        if (b == null) {
            return name;
        }
        if (lastEscape == -1) {
            throw new GroovyBugError("unexpected escape char control flow in " + name);
        }
        b.append(name, lastEscape + 1, n);
        return b.toString();
    }
}

