/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.searcher;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.junit.launcher.ITestFinder;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;

public class JUnit6TestFinder
implements ITestFinder {
    private static final String JUNIT6_LOADER = "org.eclipse.jdt.junit.loader.junit6";

    public void findTestsInContainer(IJavaElement element, Set<IType> result, IProgressMonitor pm) throws CoreException {
        IType[] allClasses;
        if (element == null || result == null) {
            throw new IllegalArgumentException();
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            if (this.internalIsTest(type, pm)) {
                result.add(type);
            }
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)pm, (String)"Searching for JUnit 6 tests...", (int)4);
        IRegion region = CoreTestSearchEngine.getRegion((IJavaElement)element);
        ITypeHierarchy hierarchy = JavaCore.newTypeHierarchy((IRegion)region, null, (IProgressMonitor)subMonitor.split(1));
        IType[] iTypeArray = allClasses = hierarchy.getAllClasses();
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (region.contains((IJavaElement)type) && this.internalIsTest(type, pm)) {
                this.addTypeAndSubtypes(type, result, hierarchy);
            }
            ++n2;
        }
        IType testInterface = element.getJavaProject().findType("junit.framework.Test");
        if (testInterface != null) {
            CoreTestSearchEngine.findTestImplementorClasses((ITypeHierarchy)hierarchy, (IType)testInterface, (IRegion)region, result);
        }
        CoreTestSearchEngine.findSuiteMethods((IJavaElement)element, result, (IProgressMonitor)subMonitor.split(1));
    }

    private void addTypeAndSubtypes(IType type, Set<IType> result, ITypeHierarchy hierarchy) {
        if (result.add(type)) {
            IType[] subclasses;
            IType[] iTypeArray = subclasses = hierarchy.getSubclasses(type);
            int n = subclasses.length;
            int n2 = 0;
            while (n2 < n) {
                IType subclass = iTypeArray[n2];
                this.addTypeAndSubtypes(subclass, result, hierarchy);
                ++n2;
            }
        }
    }

    public boolean isTest(IType type) throws JavaModelException {
        return this.internalIsTest(type, null);
    }

    private boolean internalIsTest(IType type, IProgressMonitor pm) throws JavaModelException {
        AbstractTypeDeclaration typeDecl;
        ITypeBinding binding;
        if (!CoreTestSearchEngine.isAccessibleClass((IType)type, (String)JUNIT6_LOADER)) {
            return false;
        }
        if (CoreTestSearchEngine.hasSuiteMethod((IType)type)) {
            return true;
        }
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        if (type.getCompilationUnit() != null) {
            parser.setSource(type.getCompilationUnit());
        } else {
            if (!JUnit6TestFinder.isAvailable(type.getSourceRange())) {
                parser.setProject(type.getJavaProject());
                IBinding[] bindings = parser.createBindings(new IJavaElement[]{type}, pm);
                if (bindings.length == 1 && bindings[0] instanceof ITypeBinding) {
                    ITypeBinding typeBinding = (ITypeBinding)bindings[0];
                    return this.isTest(typeBinding);
                }
                return false;
            }
            IOrdinaryClassFile classFile = type.getClassFile();
            if (classFile != null) {
                parser.setSource((IClassFile)classFile);
            } else {
                return false;
            }
        }
        parser.setFocalPosition(0);
        parser.setResolveBindings(true);
        CompilationUnit cu = (CompilationUnit)parser.createAST(pm);
        ASTNode node = cu.findDeclaringNode(type.getKey());
        if ((node instanceof TypeDeclaration || node instanceof RecordDeclaration) && (binding = (typeDecl = (AbstractTypeDeclaration)node).resolveBinding()) != null) {
            return this.isTest(binding);
        }
        return false;
    }

    private static boolean isAvailable(ISourceRange range) {
        return range != null && range.getOffset() != -1;
    }

    private boolean isTest(ITypeBinding typeBinding) {
        if (typeBinding == null || Modifier.isAbstract((int)typeBinding.getModifiers())) {
            return false;
        }
        if (this.hasTestMethods(typeBinding)) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getDeclaredTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding nestedType = iTypeBindingArray[n2];
            if (this.isNestedTestClass(nestedType)) {
                return true;
            }
            ++n2;
        }
        ITypeBinding superclass = typeBinding.getSuperclass();
        return superclass != null && !superclass.getQualifiedName().equals("java.lang.Object") && this.isTest(superclass);
    }

    private boolean hasTestMethods(ITypeBinding typeBinding) {
        IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (this.isTestMethod(method)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isTestMethod(IMethodBinding method) {
        IAnnotationBinding[] iAnnotationBindingArray = method.getAnnotations();
        int n = iAnnotationBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding annotationType;
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            if (annotation != null && (annotationType = annotation.getAnnotationType()) != null && this.isTestableAnnotation(annotationType, new HashSet<ITypeBinding>())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isTestableAnnotation(ITypeBinding annotationType, Set<ITypeBinding> visited) {
        if (annotationType == null || !visited.add(annotationType)) {
            return false;
        }
        String qualifiedName = annotationType.getQualifiedName();
        if ("org.junit.platform.commons.annotation.Testable".equals(qualifiedName)) {
            return true;
        }
        if (qualifiedName.startsWith("org.junit.jupiter.api.") && (qualifiedName.equals("org.junit.jupiter.api.Test") || qualifiedName.equals("org.junit.jupiter.api.RepeatedTest") || qualifiedName.equals("org.junit.jupiter.api.ParameterizedTest") || qualifiedName.equals("org.junit.jupiter.api.TestFactory") || qualifiedName.equals("org.junit.jupiter.api.TestTemplate"))) {
            return true;
        }
        IAnnotationBinding[] iAnnotationBindingArray = annotationType.getAnnotations();
        int n = iAnnotationBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding metaAnnotationType;
            IAnnotationBinding metaAnnotation = iAnnotationBindingArray[n2];
            if (metaAnnotation != null && this.isTestableAnnotation(metaAnnotationType = metaAnnotation.getAnnotationType(), visited)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isNestedTestClass(ITypeBinding nestedType) {
        IAnnotationBinding[] iAnnotationBindingArray = nestedType.getAnnotations();
        int n = iAnnotationBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding annotationType;
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            if (annotation != null && (annotationType = annotation.getAnnotationType()) != null && "org.junit.jupiter.api.Nested".equals(annotationType.getQualifiedName())) {
                return this.isTest(nestedType);
            }
            ++n2;
        }
        return false;
    }
}

