/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.AutomaticModuleNaming;
import org.eclipse.jdt.internal.compiler.env.IModule;

class InternalModuleInfo {
    public final String name;
    public final List<String> requiredModuleNames;
    public final List<String> usedServiceNames;
    public final List<String> providedServiceNames;

    public static InternalModuleInfo fromDescription(IModuleDescription description) throws JavaModelException {
        String name = description.getElementName();
        List<String> requiredModules = Arrays.asList(description.getRequiredModuleNames());
        List<String> usedServices = Arrays.asList(description.getUsedServiceNames());
        List<String> providedServices = Arrays.asList(description.getProvidedServiceNames());
        return new InternalModuleInfo(name, requiredModules, usedServices, providedServices);
    }

    public static InternalModuleInfo fromDeclaration(IModule declaration) {
        String name = new String(declaration.name());
        IModule.IModuleReference[] requires = declaration.requires();
        ArrayList<String> requiredModules = new ArrayList<String>(requires.length);
        IModule.IModuleReference[] iModuleReferenceArray = requires;
        int n = requires.length;
        int n2 = 0;
        while (n2 < n) {
            IModule.IModuleReference required = iModuleReferenceArray[n2];
            requiredModules.add(new String(required.name()));
            ++n2;
        }
        char[][] uses = declaration.uses();
        ArrayList<String> usedServices = new ArrayList<String>(uses.length);
        char[][] cArray = uses;
        int n3 = uses.length;
        int n4 = 0;
        while (n4 < n3) {
            char[] used = cArray[n4];
            usedServices.add(new String(used));
            ++n4;
        }
        IModule.IService[] provides = declaration.provides();
        ArrayList<String> providedServices = new ArrayList<String>(provides.length);
        IModule.IService[] iServiceArray = provides;
        int n5 = provides.length;
        int n6 = 0;
        while (n6 < n5) {
            IModule.IService provided = iServiceArray[n6];
            providedServices.add(new String(provided.name()));
            ++n6;
        }
        return new InternalModuleInfo(name, requiredModules, usedServices, providedServices);
    }

    public static InternalModuleInfo withAutomaticName(String name) {
        return new InternalModuleInfo(name, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public static InternalModuleInfo withAutomaticNameFromFile(File file) {
        char[] name = AutomaticModuleNaming.determineAutomaticModuleNameFromFileName((String)file.getAbsolutePath(), (boolean)true, (boolean)true);
        return InternalModuleInfo.withAutomaticName(new String(name));
    }

    public InternalModuleInfo(String name, List<String> requiredModules, List<String> usedServices, List<String> providedServices) {
        this.name = name;
        this.requiredModuleNames = Collections.unmodifiableList(new ArrayList<String>(requiredModules));
        this.usedServiceNames = Collections.unmodifiableList(new ArrayList<String>(usedServices));
        this.providedServiceNames = Collections.unmodifiableList(new ArrayList<String>(providedServices));
    }

    public int hashCode() {
        int prime = 73303;
        int result = 1;
        result = prime * result + Objects.hashCode(this.name);
        result = prime * result + Objects.hashCode(this.requiredModuleNames);
        result = prime * result + Objects.hashCode(this.usedServiceNames);
        result = prime * result + Objects.hashCode(this.providedServiceNames);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        InternalModuleInfo other = (InternalModuleInfo)o;
        return Objects.equals(other.name, this.name) && Objects.equals(other.requiredModuleNames, this.requiredModuleNames) && Objects.equals(other.usedServiceNames, this.usedServiceNames) && Objects.equals(other.providedServiceNames, this.providedServiceNames);
    }
}

