/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle.bs.importer;

import ch.epfl.scala.bsp4j.BuildClient;
import com.microsoft.gradle.bs.importer.BuildServerConnection;
import com.microsoft.gradle.bs.importer.GradleBuildClient;
import com.microsoft.gradle.bs.importer.NamedPipeStream;
import com.microsoft.gradle.bs.importer.model.NamedPipeConnectionException;
import com.microsoft.java.builder.BuildStateManager;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.managers.DigestStore;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.osgi.framework.BundleContext;

public class ImporterPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.microsoft.gradle.buildServer.importer";
    private Map<IPath, Pair<BuildServerConnection, BuildClient>> buildServers = new ConcurrentHashMap<IPath, Pair<BuildServerConnection, BuildClient>>();
    private static ImporterPlugin instance;
    private DigestStore digestStore;
    private static String bundleVersion;

    static {
        bundleVersion = "";
    }

    public void start(BundleContext context) throws Exception {
        BuildStateManager.getBuildStateManager().startup();
        instance = this;
        bundleVersion = context.getBundle().getVersion().toString();
        this.digestStore = new DigestStore(this.getStateLocation().toFile());
    }

    public void stop(BundleContext context) throws Exception {
        for (Pair<BuildServerConnection, BuildClient> pair : this.buildServers.values()) {
            ((BuildServerConnection)pair.getLeft()).buildShutdown();
            ((BuildServerConnection)pair.getLeft()).onBuildExit();
        }
    }

    public static ImporterPlugin getInstance() {
        return instance;
    }

    public static String getBundleVersion() {
        return bundleVersion;
    }

    public static DigestStore getDigestStore() {
        return ImporterPlugin.instance.digestStore;
    }

    public static BuildServerConnection getBuildServerConnection(IPath rootPath) throws CoreException {
        return ImporterPlugin.getBuildServerConnection(rootPath, false);
    }

    public static BuildServerConnection getBuildServerConnection(IPath rootPath, boolean createIfMissing) throws CoreException {
        Pair<BuildServerConnection, BuildClient> pair = ImporterPlugin.instance.buildServers.get(rootPath);
        if (pair != null) {
            return (BuildServerConnection)pair.getLeft();
        }
        if (!createIfMissing) {
            return null;
        }
        if (ImporterPlugin.instance.buildServers.size() > 0) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, "Not support multiple workspaces."));
        }
        try {
            NamedPipeStream pipeStream = new NamedPipeStream();
            GradleBuildClient client = new GradleBuildClient();
            Launcher launcher = new Launcher.Builder().setOutput(pipeStream.getOutputStream()).setInput(pipeStream.getInputStream()).setLocalService((Object)client).setExecutorService(Executors.newCachedThreadPool()).setRemoteInterface(BuildServerConnection.class).create();
            launcher.startListening();
            BuildServerConnection server = (BuildServerConnection)launcher.getRemoteProxy();
            client.onConnectWithServer(server);
            ImporterPlugin.instance.buildServers.put(rootPath, (Pair<BuildServerConnection, BuildClient>)Pair.of((Object)server, (Object)client));
            return server;
        }
        catch (NamedPipeConnectionException e) {
            JavaLanguageServerPlugin.logException((String)"Failed to connect to build server using named pipe.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PLUGIN_ID, "Failed to start build server.", (Throwable)e));
        }
    }
}

