/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import com.vladsch.flexmark.html2md.converter.HtmlConverterOptions;
import com.vladsch.flexmark.html2md.converter.HtmlMarkdownWriter;
import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterContext;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRenderer;
import com.vladsch.flexmark.html2md.converter.HtmlNodeRendererHandler;
import com.vladsch.flexmark.html2md.converter.LinkConversion;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.LineAppendable;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import java.io.Reader;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.javadoc.AbstractJavaDocConverter;
import org.eclipse.jdt.ls.core.internal.javadoc.TableHelper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class JavaDoc2MarkdownConverter
extends AbstractJavaDocConverter {
    private static final String MARKDOWN_SPACE = "&nbsp;";
    private static final String LINEBREAK = "\n";
    private static final String DOUBLE_SPACE = "  ";
    private static final Set<String> EXPLICIT_LINK_TEXT_TAGS = Set.of(FlexmarkHtmlConverter.EXPLICIT_LINK_TEXT_TAGS);
    private final FlexmarkHtmlConverter converter;
    private final DataHolder flexmarkOptions = JavaDoc2MarkdownConverter.initOptions();
    private final HtmlConverterOptions myHtmlConverterOptions = new HtmlConverterOptions(this.flexmarkOptions);

    public JavaDoc2MarkdownConverter(Reader reader) {
        super(reader);
        this.converter = this.initConverter(this.flexmarkOptions);
    }

    public JavaDoc2MarkdownConverter(String javadoc) {
        super(javadoc);
        this.converter = this.initConverter(this.flexmarkOptions);
    }

    private static DataHolder initOptions() {
        MutableDataSet flexmarkOptions = new MutableDataSet();
        String[] unwrappedTags = (String[])FlexmarkHtmlConverter.UNWRAPPED_TAGS.getDefaultValue();
        String[] extendedUnwrappedTags = Arrays.copyOf(unwrappedTags, unwrappedTags.length + 1);
        extendedUnwrappedTags[unwrappedTags.length] = "abbr";
        flexmarkOptions.set(FlexmarkHtmlConverter.UNWRAPPED_TAGS, (Object)extendedUnwrappedTags);
        flexmarkOptions.set(FlexmarkHtmlConverter.OUTPUT_ATTRIBUTES_ID, (Object)false);
        flexmarkOptions.set(FlexmarkHtmlConverter.TYPOGRAPHIC_SMARTS, (Object)false);
        return flexmarkOptions;
    }

    private FlexmarkHtmlConverter initConverter(DataHolder flexmarkOptions) {
        FlexmarkHtmlConverter converter = FlexmarkHtmlConverter.builder((DataHolder)flexmarkOptions).htmlNodeRendererFactory(options -> new HtmlNodeRenderer(){

            public Set<HtmlNodeRendererHandler<?>> getHtmlNodeRendererHandlers() {
                return Set.of(new HtmlNodeRendererHandler("a", Element.class, (arg_0, arg_1, arg_2) -> JavaDoc2MarkdownConverter.access$1(JavaDoc2MarkdownConverter.this, arg_0, arg_1, arg_2)), new HtmlNodeRendererHandler("tt", Element.class, (arg_0, arg_1, arg_2) -> JavaDoc2MarkdownConverter.access$2(JavaDoc2MarkdownConverter.this, arg_0, arg_1, arg_2)), new HtmlNodeRendererHandler("dfn", Element.class, (arg_0, arg_1, arg_2) -> JavaDoc2MarkdownConverter.access$3(JavaDoc2MarkdownConverter.this, arg_0, arg_1, arg_2)), new HtmlNodeRendererHandler("dl", Element.class, (arg_0, arg_1, arg_2) -> JavaDoc2MarkdownConverter.access$4(JavaDoc2MarkdownConverter.this, arg_0, arg_1, arg_2)));
            }
        }).build();
        return converter;
    }

    @Override
    public String convert(String html) {
        Document document = Jsoup.parse((String)html);
        this.sanitize(document);
        StringBuilder markdown = new StringBuilder();
        JavaLanguageServerPlugin.logInfo("Converting html to markdown");
        this.converter.convert((Node)document, (Appendable)markdown, -1);
        return this.fixSnippet(markdown.toString());
    }

    private void sanitize(Document document) {
        document.select("table").forEach(TableHelper::normalizeTableHeaders);
        JavaDoc2MarkdownConverter.separateConsecutiveCodeTags(document);
    }

    private void processA(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        if (element.hasAttr("href")) {
            LinkConversion conv = this.myHtmlConverterOptions.extInlineLink;
            if (conv.isSuppressed()) {
                return;
            }
            String href = element.attr("href");
            if (href.trim().isEmpty() || href.startsWith("eclipse-javadoc:") || href.startsWith("#")) {
                context.renderChildren((Node)element, false, null);
                return;
            }
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)href, Boolean.valueOf(false));
            Object useHref = JDTUtils.cleanupURL(resolvedLink.getUrl());
            if (out.isPreFormatted()) {
                int hashIndex;
                int slashIndex = ((String)useHref).lastIndexOf(47);
                if (slashIndex != -1 && (hashIndex = ((String)useHref).indexOf(35, slashIndex)) != -1 && slashIndex + 1 == hashIndex) {
                    useHref = ((String)useHref).substring(0, slashIndex) + ((String)useHref).substring(hashIndex);
                }
                out.append((CharSequence)useHref);
            } else if (conv.isParsed()) {
                String title;
                context.pushState((Node)element);
                String textNodes = context.processTextNodes((Node)element);
                String text = textNodes.trim();
                String string = title = element.hasAttr("title") ? element.attr("title") : null;
                if (!(text.isEmpty() && ((String)useHref).contains("#") && (JavaDoc2MarkdownConverter.isHeading(element.parent()) || ((String)useHref).equals("#") || context.getState() != null && context.getState().getAttributes().get((CharSequence)"id") != null && !context.getState().getAttributes().get((CharSequence)"id").getValue().isEmpty()))) {
                    if (this.myHtmlConverterOptions.extractAutoLinks && href.equals(text) && (title == null || title.isEmpty())) {
                        if (this.myHtmlConverterOptions.wrapAutoLinks) {
                            out.append('<');
                        }
                        out.append((CharSequence)useHref);
                        if (this.myHtmlConverterOptions.wrapAutoLinks) {
                            out.append('>');
                        }
                        context.transferIdToParent();
                    } else if (!conv.isTextOnly() && !((String)useHref).startsWith("javascript:")) {
                        Reference reference;
                        boolean handled = false;
                        if (conv.isReference() && !JavaDoc2MarkdownConverter.hasChildrenOfType(element, EXPLICIT_LINK_TEXT_TAGS) && (reference = context.getOrCreateReference((String)useHref, text, title)) != null) {
                            handled = true;
                            if (reference.getReference().equals((Object)text)) {
                                ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append('[')).append((CharSequence)text)).append((CharSequence)"][]");
                            } else {
                                ((HtmlMarkdownWriter)((HtmlMarkdownWriter)((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append('[')).append((CharSequence)text)).append((CharSequence)"][")).append((CharSequence)reference.getReference())).append(']');
                            }
                        }
                        if (!handled) {
                            out.append('[');
                            out.append((CharSequence)text);
                            out.append(']');
                            ((HtmlMarkdownWriter)out.append('(')).append((CharSequence)useHref);
                            if (title != null) {
                                ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append((CharSequence)" \"")).append((CharSequence)title.replace(LINEBREAK, this.myHtmlConverterOptions.eolInTitleAttribute).replace("\"", "\\\""))).append('\"');
                            }
                            out.append((CharSequence)")");
                        }
                    } else if (href.equals(text)) {
                        out.append((CharSequence)useHref);
                    } else {
                        out.append((CharSequence)text);
                    }
                    context.excludeAttributes(new String[]{"href", "title"});
                    context.popState((LineAppendable)out);
                } else {
                    context.transferIdToParent();
                    context.popState(null);
                }
            } else if (!conv.isSuppressed()) {
                context.processWrapped((Node)element, null, true);
            }
        } else {
            boolean stripIdAttribute = false;
            if (element.childNodeSize() == 0 && element.parent().tagName().equals("body")) {
                stripIdAttribute = true;
            }
            context.processTextNodes((Node)element, stripIdAttribute);
        }
    }

    private static boolean isHeading(Element element) {
        if (element == null) {
            return false;
        }
        String tagName = element.tagName().toLowerCase();
        String[] stringArray = FlexmarkHtmlConverter.HEADING_NODES;
        int n = FlexmarkHtmlConverter.HEADING_NODES.length;
        int n2 = 0;
        while (n2 < n) {
            String headingTag = stringArray[n2];
            if (tagName.equals(headingTag)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasChildrenOfType(Element element, Set<String> nodeNames) {
        for (Node child : element.children()) {
            if (!nodeNames.contains(child.nodeName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static void separateConsecutiveCodeTags(Document document) {
        Elements codeElements = document.select("tt, code");
        for (Element code : codeElements) {
            Node nextNode;
            Element nextSibling = code.nextElementSibling();
            if (nextSibling == null || !JavaDoc2MarkdownConverter.isCodeTag(nextSibling.tagName()) || (nextNode = code.nextSibling()) != nextSibling) continue;
            code.after((Node)new TextNode(" "));
        }
    }

    private static boolean isCodeTag(String tagName) {
        return "tt".equals(tagName) || "code".equals(tagName);
    }

    private void processTt(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        String text = element.ownText();
        BasedSequence basedText = BasedSequence.of((CharSequence)text);
        int backTickCount = JavaDoc2MarkdownConverter.getMaxRepeatedChars((CharSequence)basedText, '`', 1);
        CharSequence backTicks = RepeatedSequence.repeatOf((CharSequence)"`", (int)backTickCount);
        context.inlineCode(() -> context.processTextNodes((Node)element, false, backTicks));
    }

    private void processDfn(Element node, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        String text = node.text();
        if (text.isBlank()) {
            out.append((CharSequence)text);
            return;
        }
        ((HtmlMarkdownWriter)((HtmlMarkdownWriter)out.append((CharSequence)"_")).append((CharSequence)text)).append((CharSequence)"_");
    }

    private void processDl(Element element, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        Node item;
        context.pushState((Node)element);
        boolean lastWasDefinition = true;
        boolean firstItem = true;
        while ((item = context.next()) != null) {
            switch (item.nodeName().toLowerCase()) {
                case "dt": {
                    ((HtmlMarkdownWriter)out.blankLineIf(lastWasDefinition)).lineIf(!firstItem);
                    context.processTextNodes(item, false);
                    out.lineWithTrailingSpaces(2);
                    lastWasDefinition = false;
                    firstItem = false;
                    break;
                }
                case "dd": {
                    this.handleDefinition((Element)item, context, out);
                    lastWasDefinition = true;
                    firstItem = false;
                    break;
                }
            }
        }
        context.popState((LineAppendable)out);
    }

    private void handleDefinition(Element item, HtmlNodeConverterContext context, HtmlMarkdownWriter out) {
        context.pushState((Node)item);
        int options = out.getOptions();
        Elements children = item.children();
        boolean firstIsPara = false;
        if (!children.isEmpty() && ((Element)children.get(0)).tagName().equalsIgnoreCase("p")) {
            out.blankLine();
            firstIsPara = true;
        }
        int count = this.myHtmlConverterOptions.listContentIndent ? this.myHtmlConverterOptions.definitionMarkerSpaces + 1 : 4;
        CharSequence childPrefix = RepeatedSequence.repeatOf((CharSequence)" ", (int)count);
        out.append(' ', this.myHtmlConverterOptions.definitionMarkerSpaces);
        out.pushPrefix();
        out.addPrefix(childPrefix, true);
        out.setOptions(options);
        if (firstIsPara) {
            context.renderChildren((Node)item, true, null);
        } else {
            context.processTextNodes((Node)item, false);
        }
        out.lineWithTrailingSpaces(2);
        out.popPrefix();
        context.popState((LineAppendable)out);
    }

    private static int getMaxRepeatedChars(CharSequence text, char ch, int min) {
        int maxCount = 0;
        int currentCount = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == ch) {
                if (++currentCount > maxCount) {
                    maxCount = currentCount;
                }
            } else {
                currentCount = 0;
            }
            ++i;
        }
        return maxCount > 0 ? maxCount + 1 : min;
    }

    private String fixSnippet(String value) {
        if (value.contains("SNIPPET")) {
            StringBuilder builder = new StringBuilder();
            value.lines().forEach(line -> {
                if (((String)line).contains("SNIPPET") && ((String)(line = ((String)line).stripLeading())).startsWith("SNIPPET")) {
                    line = ((String)line).replaceFirst("SNIPPET", "");
                    if (!((String)(line = JavaDoc2MarkdownConverter.replaceLeadingSpaces((String)line))).endsWith(DOUBLE_SPACE)) {
                        line = (String)line + DOUBLE_SPACE;
                    }
                }
                builder.append((String)line);
                builder.append(LINEBREAK);
            });
            value = builder.toString();
        }
        return value;
    }

    private static String replaceLeadingSpaces(String str) {
        int i = 0;
        while (str.length() > i + 1 && str.charAt(i) == ' ') {
            str = str.replaceFirst(" ", MARKDOWN_SPACE);
            i += MARKDOWN_SPACE.length();
        }
        return str;
    }

    static /* synthetic */ void access$1(JavaDoc2MarkdownConverter javaDoc2MarkdownConverter, Element element, HtmlNodeConverterContext htmlNodeConverterContext, HtmlMarkdownWriter htmlMarkdownWriter) {
        javaDoc2MarkdownConverter.processA(element, htmlNodeConverterContext, htmlMarkdownWriter);
    }

    static /* synthetic */ void access$2(JavaDoc2MarkdownConverter javaDoc2MarkdownConverter, Element element, HtmlNodeConverterContext htmlNodeConverterContext, HtmlMarkdownWriter htmlMarkdownWriter) {
        javaDoc2MarkdownConverter.processTt(element, htmlNodeConverterContext, htmlMarkdownWriter);
    }

    static /* synthetic */ void access$3(JavaDoc2MarkdownConverter javaDoc2MarkdownConverter, Element element, HtmlNodeConverterContext htmlNodeConverterContext, HtmlMarkdownWriter htmlMarkdownWriter) {
        javaDoc2MarkdownConverter.processDfn(element, htmlNodeConverterContext, htmlMarkdownWriter);
    }

    static /* synthetic */ void access$4(JavaDoc2MarkdownConverter javaDoc2MarkdownConverter, Element element, HtmlNodeConverterContext htmlNodeConverterContext, HtmlMarkdownWriter htmlMarkdownWriter) {
        javaDoc2MarkdownConverter.processDl(element, htmlNodeConverterContext, htmlMarkdownWriter);
    }
}

