/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.TextProcessor;

public class BasicElementLabels {
    private BasicElementLabels() {
    }

    private static String markLTR(String string, String delimiters) {
        return TextProcessor.process((String)string, (String)delimiters);
    }

    public static String getPathLabel(IPath path, boolean isOSPath) {
        String label = isOSPath ? path.toOSString() : path.makeRelative().toString();
        return BasicElementLabels.markLTR(label, "/\\:.");
    }

    public static String getPathLabel(File file) {
        return BasicElementLabels.markLTR(file.getAbsolutePath(), "/\\:.");
    }

    public static String getFilePattern(String name) {
        return BasicElementLabels.markLTR(name, "*.?/\\:.");
    }

    public static String getURLPart(String name) {
        return BasicElementLabels.markLTR(name, ":@?-#/\\:.");
    }

    public static String getResourceName(IResource resource) {
        return BasicElementLabels.markLTR(resource.getName(), ":.");
    }

    public static String getResourceName(String resourceName) {
        return BasicElementLabels.markLTR(resourceName, ":.");
    }

    public static String getVersionName(String name) {
        return BasicElementLabels.markLTR(name, ":.");
    }

    public static String getJavaElementName(String name) {
        return BasicElementLabels.markLTR(name, "<>()?,{}.:");
    }
}

