/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac.problem;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.JavacBindingResolver;
import org.eclipse.jdt.core.dom.JdtCoreDomPackagePrivateUtility;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;
import org.eclipse.jdt.internal.javac.problem.JavacProblemReporter;

public class JavacProblemDiscovery
extends ASTVisitor {
    private JavacProblemReporter reporter = null;
    private static final int TYPE_HAS_METHOD = 1;
    private static final int INTERFACE_HAS_METHOD = 2;

    public JavacProblemDiscovery(Map<String, String> compilerOptions, ReferenceContext referenceContext) {
        this.reporter = new JavacProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), new CompilerOptions(compilerOptions), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()), referenceContext);
    }

    public boolean visit(ParameterizedType node) {
        ASTNode parent = node.getParent();
        if (parent instanceof ClassInstanceCreation) {
            VariableDeclarationStatement vds;
            Type leftType;
            VariableDeclarationFragment vdf;
            ClassInstanceCreation cic = (ClassInstanceCreation)parent;
            Type rightType = cic.getType();
            ASTNode aSTNode = cic.getParent();
            if (aSTNode instanceof VariableDeclarationFragment && (aSTNode = (vdf = (VariableDeclarationFragment)aSTNode).getParent()) instanceof VariableDeclarationStatement && (leftType = (vds = (VariableDeclarationStatement)aSTNode).getType()).isParameterizedType() && rightType.isParameterizedType() && leftType instanceof ParameterizedType) {
                ParameterizedType ltt = (ParameterizedType)leftType;
                if (rightType instanceof ParameterizedType) {
                    ITypeBinding[] rightListArr;
                    ParameterizedType rtt = (ParameterizedType)rightType;
                    List leftList = ltt.typeArguments();
                    List rightList = rtt.typeArguments();
                    if (leftList.size() > 0 && rightList.size() == leftList.size() && (rightListArr = (ITypeBinding[])rightList.stream().map(o -> (Type)o).map(x -> x.resolveBinding()).filter(Objects::nonNull).toArray(ITypeBinding[]::new)).length == leftList.size()) {
                        this.reporter.redundantSpecificationOfTypeArguments((Type)rtt, rightListArr);
                    }
                }
            }
        }
        return true;
    }

    public boolean visit(Assignment node) {
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        if (this.reporter.options.reportMissingOverrideAnnotationForInterfaceMethodImplementation) {
            return this.visitMethodDeclarationForOverrides(node);
        }
        return true;
    }

    private boolean visitMethodDeclarationForOverrides(MethodDeclaration node) {
        JavacBindingResolver jcbr;
        ITypeBinding objBinding;
        IMethodBinding b = node.resolveBinding();
        if (b == null) {
            return true;
        }
        boolean hasOverridesAnnotation = false;
        List mods = node.modifiers();
        for (int i = 0; i < mods.size() && !hasOverridesAnnotation; ++i) {
            MarkerAnnotation ma;
            String s;
            ASTNode o = (ASTNode)mods.get(i);
            if (!(o instanceof MarkerAnnotation) || !"Override".equals(s = (ma = (MarkerAnnotation)o).getTypeName().toString())) continue;
            hasOverridesAnnotation = true;
        }
        ITypeBinding tb = b.getDeclaringClass();
        int shouldHaveOverride = this.typeHasMethodRecurse(b, tb, false);
        boolean isInterface = tb.isInterface();
        if (isInterface && this.typeHasMethod(b, objBinding = (jcbr = JdtCoreDomPackagePrivateUtility.getJavacBindingResolverOrNull(node.getAST())).resolveWellKnownType("java.lang.Object"))) {
            shouldHaveOverride |= 2;
        }
        if (!hasOverridesAnnotation) {
            if ((shouldHaveOverride & 1) == 1) {
                this.reporter.missingOverrideAnnotation(node);
            } else if (shouldHaveOverride == 2) {
                this.reporter.missingOverrideAnnotationForInterfaceMethodImplementation(node);
            }
        }
        return true;
    }

    private int typeHasMethodRecurse(IMethodBinding mb, ITypeBinding tb, boolean checkType) {
        if (mb == null || tb == null) {
            return 0;
        }
        if (checkType && this.typeHasMethod(mb, tb)) {
            if (tb.isInterface()) {
                return 2;
            }
            return 1;
        }
        ITypeBinding[] interfaces = tb.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                int recurse = this.typeHasMethodRecurse(mb, interfaces[i], true);
                if (recurse == 0) continue;
                return recurse;
            }
        }
        ITypeBinding sup = tb.getSuperclass();
        int supRet = this.typeHasMethodRecurse(mb, sup, true);
        return supRet;
    }

    private boolean typeHasMethod(IMethodBinding mb, ITypeBinding tb) {
        IMethodBinding[] all;
        if (mb == null || tb == null) {
            return false;
        }
        if (tb instanceof JavacTypeBinding) {
            JavacTypeBinding jct = (JavacTypeBinding)tb;
            v0 = jct.getDeclaredMethods(false);
        } else {
            v0 = all = tb.getDeclaredMethods();
        }
        if (all == null) {
            return false;
        }
        for (int i = 0; i < all.length; ++i) {
            if (!mb.overrides(all[i])) continue;
            return true;
        }
        return false;
    }
}

