/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthSpinnerUI
extends BasicSpinnerUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;
    private EditorFocusHandler editorFocusHandler = new EditorFocusHandler();

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSpinnerUI();
    }

    @Override
    protected void installListeners() {
        JFormattedTextField jFormattedTextField;
        super.installListeners();
        this.spinner.addPropertyChangeListener(this);
        JComponent jComponent = this.spinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor && (jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField()) != null) {
            jFormattedTextField.addFocusListener(this.editorFocusHandler);
        }
    }

    @Override
    protected void uninstallListeners() {
        JFormattedTextField jFormattedTextField;
        super.uninstallListeners();
        this.spinner.removePropertyChangeListener(this);
        JComponent jComponent = this.spinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor && (jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField()) != null) {
            jFormattedTextField.removeFocusListener(this.editorFocusHandler);
        }
    }

    @Override
    protected void installDefaults() {
        LayoutManager layoutManager = this.spinner.getLayout();
        if (layoutManager == null || layoutManager instanceof UIResource) {
            this.spinner.setLayout(this.createLayout());
        }
        this.updateStyle(this.spinner);
    }

    private void updateStyle(JSpinner jSpinner) {
        SynthContext synthContext = this.getContext(jSpinner, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle && synthStyle != null) {
            this.installKeyboardActions();
        }
        synthContext.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        if (this.spinner.getLayout() instanceof UIResource) {
            this.spinner.setLayout(null);
        }
        SynthContext synthContext = this.getContext(this.spinner, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    @Override
    protected LayoutManager createLayout() {
        return new SpinnerLayout();
    }

    @Override
    protected Component createPreviousButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(5);
        synthArrowButton.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(synthArrowButton);
        return synthArrowButton;
    }

    @Override
    protected Component createNextButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(1);
        synthArrowButton.setName("Spinner.nextButton");
        this.installNextButtonListeners(synthArrowButton);
        return synthArrowButton;
    }

    @Override
    protected JComponent createEditor() {
        JComponent jComponent = this.spinner.getEditor();
        jComponent.setName("Spinner.editor");
        this.updateEditorAlignment(jComponent);
        return jComponent;
    }

    @Override
    protected void replaceEditor(JComponent jComponent, JComponent jComponent2) {
        JFormattedTextField jFormattedTextField;
        this.spinner.remove(jComponent);
        this.spinner.add((Component)jComponent2, "Editor");
        if (jComponent instanceof JSpinner.DefaultEditor && (jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField()) != null) {
            jFormattedTextField.removeFocusListener(this.editorFocusHandler);
        }
        if (jComponent2 instanceof JSpinner.DefaultEditor && (jFormattedTextField = ((JSpinner.DefaultEditor)jComponent2).getTextField()) != null) {
            jFormattedTextField.addFocusListener(this.editorFocusHandler);
        }
    }

    private void updateEditorAlignment(JComponent jComponent) {
        if (jComponent instanceof JSpinner.DefaultEditor) {
            SynthContext synthContext = this.getContext(this.spinner);
            Integer n = (Integer)synthContext.getStyle().get(synthContext, "Spinner.editorAlignment");
            JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
            if (n != null) {
                jFormattedTextField.setHorizontalAlignment(n);
            }
            jFormattedTextField.putClientProperty("JComponent.sizeVariant", this.spinner.getClientProperty("JComponent.sizeVariant"));
        }
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, SynthLookAndFeel.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(jComponent, this.style, n);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintSpinnerBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintSpinnerBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JSpinner jSpinner = (JSpinner)propertyChangeEvent.getSource();
        SpinnerUI spinnerUI = jSpinner.getUI();
        if (spinnerUI instanceof SynthSpinnerUI) {
            SynthSpinnerUI synthSpinnerUI = (SynthSpinnerUI)spinnerUI;
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                synthSpinnerUI.updateStyle(jSpinner);
            }
        }
    }

    private class EditorFocusHandler
    implements FocusListener {
        private EditorFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            SynthSpinnerUI.this.spinner.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            SynthSpinnerUI.this.spinner.repaint();
        }
    }

    private static class SpinnerLayout
    implements LayoutManager,
    UIResource {
        private Component nextButton = null;
        private Component previousButton = null;
        private Component editor = null;

        private SpinnerLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            if ("Next".equals(string)) {
                this.nextButton = component;
            } else if ("Previous".equals(string)) {
                this.previousButton = component;
            } else if ("Editor".equals(string)) {
                this.editor = component;
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (component == this.nextButton) {
                this.nextButton = null;
            } else if (component == this.previousButton) {
                this.previousButton = null;
            } else if (component == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component component) {
            return component == null ? new Dimension(0, 0) : component.getPreferredSize();
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            Dimension dimension3 = this.preferredSize(this.editor);
            dimension3.height = (dimension3.height + 1) / 2 * 2;
            Dimension dimension4 = new Dimension(dimension3.width, dimension3.height);
            dimension4.width += Math.max(dimension.width, dimension2.width);
            Insets insets = container.getInsets();
            dimension4.width += insets.left + insets.right;
            dimension4.height += insets.top + insets.bottom;
            return dimension4;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private void setBounds(Component component, int n, int n2, int n3, int n4) {
            if (component != null) {
                component.setBounds(n, n2, n3, n4);
            }
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            Insets insets = container.getInsets();
            int n3 = container.getWidth() - (insets.left + insets.right);
            int n4 = container.getHeight() - (insets.top + insets.bottom);
            Dimension dimension = this.preferredSize(this.nextButton);
            Dimension dimension2 = this.preferredSize(this.previousButton);
            int n5 = n4 / 2;
            int n6 = n4 - n5;
            int n7 = Math.max(dimension.width, dimension2.width);
            int n8 = n3 - n7;
            if (container.getComponentOrientation().isLeftToRight()) {
                n2 = insets.left;
                n = n2 + n8;
            } else {
                n = insets.left;
                n2 = n + n7;
            }
            int n9 = insets.top + n5;
            this.setBounds(this.editor, n2, insets.top, n8, n4);
            this.setBounds(this.nextButton, n, insets.top, n7, n5);
            this.setBounds(this.previousButton, n, n9, n7, n6);
        }
    }
}

