/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.WriteableUserPath;

final class ShutdownHook
implements Runnable {
    private final PlatformRecorder recorder;
    Object tlabDummyObject;

    ShutdownHook(PlatformRecorder platformRecorder) {
        this.recorder = platformRecorder;
    }

    @Override
    public void run() {
        this.tlabDummyObject = new Object();
        for (PlatformRecording platformRecording : this.recorder.getRecordings()) {
            if (!platformRecording.getDumpOnExit() || platformRecording.getState() != RecordingState.RUNNING) continue;
            this.dump(platformRecording);
        }
        this.recorder.destroy();
    }

    private void dump(PlatformRecording platformRecording) {
        try {
            WriteableUserPath writeableUserPath = platformRecording.getDestination();
            if (writeableUserPath == null) {
                writeableUserPath = this.makeDumpOnExitPath(platformRecording);
                platformRecording.setDestination(writeableUserPath);
            }
            if (writeableUserPath != null) {
                platformRecording.stop("Dump on exit");
            }
        }
        catch (Exception exception) {
            Logger.log(LogTag.JFR, LogLevel.DEBUG, () -> "Could not dump recording " + platformRecording.getName() + " on exit.");
        }
    }

    private WriteableUserPath makeDumpOnExitPath(final PlatformRecording platformRecording) {
        try {
            final String string = Utils.makeFilename(platformRecording.getRecording());
            AccessControlContext accessControlContext = platformRecording.getNoDestinationDumpOnExitAccessControlContext();
            return AccessController.doPrivileged(new PrivilegedExceptionAction<WriteableUserPath>(){

                @Override
                public WriteableUserPath run() throws Exception {
                    return new WriteableUserPath(platformRecording.getDumpOnExitDirectory().toPath().resolve(string));
                }
            }, accessControlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof SecurityException) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Not allowed to create dump path for recording " + platformRecording.getId() + " on exit.");
            }
            if (throwable instanceof IOException) {
                Logger.log(LogTag.JFR, LogLevel.WARN, "Could not dump " + platformRecording.getId() + " on exit.");
            }
            return null;
        }
    }

    static final class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            JVM.getJVM().uncaughtException(thread, throwable);
        }
    }
}

