/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.encoding.MarshalInputStream;
import com.sun.corba.se.impl.encoding.MarshalOutputStream;
import com.sun.corba.se.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public final class CodeSetComponentInfo {
    private CodeSetComponent forCharData;
    private CodeSetComponent forWCharData;
    public static final CodeSetComponentInfo JAVASOFT_DEFAULT_CODESETS;
    public static final CodeSetContext LOCAL_CODE_SETS;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CodeSetComponentInfo)) {
            return false;
        }
        CodeSetComponentInfo codeSetComponentInfo = (CodeSetComponentInfo)object;
        return this.forCharData.equals(codeSetComponentInfo.forCharData) && this.forWCharData.equals(codeSetComponentInfo.forWCharData);
    }

    public int hashCode() {
        return this.forCharData.hashCode() ^ this.forWCharData.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CodeSetComponentInfo(");
        stringBuffer.append("char_data:");
        stringBuffer.append(this.forCharData.toString());
        stringBuffer.append(" wchar_data:");
        stringBuffer.append(this.forWCharData.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public CodeSetComponentInfo() {
        this.forCharData = CodeSetComponentInfo.JAVASOFT_DEFAULT_CODESETS.forCharData;
        this.forWCharData = CodeSetComponentInfo.JAVASOFT_DEFAULT_CODESETS.forWCharData;
    }

    public CodeSetComponentInfo(CodeSetComponent codeSetComponent, CodeSetComponent codeSetComponent2) {
        this.forCharData = codeSetComponent;
        this.forWCharData = codeSetComponent2;
    }

    public void read(MarshalInputStream marshalInputStream) {
        this.forCharData = new CodeSetComponent();
        this.forCharData.read(marshalInputStream);
        this.forWCharData = new CodeSetComponent();
        this.forWCharData.read(marshalInputStream);
    }

    public void write(MarshalOutputStream marshalOutputStream) {
        this.forCharData.write(marshalOutputStream);
        this.forWCharData.write(marshalOutputStream);
    }

    public CodeSetComponent getCharComponent() {
        return this.forCharData;
    }

    public CodeSetComponent getWCharComponent() {
        return this.forWCharData;
    }

    public static CodeSetComponent createFromString(String string) {
        ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get("rpc.encoding");
        if (string == null || string.length() == 0) {
            throw oRBUtilSystemException.badCodeSetString();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ", false);
        int n = 0;
        int[] nArray = null;
        try {
            n = Integer.decode(stringTokenizer.nextToken());
            if (OSFCodeSetRegistry.lookupEntry(n) == null) {
                throw oRBUtilSystemException.unknownNativeCodeset(new Integer(n));
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>(10);
            while (stringTokenizer.hasMoreTokens()) {
                Integer n2 = Integer.decode(stringTokenizer.nextToken());
                if (OSFCodeSetRegistry.lookupEntry(n2) == null) {
                    throw oRBUtilSystemException.unknownConversionCodeSet(n2);
                }
                arrayList.add(n2);
            }
            nArray = new int[arrayList.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw oRBUtilSystemException.invalidCodeSetNumber(numberFormatException);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw oRBUtilSystemException.invalidCodeSetString(noSuchElementException, (Object)string);
        }
        return new CodeSetComponent(n, nArray);
    }

    static {
        CodeSetComponent codeSetComponent = new CodeSetComponent(OSFCodeSetRegistry.ISO_8859_1.getNumber(), new int[]{OSFCodeSetRegistry.UTF_8.getNumber(), OSFCodeSetRegistry.ISO_646.getNumber()});
        CodeSetComponent codeSetComponent2 = new CodeSetComponent(OSFCodeSetRegistry.UTF_16.getNumber(), new int[]{OSFCodeSetRegistry.UCS_2.getNumber()});
        JAVASOFT_DEFAULT_CODESETS = new CodeSetComponentInfo(codeSetComponent, codeSetComponent2);
        LOCAL_CODE_SETS = new CodeSetContext(OSFCodeSetRegistry.ISO_8859_1.getNumber(), OSFCodeSetRegistry.UTF_16.getNumber());
    }

    public static final class CodeSetContext {
        private int char_data;
        private int wchar_data;

        public CodeSetContext() {
        }

        public CodeSetContext(int n, int n2) {
            this.char_data = n;
            this.wchar_data = n2;
        }

        public void read(MarshalInputStream marshalInputStream) {
            this.char_data = marshalInputStream.read_ulong();
            this.wchar_data = marshalInputStream.read_ulong();
        }

        public void write(MarshalOutputStream marshalOutputStream) {
            marshalOutputStream.write_ulong(this.char_data);
            marshalOutputStream.write_ulong(this.wchar_data);
        }

        public int getCharCodeSet() {
            return this.char_data;
        }

        public int getWCharCodeSet() {
            return this.wchar_data;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CodeSetContext char set: ");
            stringBuffer.append(Integer.toHexString(this.char_data));
            stringBuffer.append(" wchar set: ");
            stringBuffer.append(Integer.toHexString(this.wchar_data));
            return stringBuffer.toString();
        }
    }

    public static final class CodeSetComponent {
        int nativeCodeSet;
        int[] conversionCodeSets;

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CodeSetComponent)) {
                return false;
            }
            CodeSetComponent codeSetComponent = (CodeSetComponent)object;
            return this.nativeCodeSet == codeSetComponent.nativeCodeSet && Arrays.equals(this.conversionCodeSets, codeSetComponent.conversionCodeSets);
        }

        public int hashCode() {
            int n = this.nativeCodeSet;
            for (int i = 0; i < this.conversionCodeSets.length; ++i) {
                n = 37 * n + this.conversionCodeSets[i];
            }
            return n;
        }

        public CodeSetComponent() {
        }

        public CodeSetComponent(int n, int[] nArray) {
            this.nativeCodeSet = n;
            this.conversionCodeSets = nArray == null ? new int[0] : nArray;
        }

        public void read(MarshalInputStream marshalInputStream) {
            this.nativeCodeSet = marshalInputStream.read_ulong();
            int n = marshalInputStream.read_long();
            this.conversionCodeSets = new int[n];
            marshalInputStream.read_ulong_array(this.conversionCodeSets, 0, n);
        }

        public void write(MarshalOutputStream marshalOutputStream) {
            marshalOutputStream.write_ulong(this.nativeCodeSet);
            marshalOutputStream.write_long(this.conversionCodeSets.length);
            marshalOutputStream.write_ulong_array(this.conversionCodeSets, 0, this.conversionCodeSets.length);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("CodeSetComponent(");
            stringBuffer.append("native:");
            stringBuffer.append(Integer.toHexString(this.nativeCodeSet));
            stringBuffer.append(" conversion:");
            if (this.conversionCodeSets == null) {
                stringBuffer.append("null");
            } else {
                for (int i = 0; i < this.conversionCodeSets.length; ++i) {
                    stringBuffer.append(Integer.toHexString(this.conversionCodeSets[i]));
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }
}

