/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import jdk.test.lib.hprof.model.JavaClass;
import jdk.test.lib.hprof.model.JavaField;
import jdk.test.lib.hprof.model.JavaHeapObject;
import jdk.test.lib.hprof.model.JavaObjectRef;
import jdk.test.lib.hprof.model.JavaThing;
import jdk.test.lib.hprof.model.Root;
import jdk.test.lib.hprof.model.Snapshot;

public class JavaStatic {
    private JavaField field;
    private JavaThing value;

    public JavaStatic(JavaField field, JavaThing value) {
        this.field = field;
        this.value = value;
    }

    public void resolve(JavaClass clazz, Snapshot snapshot) {
        long id = -1L;
        if (this.value instanceof JavaObjectRef) {
            id = ((JavaObjectRef)this.value).getId();
        }
        this.value = this.value.dereference(snapshot, this.field);
        if (this.value.isHeapAllocated() && clazz.getLoader() == snapshot.getNullThing()) {
            JavaHeapObject ho = (JavaHeapObject)this.value;
            String s = "Static reference from " + clazz.getName() + "." + this.field.getName();
            snapshot.addRoot(new Root(id, clazz.getId(), 9, s));
        }
    }

    public JavaField getField() {
        return this.field;
    }

    public JavaThing getValue() {
        return this.value;
    }
}

