/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Clipping;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java2d.ControlsSurface;
import java2d.CustomControls;
import javax.swing.AbstractButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class Text
extends ControlsSurface {
    static Image img;
    static TexturePaint texturePaint;
    private String clipType = "Lines";
    protected boolean doClip = true;

    public Text() {
        this.setBackground(Color.WHITE);
        img = this.getImage("clouds.jpg");
        this.setControls(new Component[]{new DemoControls(this)});
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = new Font("SansSerif", 1, 32);
        String s = "JDK";
        TextLayout tl = new TextLayout(s, f, frc);
        double sw = tl.getBounds().getWidth();
        double sh = tl.getBounds().getHeight();
        double sx = (double)(w - 40) / sw;
        double sy = (double)(h - 40) / sh;
        AffineTransform Tx = AffineTransform.getScaleInstance(sx, sy);
        Shape shape = tl.getOutline(Tx);
        sw = shape.getBounds().getWidth();
        sh = shape.getBounds().getHeight();
        Tx = AffineTransform.getTranslateInstance((double)(w / 2) - sw / 2.0, (double)(h / 2) + sh / 2.0);
        shape = Tx.createTransformedShape(shape);
        Rectangle r = shape.getBounds();
        if (this.doClip) {
            g2.clip(shape);
        }
        if (this.clipType.equals("Lines")) {
            g2.setColor(Color.BLACK);
            g2.fill(r);
            g2.setColor(Color.YELLOW);
            g2.setStroke(new BasicStroke(1.5f));
            for (int j = r.y; j < r.y + r.height; j += 3) {
                Line2D.Float line = new Line2D.Float(r.x, j, r.x + r.width, j);
                g2.draw(line);
            }
        } else if (this.clipType.equals("Image")) {
            g2.drawImage(img, r.x, r.y, r.width, r.height, null);
        } else if (this.clipType.equals("TP")) {
            g2.setPaint(texturePaint);
            g2.fill(r);
        } else if (this.clipType.equals("GP")) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, Color.BLUE, w, h, Color.YELLOW));
            g2.fill(r);
        } else if (this.clipType.equals("Text")) {
            g2.setColor(Color.BLACK);
            g2.fill(shape.getBounds());
            g2.setColor(Color.CYAN);
            f = new Font("Serif", 1, 10);
            tl = new TextLayout("OpenJDK", f, frc);
            sw = tl.getBounds().getWidth();
            int x = r.x;
            int y = (int)((float)r.y + tl.getAscent());
            sh = r.y + r.height;
            while ((double)y < sh) {
                tl.draw(g2, x, y);
                if ((x += (int)sw) <= r.x + r.width) continue;
                x = r.x;
                y += (int)tl.getAscent();
            }
        }
        g2.setClip(new Rectangle(0, 0, w, h));
        g2.setColor(Color.GRAY);
        g2.draw(shape);
    }

    public static void main(String[] s) {
        Text.createDemoFrame(new Text());
    }

    static {
        BufferedImage bi = new BufferedImage(5, 5, 1);
        Graphics2D big = bi.createGraphics();
        big.setBackground(Color.YELLOW);
        big.clearRect(0, 0, 5, 5);
        big.setColor(Color.RED);
        big.fillRect(0, 0, 3, 3);
        texturePaint = new TexturePaint(bi, new Rectangle(0, 0, 5, 5));
    }

    static final class DemoControls
    extends CustomControls
    implements ActionListener {
        Text demo;
        JToolBar toolbar;

        public DemoControls(Text demo) {
            super(demo.name);
            this.demo = demo;
            this.toolbar = new JToolBar();
            this.add(this.toolbar);
            this.toolbar.setFloatable(false);
            this.addTool("Clip", true);
            this.addTool("Lines", true);
            this.addTool("Image", false);
            this.addTool("TP", false);
            this.addTool("GP", false);
            this.addTool("Text", false);
        }

        public void addTool(String str, boolean state) {
            JToggleButton b = (JToggleButton)this.toolbar.add(new JToggleButton(str));
            b.setFocusPainted(false);
            b.setSelected(state);
            b.addActionListener(this);
            int width = b.getPreferredSize().width;
            Dimension prefSize = new Dimension(width, 21);
            b.setPreferredSize(prefSize);
            b.setMaximumSize(prefSize);
            b.setMinimumSize(prefSize);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource().equals(this.toolbar.getComponentAtIndex(0))) {
                JToggleButton b = (JToggleButton)e.getSource();
                this.demo.doClip = b.isSelected();
            } else {
                for (Component comp : this.toolbar.getComponents()) {
                    ((JToggleButton)comp).setSelected(false);
                }
                JToggleButton b = (JToggleButton)e.getSource();
                b.setSelected(true);
                this.demo.clipType = b.getText();
            }
            this.demo.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 40);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1111L);
            }
            catch (Exception e) {
                return;
            }
            Thread me = Thread.currentThread();
            while (this.thread == me) {
                for (int i = 1; i < this.toolbar.getComponentCount() - 1; ++i) {
                    ((AbstractButton)this.toolbar.getComponentAtIndex(i)).doClick();
                    try {
                        Thread.sleep(4444L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
            this.thread = null;
        }
    }
}

