/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java2d.DemoGroup;
import java2d.DemoInstVarsAccessor;
import java2d.DemoPanel;
import java2d.J2Ddemo;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class RunWindow
extends JPanel
implements Runnable,
ActionListener {
    private final DemoInstVarsAccessor demoInstVars;
    private final JButton runB;
    private int delay = 10;
    private int numRuns = 20;
    private boolean exit;
    private final JCheckBox zoomCB = new JCheckBox("Zoom");
    private final JCheckBox printCB = new JCheckBox("Print");
    private boolean buffersFlag;
    private int bufBeg;
    private int bufEnd;
    private JTextField delayTextField;
    private JTextField runsTextField;
    private Thread thread;
    private JProgressBar pb;
    private DemoGroup dg = null;
    private DemoPanel dp = null;

    public RunWindow(DemoInstVarsAccessor demoInstVars, RunWindowSettings runWndSetts) {
        this.demoInstVars = demoInstVars;
        this.delay = runWndSetts.getDelay();
        this.numRuns = runWndSetts.getNumRuns();
        this.exit = runWndSetts.getExit();
        this.zoomCB.setSelected(runWndSetts.isZoomCBSelected());
        this.printCB.setSelected(runWndSetts.isPrintCBSelected());
        this.buffersFlag = runWndSetts.getBuffersFlag();
        this.bufBeg = runWndSetts.getBufBeg();
        this.bufEnd = runWndSetts.getBufEnd();
        this.setLayout(new GridBagLayout());
        EmptyBorder eb = new EmptyBorder(5, 5, 5, 5);
        this.setBorder(new CompoundBorder(eb, new BevelBorder(1)));
        Font font = new Font("Serif", 0, 10);
        this.runB = new JButton("Run");
        this.runB.setBackground(Color.GREEN);
        this.runB.addActionListener(this);
        this.runB.setMinimumSize(new Dimension(70, 30));
        J2Ddemo.addToGridBag(this, this.runB, 0, 0, 1, 1, 0.0, 0.0);
        this.pb = new JProgressBar();
        this.pb.setPreferredSize(new Dimension(100, 30));
        this.pb.setMinimum(0);
        J2Ddemo.addToGridBag(this, this.pb, 1, 0, 2, 1, 1.0, 0.0);
        JPanel p1 = new JPanel(new GridLayout(2, 2));
        JPanel p2 = new JPanel();
        JLabel l = new JLabel("Runs:");
        l.setFont(font);
        l.setForeground(Color.BLACK);
        p2.add(l);
        this.runsTextField = new JTextField(String.valueOf(this.numRuns));
        p2.add(this.runsTextField);
        this.runsTextField.setPreferredSize(new Dimension(30, 20));
        this.runsTextField.addActionListener(this);
        p1.add(p2);
        p2 = new JPanel();
        l = new JLabel("Delay:");
        l.setFont(font);
        l.setForeground(Color.BLACK);
        p2.add(l);
        this.delayTextField = new JTextField(String.valueOf(this.delay));
        p2.add(this.delayTextField);
        this.delayTextField.setPreferredSize(new Dimension(30, 20));
        this.delayTextField.addActionListener(this);
        p1.add(p2);
        this.zoomCB.setHorizontalAlignment(0);
        this.zoomCB.setFont(font);
        this.printCB.setFont(font);
        p1.add(this.zoomCB);
        p1.add(this.printCB);
        this.printCB.addActionListener(this);
        J2Ddemo.addToGridBag(this, p1, 0, 1, 3, 1, 1.0, 1.0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.printCB)) {
            this.demoInstVars.getPrintCB().setSelected(this.printCB.isSelected());
        } else if (e.getSource().equals(this.delayTextField)) {
            this.delay = Integer.parseInt(this.delayTextField.getText().trim());
        } else if (e.getSource().equals(this.runsTextField)) {
            this.numRuns = Integer.parseInt(this.runsTextField.getText().trim());
        } else if ("Run".equals(e.getActionCommand())) {
            this.doRunAction();
        } else if ("Stop".equals(e.getActionCommand())) {
            this.stop();
        }
    }

    public void doRunAction() {
        this.runB.setText("Stop");
        this.runB.setBackground(Color.RED);
        this.start();
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(6);
        this.thread.setName("RunWindow");
        this.thread.start();
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
        this.notifyAll();
    }

    public void sleepPerTab() {
        for (int j = 0; j < this.delay + 1 && this.thread != null; ++j) {
            for (int k = 0; k < 10 && this.thread != null; ++k) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Runnable pbUpdateRunnable = new Runnable(this){
                final /* synthetic */ RunWindow this$0;
                {
                    RunWindow runWindow = this$0;
                    Objects.requireNonNull(runWindow);
                    this.this$0 = runWindow;
                }

                @Override
                public void run() {
                    this.this$0.pb.setValue(this.this$0.pb.getValue() + 1);
                }
            };
            SwingUtilities.invokeLater(pbUpdateRunnable);
        }
    }

    private void printDemo(final DemoGroup dg) {
        Runnable printDemoRunnable = new Runnable(){
            final /* synthetic */ RunWindow this$0;
            {
                RunWindow runWindow = this$0;
                Objects.requireNonNull(runWindow);
                this.this$0 = runWindow;
            }

            @Override
            public void run() {
                if (!this.this$0.demoInstVars.getControls().toolBarCB.isSelected()) {
                    this.this$0.demoInstVars.getControls().toolBarCB.setSelected(true);
                    dg.invalidate();
                }
                for (Component comp : dg.getPanel().getComponents()) {
                    DemoPanel dp = (DemoPanel)comp;
                    if (dp.tools == null) continue;
                    if (dp.surface.animating != null && dp.surface.animating.running()) {
                        dp.tools.startStopB.doClick();
                    }
                    dp.tools.printB.doClick();
                }
            }
        };
        RunWindow.invokeAndWait(printDemoRunnable);
    }

    @Override
    public void run() {
        System.out.println("\nJ2D Demo RunWindow : " + this.numRuns + " Runs, " + this.delay + " second delay between tabs\njava version: " + System.getProperty("java.version") + "\n" + System.getProperty("os.name") + " " + System.getProperty("os.version") + "\n");
        Runtime r = Runtime.getRuntime();
        for (int runNum = 0; runNum < this.numRuns && this.thread != null; ++runNum) {
            Date d = new Date();
            System.out.print("#" + runNum + " " + d.toString() + ", ");
            r.gc();
            float freeMemory = r.freeMemory();
            float totalMemory = r.totalMemory();
            System.out.println((totalMemory - freeMemory) / 1024.0f + "K used");
            for (int i = 0; i < this.demoInstVars.getTabbedPane().getTabCount() && this.thread != null; ++i) {
                final int mainTabIndex = i;
                Runnable initDemoRunnable = new Runnable(){
                    final /* synthetic */ RunWindow this$0;
                    {
                        RunWindow runWindow = this$0;
                        Objects.requireNonNull(runWindow);
                        this.this$0 = runWindow;
                    }

                    @Override
                    public void run() {
                        this.this$0.pb.setValue(0);
                        this.this$0.pb.setMaximum(this.this$0.delay);
                        if (mainTabIndex != 0) {
                            this.this$0.dg = this.this$0.demoInstVars.getGroup()[mainTabIndex - 1];
                            this.this$0.dg.invalidate();
                        }
                        this.this$0.demoInstVars.getTabbedPane().setSelectedIndex(mainTabIndex);
                    }
                };
                RunWindow.invokeAndWait(initDemoRunnable);
                if (i != 0 && (this.zoomCB.isSelected() || this.buffersFlag)) {
                    this.dp = (DemoPanel)this.dg.getPanel().getComponent(0);
                    if (this.dg.tabbedPane == null && this.dp.surface != null) {
                        Runnable mouseClickedRunnable = new Runnable(this){
                            final /* synthetic */ RunWindow this$0;
                            {
                                RunWindow runWindow = this$0;
                                Objects.requireNonNull(runWindow);
                                this.this$0 = runWindow;
                            }

                            @Override
                            public void run() {
                                this.this$0.dg.mouseClicked(this.this$0.dp.surface);
                            }
                        };
                        RunWindow.invokeAndWait(mouseClickedRunnable);
                    }
                    for (int j = 1; j < this.dg.tabbedPane.getTabCount() && this.thread != null; ++j) {
                        final int subTabIndex = j;
                        Runnable initPanelRunnable = new Runnable(){
                            final /* synthetic */ RunWindow this$0;
                            {
                                RunWindow runWindow = this$0;
                                Objects.requireNonNull(runWindow);
                                this.this$0 = runWindow;
                            }

                            @Override
                            public void run() {
                                this.this$0.pb.setValue(0);
                                this.this$0.pb.setMaximum(this.this$0.delay);
                                this.this$0.dg.tabbedPane.setSelectedIndex(subTabIndex);
                            }
                        };
                        RunWindow.invokeAndWait(initPanelRunnable);
                        final JPanel p = this.dg.getPanel();
                        if (this.buffersFlag && p.getComponentCount() == 1) {
                            this.dp = (DemoPanel)p.getComponent(0);
                            if (this.dp.surface.animating != null) {
                                this.dp.surface.animating.stop();
                            }
                            int k = this.bufBeg;
                            while (k <= this.bufEnd && this.thread != null) {
                                final int cloneIndex = k++;
                                Runnable cloneRunnable = new Runnable(){
                                    final /* synthetic */ RunWindow this$0;
                                    {
                                        RunWindow runWindow = this$0;
                                        Objects.requireNonNull(runWindow);
                                        this.this$0 = runWindow;
                                    }

                                    @Override
                                    public void run() {
                                        this.this$0.dp.tools.cloneB.doClick();
                                        int n = p.getComponentCount();
                                        DemoPanel clone = (DemoPanel)p.getComponent(n - 1);
                                        if (clone.surface.animating != null) {
                                            clone.surface.animating.stop();
                                        }
                                        clone.tools.issueRepaint = true;
                                        clone.tools.screenCombo.setSelectedIndex(cloneIndex);
                                        clone.tools.issueRepaint = false;
                                    }
                                };
                                RunWindow.invokeAndWait(cloneRunnable);
                            }
                        }
                        if (this.printCB.isSelected()) {
                            this.printDemo(this.dg);
                        }
                        this.sleepPerTab();
                    }
                    continue;
                }
                if (i != 0 && this.printCB.isSelected()) {
                    this.printDemo(this.dg);
                    this.sleepPerTab();
                    continue;
                }
                this.sleepPerTab();
            }
            if (runNum + 1 != this.numRuns) continue;
            System.out.println("Finished.");
            if (!this.exit || this.thread == null) continue;
            System.out.println("System.exit(0).");
            System.exit(0);
        }
        Runnable resetRunnable = new Runnable(this){
            final /* synthetic */ RunWindow this$0;
            {
                RunWindow runWindow = this$0;
                Objects.requireNonNull(runWindow);
                this.this$0 = runWindow;
            }

            @Override
            public void run() {
                this.this$0.runB.setText("Run");
                this.this$0.runB.setBackground(Color.GREEN);
                this.this$0.pb.setValue(0);
            }
        };
        RunWindow.invokeAndWait(resetRunnable);
        this.thread = null;
        this.dg = null;
        this.dp = null;
    }

    private static void invokeAndWait(Runnable run) {
        try {
            SwingUtilities.invokeAndWait(run);
        }
        catch (Exception e) {
            Logger.getLogger(RunWindow.class.getName()).log(Level.SEVERE, "ERROR in invokeAndWait", e);
        }
    }

    public static class RunWindowSettings {
        private int delay = 10;
        private int numRuns = 20;
        private boolean exit;
        private boolean zoomCBIsSelected;
        private boolean printCBIsSelected;
        private boolean buffersFlag;
        private int bufBeg;
        private int bufEnd;

        public int getDelay() {
            return this.delay;
        }

        public void setDelay(int delay) {
            this.delay = delay;
        }

        public int getNumRuns() {
            return this.numRuns;
        }

        public void setNumRuns(int numRuns) {
            this.numRuns = numRuns;
        }

        public boolean getExit() {
            return this.exit;
        }

        public void setExit(boolean exit) {
            this.exit = exit;
        }

        public boolean isZoomCBSelected() {
            return this.zoomCBIsSelected;
        }

        public void setZoomCBSelected(boolean b) {
            this.zoomCBIsSelected = b;
        }

        public boolean isPrintCBSelected() {
            return this.printCBIsSelected;
        }

        public void setPrintCBIsSelected(boolean b) {
            this.printCBIsSelected = b;
        }

        public boolean getBuffersFlag() {
            return this.buffersFlag;
        }

        public void setBuffersFlag(boolean buffersFlag) {
            this.buffersFlag = buffersFlag;
        }

        public int getBufBeg() {
            return this.bufBeg;
        }

        public void setBufBeg(int bufBeg) {
            this.bufBeg = bufBeg;
        }

        public int getBufEnd() {
            return this.bufEnd;
        }

        public void setBufEnd(int bufEnd) {
            this.bufEnd = bufEnd;
        }
    }
}

