/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class InMemoryJavaCompiler {
    public static Map<String, byte[]> compile(Map<String, ? extends CharSequence> inputMap) {
        FileManager fileManager;
        StringWriter writer;
        LinkedList<SourceFile> sourceFiles = new LinkedList<SourceFile>();
        for (Map.Entry<String, ? extends CharSequence> entry : inputMap.entrySet()) {
            sourceFiles.add(new SourceFile(entry.getKey(), entry.getValue()));
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        Boolean exitCode = compiler.getTask(writer = new StringWriter(), fileManager = new FileManager(compiler.getStandardFileManager(null, null, null)), null, null, null, sourceFiles).call();
        if (!exitCode.booleanValue()) {
            System.out.println("*********** javac output begin ***********");
            System.out.println(((Object)writer).toString());
            System.out.println("*********** javac output end ***********");
            throw new RuntimeException("Test bug: in memory compilation failed.");
        }
        return fileManager.getByteCode();
    }

    public static byte[] compile(String className, CharSequence sourceCode, String ... options) {
        byte[] byArray;
        SourceFile file = new SourceFile(className, sourceCode);
        ArrayList<String> opts = new ArrayList<String>();
        String moduleOverride = null;
        for (String opt : options) {
            if (opt.startsWith("--patch-module=")) {
                moduleOverride = opt.substring("--patch-module=".length());
                continue;
            }
            opts.add(opt);
        }
        FileManagerWrapper fileManager = new FileManagerWrapper(file, moduleOverride);
        try {
            JavaCompiler.CompilationTask task = InMemoryJavaCompiler.getCompiler().getTask(null, fileManager, null, opts, null, Arrays.asList(file));
            if (!task.call().booleanValue()) {
                throw new RuntimeException("Could not compile " + className + " with source code " + String.valueOf(sourceCode));
            }
            byArray = fileManager.getByteCode();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        fileManager.close();
        return byArray;
    }

    private static JavaCompiler getCompiler() {
        return ToolProvider.getSystemJavaCompiler();
    }

    static class SourceFile
    extends SimpleJavaFileObject {
        private CharSequence sourceCode;
        private String className;

        public SourceFile(String name, CharSequence sourceCode) {
            super(URI.create("memo:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.sourceCode = sourceCode;
            this.className = name;
        }

        @Override
        public CharSequence getCharContent(boolean ignore) {
            return this.sourceCode;
        }

        public String getClassName() {
            return this.className;
        }
    }

    static class FileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private Map<String, ClassFile> classesMap = new HashMap<String, ClassFile>();

        protected FileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        @Override
        public ClassFile getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject source) {
            ClassFile classFile = new ClassFile(name);
            this.classesMap.put(name, classFile);
            return classFile;
        }

        public Map<String, byte[]> getByteCode() {
            HashMap<String, byte[]> result = new HashMap<String, byte[]>();
            for (Map.Entry<String, ClassFile> entry : this.classesMap.entrySet()) {
                result.put(entry.getKey(), entry.getValue().toByteArray());
            }
            return result;
        }
    }

    private static class FileManagerWrapper
    extends ForwardingJavaFileManager<JavaFileManager> {
        private static final JavaFileManager.Location PATCH_LOCATION = new JavaFileManager.Location(){

            @Override
            public String getName() {
                return "patch module location";
            }

            @Override
            public boolean isOutputLocation() {
                return false;
            }
        };
        private final SourceFile srcFile;
        private ClassFile clsFile;
        private final String moduleOverride;

        public FileManagerWrapper(SourceFile file, String moduleOverride) {
            super(InMemoryJavaCompiler.getCompiler().getStandardFileManager(null, null, null));
            this.srcFile = file;
            this.moduleOverride = moduleOverride;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            if (!this.srcFile.getClassName().equals(className)) {
                throw new IOException("Expected class with name " + this.srcFile.getClassName() + ", but got " + className);
            }
            this.clsFile = new ClassFile(className);
            return this.clsFile;
        }

        @Override
        public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
            if (fo == this.srcFile && this.moduleOverride != null) {
                return PATCH_LOCATION;
            }
            return super.getLocationForModule(location, fo);
        }

        @Override
        public String inferModuleName(JavaFileManager.Location location) throws IOException {
            if (location == PATCH_LOCATION) {
                return this.moduleOverride;
            }
            return super.inferModuleName(location);
        }

        @Override
        public boolean hasLocation(JavaFileManager.Location location) {
            return super.hasLocation(location) || location == StandardLocation.PATCH_MODULE_PATH;
        }

        public byte[] getByteCode() {
            return this.clsFile.toByteArray();
        }
    }

    static class ClassFile
    extends SimpleJavaFileObject {
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        protected ClassFile(String name) {
            super(URI.create("memo:///" + name.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
        }

        @Override
        public ByteArrayOutputStream openOutputStream() {
            return this.baos;
        }

        byte[] toByteArray() {
            return this.baos.toByteArray();
        }
    }
}

