/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class Notepad
extends JPanel {
    protected static Properties properties;
    private static ResourceBundle resources;
    private static final String EXIT_AFTER_PAINT = "-exit";
    private static boolean exitAfterFirstPaint;
    private static final String[] MENUBAR_KEYS;
    private static final String[] TOOLBAR_KEYS;
    private static final String[] FILE_KEYS;
    private static final String[] EDIT_KEYS;
    private static final String[] DEBUG_KEYS;
    private JTextComponent editor;
    private Map<Object, Action> commands;
    private JToolBar toolbar;
    private JComponent status;
    private JFrame elementTreeFrame;
    protected ElementTreePanel elementTreePanel;
    protected UndoableEditListener undoHandler = new UndoHandler(this);
    protected UndoManager undo = new UndoManager();
    public static final String imageSuffix = "Image";
    public static final String labelSuffix = "Label";
    public static final String actionSuffix = "Action";
    public static final String tipSuffix = "Tooltip";
    public static final String openAction = "open";
    public static final String newAction = "new";
    public static final String saveAction = "save";
    public static final String exitAction = "exit";
    public static final String showElementTreeAction = "showElementTree";
    private UndoAction undoAction = new UndoAction(this);
    private RedoAction redoAction = new RedoAction(this);
    private Action[] defaultActions = new Action[]{new NewAction(this), new OpenAction(this), new SaveAction(this), new ExitAction(this), new ShowElementTreeAction(this), this.undoAction, this.redoAction};

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (exitAfterFirstPaint) {
            System.exit(0);
        }
    }

    Notepad() {
        super(true);
        Action[] actions;
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.editor = this.createEditor();
        this.editor.getDocument().addUndoableEditListener(this.undoHandler);
        this.commands = new HashMap<Object, Action>();
        for (Action a : actions = this.getActions()) {
            this.commands.put(a.getValue("Name"), a);
        }
        JScrollPane scroller = new JScrollPane();
        JViewport port = scroller.getViewport();
        port.add(this.editor);
        String vpFlag = this.getProperty("ViewportBackingStore");
        if (vpFlag != null) {
            Boolean bs = Boolean.valueOf(vpFlag);
            port.setScrollMode(bs != false ? 2 : 1);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", this.createToolbar());
        panel.add("Center", scroller);
        this.add("Center", panel);
        this.add("South", this.createStatusbar());
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals(EXIT_AFTER_PAINT)) {
            exitAfterFirstPaint = true;
        }
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setTitle(resources.getString("Title"));
                frame.setBackground(Color.lightGray);
                frame.getContentPane().setLayout(new BorderLayout());
                Notepad notepad = new Notepad();
                frame.getContentPane().add("Center", notepad);
                frame.setJMenuBar(notepad.createMenubar());
                frame.addWindowListener(new AppCloser());
                frame.pack();
                frame.setSize(500, 600);
                frame.setVisible(true);
            }
        });
    }

    public Action[] getActions() {
        return TextAction.augmentList(this.editor.getActions(), this.defaultActions);
    }

    protected JTextComponent createEditor() {
        JTextArea c = new JTextArea();
        c.setDragEnabled(true);
        ((JComponent)c).setFont(new Font("monospaced", 0, 12));
        return c;
    }

    protected JTextComponent getEditor() {
        return this.editor;
    }

    protected Frame getFrame() {
        for (Container p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof Frame)) continue;
            return (Frame)p;
        }
        return null;
    }

    protected JMenuItem createMenuItem(String cmd) {
        String astr;
        JMenuItem mi = new JMenuItem(this.getResourceString(cmd + labelSuffix));
        URL url = this.getResource(cmd + imageSuffix);
        if (url != null) {
            mi.setHorizontalTextPosition(4);
            mi.setIcon(new ImageIcon(url));
        }
        if ((astr = this.getProperty(cmd + actionSuffix)) == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a = this.getAction(astr);
        if (a != null) {
            mi.addActionListener(a);
            a.addPropertyChangeListener(this.createActionChangeListener(mi));
            mi.setEnabled(a.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        return mi;
    }

    protected Action getAction(String cmd) {
        return this.commands.get(cmd);
    }

    protected String getProperty(String key) {
        return properties.getProperty(key);
    }

    protected String getResourceString(String nm) {
        String str;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            return this.getClass().getResource(name);
        }
        return null;
    }

    protected Component createStatusbar() {
        this.status = new StatusBar(this);
        return this.status;
    }

    protected void resetUndoManager() {
        this.undo.discardAllEdits();
        this.undoAction.update();
        this.redoAction.update();
    }

    private Component createToolbar() {
        this.toolbar = new JToolBar();
        for (String toolKey : this.getToolBarKeys()) {
            if (toolKey.equals("-")) {
                this.toolbar.add(Box.createHorizontalStrut(5));
                continue;
            }
            this.toolbar.add(this.createTool(toolKey));
        }
        this.toolbar.add(Box.createHorizontalGlue());
        return this.toolbar;
    }

    protected Component createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected JButton createToolbarButton(String key) {
        Action a;
        URL url = this.getResource(key + imageSuffix);
        JButton b = new JButton(this, (Icon)new ImageIcon(url)){
            final /* synthetic */ Notepad this$0;
            {
                Notepad notepad = this$0;
                Objects.requireNonNull(notepad);
                this.this$0 = notepad;
                super(arg0);
            }

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        String astr = this.getProperty(key + actionSuffix);
        if (astr == null) {
            astr = key;
        }
        if ((a = this.getAction(astr)) != null) {
            b.setActionCommand(astr);
            b.addActionListener(a);
        } else {
            b.setEnabled(false);
        }
        String tip = this.getResourceString(key + tipSuffix);
        if (tip != null) {
            b.setToolTipText(tip);
        }
        return b;
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        for (String menuKey : this.getMenuBarKeys()) {
            JMenu m = this.createMenu(menuKey);
            if (m == null) continue;
            mb.add(m);
        }
        return mb;
    }

    protected JMenu createMenu(String key) {
        JMenu menu = new JMenu(this.getResourceString(key + labelSuffix));
        for (String itemKey : this.getItemKeys(key)) {
            if (itemKey.equals("-")) {
                menu.addSeparator();
                continue;
            }
            JMenuItem mi = this.createMenuItem(itemKey);
            menu.add(mi);
        }
        return menu;
    }

    protected String[] getItemKeys(String key) {
        switch (key) {
            case "file": {
                return FILE_KEYS;
            }
            case "edit": {
                return EDIT_KEYS;
            }
            case "debug": {
                return DEBUG_KEYS;
            }
        }
        return null;
    }

    protected String[] getMenuBarKeys() {
        return MENUBAR_KEYS;
    }

    protected String[] getToolBarKeys() {
        return TOOLBAR_KEYS;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem b) {
        return new ActionChangedListener(this, b);
    }

    static {
        MENUBAR_KEYS = new String[]{"file", "edit", "debug"};
        TOOLBAR_KEYS = new String[]{newAction, openAction, saveAction, "-", "cut", "copy", "paste"};
        FILE_KEYS = new String[]{newAction, openAction, saveAction, "-", exitAction};
        EDIT_KEYS = new String[]{"cut", "copy", "paste", "-", "undo", "redo"};
        DEBUG_KEYS = new String[]{"dump", showElementTreeAction};
        try {
            properties = new Properties();
            properties.load(Notepad.class.getResourceAsStream("resources/NotepadSystem.properties"));
            resources = ResourceBundle.getBundle("resources.Notepad", Locale.getDefault());
        }
        catch (IOException | MissingResourceException e) {
            System.err.println("resources/Notepad.properties or resources/NotepadSystem.properties not found");
            System.exit(1);
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        final /* synthetic */ Notepad this$0;

        UndoHandler(Notepad this$0) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            this.this$0.undo.addEdit(e.getEdit());
            this.this$0.undoAction.update();
            this.this$0.redoAction.update();
        }
    }

    class UndoAction
    extends AbstractAction {
        final /* synthetic */ Notepad this$0;

        public UndoAction(Notepad this$0) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
            super("Undo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.this$0.undo.undo();
            }
            catch (CannotUndoException ex) {
                Logger.getLogger(UndoAction.class.getName()).log(Level.SEVERE, "Unable to undo", ex);
            }
            this.update();
            this.this$0.redoAction.update();
        }

        protected void update() {
            if (this.this$0.undo.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", this.this$0.undo.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        final /* synthetic */ Notepad this$0;

        public RedoAction(Notepad this$0) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
            super("Redo");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.this$0.undo.redo();
            }
            catch (CannotRedoException ex) {
                Logger.getLogger(RedoAction.class.getName()).log(Level.SEVERE, "Unable to redo", ex);
            }
            this.update();
            this.this$0.undoAction.update();
        }

        protected void update() {
            if (this.this$0.undo.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", this.this$0.undo.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class NewAction
    extends AbstractAction {
        final /* synthetic */ Notepad this$0;

        NewAction(Notepad this$0) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
            super(Notepad.newAction);
        }

        NewAction(Notepad this$0, String nm) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
            super(nm);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Document oldDoc = this.this$0.getEditor().getDocument();
            if (oldDoc != null) {
                oldDoc.removeUndoableEditListener(this.this$0.undoHandler);
            }
            this.this$0.getEditor().setDocument(new PlainDocument());
            this.this$0.getEditor().getDocument().addUndoableEditListener(this.this$0.undoHandler);
            this.this$0.resetUndoManager();
            this.this$0.getFrame().setTitle(resources.getString("Title"));
            this.this$0.revalidate();
        }
    }

    class OpenAction
    extends NewAction {
        final /* synthetic */ Notepad this$0;

        OpenAction(Notepad this$0) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
            super(this$0, Notepad.openAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            Frame frame = this.this$0.getFrame();
            int ret = chooser.showOpenDialog(frame);
            if (ret != 0) {
                return;
            }
            File f = chooser.getSelectedFile();
            if (f.isFile() && f.canRead()) {
                Document oldDoc = this.this$0.getEditor().getDocument();
                if (oldDoc != null) {
                    oldDoc.removeUndoableEditListener(this.this$0.undoHandler);
                }
                if (this.this$0.elementTreePanel != null) {
                    this.this$0.elementTreePanel.setEditor(null);
                }
                this.this$0.getEditor().setDocument(new PlainDocument());
                frame.setTitle(f.getName());
                FileLoader loader = new FileLoader(this.this$0, f, this.this$0.editor.getDocument());
                loader.start();
            } else {
                JOptionPane.showMessageDialog(this.this$0.getFrame(), "Could not open file: " + String.valueOf(f), "Error opening file", 0);
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        final /* synthetic */ Notepad this$0;

        SaveAction(Notepad this$0) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
            super(Notepad.saveAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            Frame frame = this.this$0.getFrame();
            int ret = chooser.showSaveDialog(frame);
            if (ret != 0) {
                return;
            }
            File f = chooser.getSelectedFile();
            frame.setTitle(f.getName());
            FileSaver saver = new FileSaver(this.this$0, f, this.this$0.editor.getDocument());
            saver.start();
        }
    }

    class ExitAction
    extends AbstractAction {
        final /* synthetic */ Notepad this$0;

        ExitAction(Notepad this$0) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
            super(Notepad.exitAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    class ShowElementTreeAction
    extends AbstractAction {
        final /* synthetic */ Notepad this$0;

        ShowElementTreeAction(Notepad this$0) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
            super(Notepad.showElementTreeAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.this$0.elementTreeFrame == null) {
                try {
                    String title = resources.getString("ElementTreeFrameTitle");
                    this.this$0.elementTreeFrame = new JFrame(title);
                }
                catch (MissingResourceException mre) {
                    this.this$0.elementTreeFrame = new JFrame();
                }
                this.this$0.elementTreeFrame.addWindowListener(new WindowAdapter(this){
                    final /* synthetic */ ShowElementTreeAction this$1;
                    {
                        ShowElementTreeAction showElementTreeAction = this$1;
                        Objects.requireNonNull(showElementTreeAction);
                        this.this$1 = showElementTreeAction;
                    }

                    @Override
                    public void windowClosing(WindowEvent weeee) {
                        this.this$1.this$0.elementTreeFrame.setVisible(false);
                    }
                });
                Container fContentPane = this.this$0.elementTreeFrame.getContentPane();
                fContentPane.setLayout(new BorderLayout());
                this.this$0.elementTreePanel = new ElementTreePanel(this.this$0.getEditor());
                fContentPane.add(this.this$0.elementTreePanel);
                this.this$0.elementTreeFrame.pack();
            }
            this.this$0.elementTreeFrame.setVisible(true);
        }
    }

    class StatusBar
    extends JComponent {
        final /* synthetic */ Notepad this$0;

        public StatusBar(Notepad this$0) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
            this.setLayout(new BoxLayout(this, 0));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(Notepad notepad, JMenuItem mi) {
            Objects.requireNonNull(notepad);
            this.menuItem = mi;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.menuItem.setEnabled(enabledState);
            }
        }
    }

    class FileSaver
    extends Thread {
        Document doc;
        File f;
        final /* synthetic */ Notepad this$0;

        FileSaver(Notepad this$0, File f, Document doc) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
            this.setPriority(4);
            this.f = f;
            this.doc = doc;
        }

        @Override
        public void run() {
            try {
                this.this$0.status.removeAll();
                JProgressBar progress = new JProgressBar();
                progress.setMinimum(0);
                progress.setMaximum(this.doc.getLength());
                this.this$0.status.add(progress);
                this.this$0.status.revalidate();
                FileWriter out = new FileWriter(this.f);
                Segment text = new Segment();
                text.setPartialReturn(true);
                int charsLeft = this.doc.getLength();
                int offset = 0;
                while (charsLeft > 0) {
                    this.doc.getText(offset, Math.min(4096, charsLeft), text);
                    ((Writer)out).write(text.array, text.offset, text.count);
                    charsLeft -= text.count;
                    progress.setValue(offset += text.count);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Logger.getLogger(FileSaver.class.getName()).log(Level.SEVERE, null, e);
                    }
                }
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (IOException e) {
                final String msg = e.getMessage();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ FileSaver this$1;
                    {
                        FileSaver fileSaver = this$1;
                        Objects.requireNonNull(fileSaver);
                        this.this$1 = fileSaver;
                    }

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(this.this$1.this$0.getFrame(), "Could not save file: " + msg, "Error saving file", 0);
                    }
                });
            }
            catch (BadLocationException e) {
                System.err.println(e.getMessage());
            }
            this.this$0.status.removeAll();
            this.this$0.status.revalidate();
        }
    }

    class FileLoader
    extends Thread {
        Document doc;
        File f;
        final /* synthetic */ Notepad this$0;

        FileLoader(Notepad this$0, File f, Document doc) {
            Notepad notepad = this$0;
            Objects.requireNonNull(notepad);
            this.this$0 = notepad;
            this.setPriority(4);
            this.f = f;
            this.doc = doc;
        }

        @Override
        public void run() {
            try {
                int nch;
                this.this$0.status.removeAll();
                JProgressBar progress = new JProgressBar();
                progress.setMinimum(0);
                progress.setMaximum((int)this.f.length());
                this.this$0.status.add(progress);
                this.this$0.status.revalidate();
                FileReader in = new FileReader(this.f);
                char[] buff = new char[4096];
                while ((nch = ((Reader)in).read(buff, 0, buff.length)) != -1) {
                    this.doc.insertString(this.doc.getLength(), new String(buff, 0, nch), null);
                    progress.setValue(progress.getValue() + nch);
                }
            }
            catch (IOException e) {
                final String msg = e.getMessage();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ FileLoader this$1;
                    {
                        FileLoader fileLoader = this$1;
                        Objects.requireNonNull(fileLoader);
                        this.this$1 = fileLoader;
                    }

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(this.this$1.this$0.getFrame(), "Could not open file: " + msg, "Error opening file", 0);
                    }
                });
            }
            catch (BadLocationException e) {
                System.err.println(e.getMessage());
            }
            this.doc.addUndoableEditListener(this.this$0.undoHandler);
            this.this$0.status.removeAll();
            this.this$0.status.revalidate();
            this.this$0.resetUndoManager();
            if (this.this$0.elementTreePanel != null) {
                SwingUtilities.invokeLater(new Runnable(this){
                    final /* synthetic */ FileLoader this$1;
                    {
                        FileLoader fileLoader = this$1;
                        Objects.requireNonNull(fileLoader);
                        this.this$1 = fileLoader;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.elementTreePanel.setEditor(this.this$1.this$0.getEditor());
                    }
                });
            }
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

