/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions;

import java.time.ZonedDateTime;
import java.util.Objects;
import org.eclipse.passage.lic.api.conditions.ValidityPeriodClosed;

public final class BaseValidityPeriodClosed
implements ValidityPeriodClosed {
    private final ZonedDateTime from;
    private final ZonedDateTime to;

    public BaseValidityPeriodClosed(ZonedDateTime from, ZonedDateTime to) {
        Objects.requireNonNull(from, "BaseValidityPeriodClosed::from");
        Objects.requireNonNull(to, "BaseValidityPeriodClosed:to");
        if (!from.isBefore(to)) {
            throw new IllegalStateException("BaseValidityPeriodClosed: 'from' must be strictly less than 'to'");
        }
        this.from = from;
        this.to = to;
    }

    public ZonedDateTime from() {
        return this.from;
    }

    public ZonedDateTime to() {
        return this.to;
    }

    public boolean valid(ZonedDateTime date) {
        Objects.requireNonNull(date, "BaseValidityPeriodClosed::valid::date");
        return !(!this.from.isBefore(date) && !date.isEqual(this.from) || !date.isBefore(this.to) && !date.isEqual(this.to));
    }
}

