/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.sourcelookup;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupFacility;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class LambdaStackFrameSourceDisplayAdapter
implements ISourceDisplay {
    public void displaySource(Object element, IWorkbenchPage page, boolean forceSourceLookup) {
        JDIStackFrame jdiFrame = (JDIStackFrame)element;
        try {
            IEditorPart part;
            SourceLookupResult sourceRes = SourceLookupFacility.getDefault().lookup(element, jdiFrame.getLaunch().getSourceLocator(), forceSourceLookup);
            IDocumentProvider provider = JavaUI.getDocumentProvider();
            IEditorInput editorInput = sourceRes.getEditorInput();
            provider.connect((Object)editorInput);
            IDocument document = provider.getDocument((Object)editorInput);
            IRegion region = document.getLineInformation(jdiFrame.getLineNumber() - 1);
            IJavaElement je = JavaUI.getEditorInputJavaElement((IEditorInput)editorInput);
            if (je != null && (part = JavaUI.openInEditor((IJavaElement)je)) instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)part;
                List<LambdaExpression> inLineLambdas = ToggleBreakpointAdapter.findLambdaExpressions(textEditor, region);
                for (LambdaExpression exp : inLineLambdas) {
                    IMethodBinding methodBinding = exp.resolveMethodBinding();
                    String key = methodBinding.getKey();
                    if (!key.contains(jdiFrame.getName())) continue;
                    textEditor.selectAndReveal(exp.getStartPosition(), exp.getLength());
                    return;
                }
            }
        }
        catch (CoreException | BadLocationException e) {
            DebugUIPlugin.log((Throwable)e);
        }
        SourceLookupFacility.getDefault().displaySource((Object)jdiFrame, page, forceSourceLookup);
    }
}

