/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public final class IDChanger {
    private static final int NO_INITIAL_TEMP_ID = -1;
    private static final int INITIAL_TEMP_ID = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.util.IDChanger.INITIAL_TEMP_ID", -1);

    private IDChanger() {
    }

    public static void changeIDs(Map<Integer, Integer> changes, ChangeHandler handler) {
        IDChanger.changeIDs(changes, -1, handler);
    }

    public static void changeIDs(Map<Integer, Integer> changes, int initialTempID, ChangeHandler handler) {
        boolean conflictsResolved;
        if (ObjectUtil.isEmpty(changes)) {
            return;
        }
        HashMap operationsMap = new HashMap();
        changes.forEach((oldID, newID) -> operationsMap.computeIfAbsent(newID - oldID, ShiftOperation::new).addAffectedID((int)oldID));
        ArrayList operations = operationsMap.values().stream().filter(ShiftOperation::isRequired).sorted().collect(Collectors.toCollection(ArrayList::new));
        operations.forEach(ShiftOperation::finishAffectedIDs);
        if (initialTempID == -1 && (initialTempID = INITIAL_TEMP_ID) == -1) {
            initialTempID = Integer.MAX_VALUE - changes.size();
        }
        AtomicInteger nextTempID = new AtomicInteger(initialTempID);
        ArrayList preTempOperations = new ArrayList();
        ArrayList postTempOperations = new ArrayList();
        int size = operations.size();
        int i = 0;
        while (i < size - 1) {
            ShiftOperation operation = (ShiftOperation)operations.get(i);
            for (ShiftOperation conflictCandidate : operations.subList(i + 1, size)) {
                conflictCandidate.forEachAffectedID(affectedID -> {
                    int newID = affectedID + conflictCandidate.getShift();
                    if (operation.affectedIDs.contains(newID)) {
                        int tempID = nextTempID.getAndIncrement();
                        int finalID = newID + operation.getShift();
                        if (operation.isSingleton()) {
                            operation.setShift(tempID - newID);
                        } else {
                            operation.removeAffectedID(newID);
                            ShiftOperation preTempOperation = new ShiftOperation(newID, tempID);
                            preTempOperations.add(preTempOperation);
                        }
                        ShiftOperation postTempOperation = new ShiftOperation(tempID, finalID);
                        postTempOperations.add(postTempOperation);
                    }
                });
            }
            if (operation.isEmpty()) {
                operations.remove(i);
                --size;
                continue;
            }
            ++i;
        }
        operations.addAll(0, preTempOperations);
        operations.addAll(postTempOperations);
        boolean bl = conflictsResolved = !postTempOperations.isEmpty();
        if (conflictsResolved) {
            HashSet mergedOperations = new HashSet();
            LinkedHashMap mergeMap = new LinkedHashMap();
            operations.forEach(op -> {
                ShiftOperation shiftOperation = mergeMap.merge(op.getShift(), op, (op1, op2) -> {
                    op2.forEachAffectedID(op1::addAffectedID);
                    mergedOperations.add(op2);
                    return op1;
                });
            });
            mergedOperations.forEach(ShiftOperation::finishAffectedIDs);
            operations = new ArrayList(mergeMap.values());
        }
        operations.forEach(op -> op.handle(handler));
    }

    public static interface ChangeHandler {
        default public void handleSingleChange(int oldID, int newID) {
            this.handleArbitraryChanges(Collections.singletonList(oldID), newID - oldID);
        }

        default public void handleConsecutiveChanges(int firstID, int lastID, int shift) {
            this.handleArbitraryChanges(IntStream.rangeClosed(firstID, lastID).boxed().collect(Collectors.toList()), shift);
        }

        public void handleArbitraryChanges(List<Integer> var1, int var2);
    }

    private static final class ShiftOperation
    implements Comparable<ShiftOperation> {
        private final List<Integer> affectedIDs = new ArrayList<Integer>(1);
        private int shift;

        public ShiftOperation(int shift) {
            this.shift = shift;
        }

        public void forEachAffectedID(IntConsumer consumer) {
            for (int affectedID : this.affectedIDs) {
                consumer.accept(affectedID);
            }
        }

        public ShiftOperation(int oldID, int newID) {
            this.shift = newID - oldID;
            this.addAffectedID(oldID);
        }

        public void addAffectedID(int id) {
            this.affectedIDs.add(id);
        }

        public void removeAffectedID(int id) {
            this.affectedIDs.remove((Object)id);
        }

        public void finishAffectedIDs() {
            this.affectedIDs.sort(null);
        }

        public boolean isEmpty() {
            return this.affectedIDs.isEmpty();
        }

        public boolean isSingleton() {
            return this.size() == 1;
        }

        public boolean isRequired() {
            return this.shift != 0;
        }

        public int getShift() {
            return this.shift;
        }

        public void setShift(int shift) {
            this.shift = shift;
        }

        public void handle(ChangeHandler handler) {
            if (this.isSingleton()) {
                int oldID = this.first();
                int newID = oldID + this.shift;
                handler.handleSingleChange(oldID, newID);
            } else if (this.isConsecutive()) {
                int firstID = this.first();
                int lastID = this.last();
                handler.handleConsecutiveChanges(firstID, lastID, this.shift);
            } else {
                handler.handleArbitraryChanges(this.affectedIDs, this.shift);
            }
        }

        @Override
        public int compareTo(ShiftOperation o) {
            return Integer.compare(this.size(), o.size());
        }

        public String toString() {
            return "ShiftOperation[shift=" + this.shift + ", affectedIDs=" + this.affectedIDs + ", newIDs=" + this.newIDs() + "]";
        }

        private List<Integer> newIDs() {
            ArrayList<Integer> newIDs = new ArrayList<Integer>(this.size());
            for (int affectedID : this.affectedIDs) {
                newIDs.add(affectedID + this.shift);
            }
            return newIDs;
        }

        private boolean isConsecutive() {
            return this.last() - this.first() + 1 == this.size();
        }

        private int first() {
            return this.affectedIDs.get(0);
        }

        private int last() {
            return this.affectedIDs.get(this.size() - 1);
        }

        private int size() {
            return this.affectedIDs.size();
        }
    }
}

