/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.IRuntimeLocator;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.RuntimeLocatorDelegate;

public class RuntimeLocator
implements IRuntimeLocator {
    private IConfigurationElement element;
    private RuntimeLocatorDelegate delegate;

    public RuntimeLocator(IConfigurationElement element) {
        this.element = element;
    }

    protected IConfigurationElement getElement() {
        return this.element;
    }

    @Override
    public String getId() {
        return this.element.getAttribute("id");
    }

    protected String[] getTypeIds() {
        try {
            return ServerPlugin.tokenize(this.element.getAttribute("typeIds"), ",");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean supportsType(String id) {
        return ServerPlugin.contains(this.getTypeIds(), id);
    }

    protected RuntimeLocatorDelegate getDelegate() {
        block3: {
            if (this.delegate == null) {
                try {
                    this.delegate = (RuntimeLocatorDelegate)this.element.createExecutableExtension("class");
                }
                catch (Throwable t) {
                    if (!Trace.SEVERE) break block3;
                    Trace.trace("/severe", "Could not create delegate " + this.toString(), t);
                }
            }
        }
        return this.delegate;
    }

    @Override
    public void searchForRuntimes(IPath path, final IRuntimeLocator.IRuntimeSearchListener found, IProgressMonitor monitor) {
        block2: {
            try {
                this.getDelegate().searchForRuntimes(path, new RuntimeLocatorDelegate.IRuntimeSearchListener(){

                    @Override
                    public void runtimeFound(IRuntimeWorkingCopy runtime) {
                        found.runtimeFound(runtime);
                    }
                }, monitor);
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block2;
                Trace.trace("/severe", "Error calling delegate " + this.toString(), e);
            }
        }
    }

    public String toString() {
        return "RuntimeLocator[" + this.getId() + "]";
    }
}

