/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.gist;

import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.github.core.gist.GistConnector;
import org.eclipse.mylyn.internal.github.ui.gist.GistAttachmentPage;
import org.eclipse.mylyn.internal.github.ui.gist.GistRepositoryQueryPage;
import org.eclipse.mylyn.internal.github.ui.gist.GistRepositorySettingsPage;
import org.eclipse.mylyn.internal.github.ui.gist.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentModel;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskSearchPage;
import org.eclipse.mylyn.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.mylyn.tasks.ui.wizards.RepositoryQueryWizard;

public class GistConnectorUi
extends AbstractRepositoryConnectorUi {
    public static GistConnector getCoreConnector() {
        return (GistConnector)TasksUi.getRepositoryConnector((String)"githubGists");
    }

    public static Set<TaskRepository> getRepositories() {
        return TasksUi.getRepositoryManager().getRepositories("githubGists");
    }

    public String getTaskKindLabel(ITask task) {
        return Messages.GistConnectorUi_LabelTaskKind;
    }

    public String getConnectorKind() {
        return "githubGists";
    }

    public ITaskRepositoryPage getSettingsPage(TaskRepository taskRepository) {
        return new GistRepositorySettingsPage(taskRepository);
    }

    public IWizard getQueryWizard(TaskRepository taskRepository, IRepositoryQuery queryToEdit) {
        RepositoryQueryWizard wizard = new RepositoryQueryWizard(taskRepository);
        wizard.addPage((IWizardPage)new GistRepositoryQueryPage(taskRepository, queryToEdit));
        return wizard;
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository, ITaskMapping selection) {
        return new NewTaskWizard(taskRepository, selection);
    }

    public boolean hasSearchPage() {
        return true;
    }

    public ITaskSearchPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return new GistRepositoryQueryPage(repository, null);
    }

    public IWizardPage getTaskAttachmentPage(TaskAttachmentModel model) {
        return new GistAttachmentPage(model);
    }
}

