/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.result.FilterExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.ResultProjection;
import org.eclipse.datatools.connectivity.oda.spec.result.SortSpecification;
import org.eclipse.datatools.connectivity.oda.spec.util.QuerySpecificationHelper;

public class ResultSetSpecification {
    private FilterExpression m_filterSpec;
    private ResultProjection m_projectionSpec;
    private SortSpecification m_sortSpec;
    private static final String sm_className = ResultSetSpecification.class.getName();

    protected ResultSetSpecification() {
    }

    public void setFilterSpecification(FilterExpression filterExpr) {
        this.m_filterSpec = filterExpr;
    }

    public FilterExpression getFilterSpecification() {
        return this.m_filterSpec;
    }

    public void setResultProjection(ResultProjection projectionSpec) {
        this.m_projectionSpec = projectionSpec;
    }

    public ResultProjection getResultProjection() {
        return this.m_projectionSpec;
    }

    public void setSortSpecification(SortSpecification sortSpec) {
        this.m_sortSpec = sortSpec;
    }

    public SortSpecification getSortSpecification() {
        return this.m_sortSpec;
    }

    public boolean isEmpty() {
        if (this.getFilterSpecification() != null || this.getSortSpecification() != null) {
            return false;
        }
        ResultProjection resultProj = this.getResultProjection();
        return resultProj == null || resultProj.isEmpty();
    }

    public void validate(ValidationContext context) throws OdaException {
        try {
            if (context != null && context.getValidator() != null) {
                context.getValidator().validate(this, context);
            }
        }
        catch (OdaException ex) {
            QuerySpecificationHelper.logValidationException(sm_className, ex);
            throw ex;
        }
    }
}

