/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.ArrayList;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.INavigatable;

public class CompareEditorInputNavigator
extends CompareNavigator {
    private boolean fNextFirstTime = true;
    private final Object[] fPanes;

    public CompareEditorInputNavigator(Object[] panes) {
        this.fPanes = panes;
    }

    public Object[] getPanes() {
        return this.fPanes;
    }

    @Override
    protected INavigatable[] getNavigatables() {
        Object[] panes;
        ArrayList<INavigatable> result = new ArrayList<INavigatable>();
        Object[] objectArray = panes = this.getPanes();
        int n = panes.length;
        int n2 = 0;
        while (n2 < n) {
            Object pane = objectArray[n2];
            INavigatable navigator = this.getNavigator(pane);
            if (navigator != null) {
                result.add(navigator);
            }
            ++n2;
        }
        return result.toArray(new INavigatable[result.size()]);
    }

    @Override
    public boolean selectChange(boolean next) {
        if (next && this.fNextFirstTime && this.mustOpen()) {
            this.fNextFirstTime = false;
            if (this.openElement()) {
                return false;
            }
        }
        return super.selectChange(next);
    }

    private boolean mustOpen() {
        Object[] panes = this.getPanes();
        if (panes == null || panes.length == 0) {
            return false;
        }
        int i = 1;
        while (i < panes.length) {
            Object pane = panes[i];
            INavigatable nav = this.getNavigator(pane);
            if (nav != null && nav.getInput() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean openElement() {
        Object[] panes = this.getPanes();
        if (panes == null || panes.length == 0) {
            return false;
        }
        INavigatable nav = this.getNavigator(panes[0]);
        if (nav != null) {
            if (!nav.openSelectedChange()) {
                nav.selectChange(3);
            }
            return true;
        }
        return false;
    }
}

