/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.utils;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.PrivilegesUtil;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseAuthorizedObject;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasePrivilege;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasesqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Group;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.User;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ddl.IDDLGeneratorWrapper;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditorInput;
import org.eclipse.emf.common.util.EList;

public class HandlePrivilegeUtil {
    public static void handlePrivilegeDeltaDdl(StringBuffer sb, SQLObject clonedObj, SQLObject oriObj, List authids, List oriAuthids, IDDLGeneratorWrapper dGeneratorWrapper) {
        for (AuthorizationIdentifier authid : authids) {
            if (!(authid instanceof Group)) continue;
            List privs = PrivilegesUtil.getReceivedSQLObjectPrivileges(authid, clonedObj);
            for (SybasePrivilege p : privs) {
                Privilege oriPriv = PrivilegesUtil.getPrivilege(PrivilegesUtil.getOriginalAuthid(authid, oriAuthids), oriObj, p.getAction());
                if (oriPriv != null) continue;
                for (User u : ((Group)authid).getUser()) {
                    Privilege oriUserPriv;
                    Privilege userPriv = PrivilegesUtil.getPrivilege((AuthorizationIdentifier)u, clonedObj, p.getAction());
                    if (userPriv != null || (oriUserPriv = PrivilegesUtil.getPrivilege(PrivilegesUtil.getOriginalAuthid((AuthorizationIdentifier)u, oriAuthids), oriObj, p.getAction())) == null || oriUserPriv.isGrantable()) continue;
                    String[] ddl = dGeneratorWrapper.getCreateStatementsDDL(new SQLObject[]{oriUserPriv});
                    sb.append(ddl[1]);
                }
            }
        }
    }

    public static void handleRevokedPrivilege(Group authid, ISchemaObjectEditor editor, SQLObject sqlObj, String action) {
        SQLObject originalObj = ((SchemaObjectEditorInput)editor.getEditorInput()).getEditModelObject().getSchemaObjectImmutableModel().getMainSQLObject();
        if (sqlObj instanceof Column) {
            for (Column col : ((Table)originalObj).getColumns()) {
                if (!col.getName().equals(sqlObj.getName())) continue;
                originalObj = col;
            }
        }
        AuthorizationIdentifier orginalAuthid = PrivilegesUtil.getOriginalAuthid((AuthorizationIdentifier)authid, (List)((SchemaObjectEditorInput)editor.getEditorInput()).getEditModelObject().getSchemaObjectImmutableModel().getAdditionalSQLObjects().get("authids"));
        EList user = ((Group)orginalAuthid).getUser();
        Iterator iter = user.iterator();
        Privilege priv = null;
        Privilege clonedPriv = null;
        while (iter.hasNext()) {
            User u = (User)iter.next();
            priv = PrivilegesUtil.getPrivilege((AuthorizationIdentifier)u, originalObj, action);
            User clonedUser = (User)((SchemaObjectEditorInput)editor.getEditorInput()).getEditModelObject().getCopier().get((Object)u);
            clonedPriv = PrivilegesUtil.getPrivilege((AuthorizationIdentifier)clonedUser, sqlObj, action);
            if (clonedPriv != null || !(priv instanceof SybasePrivilege) || !((SybasePrivilege)priv).isRevoked()) continue;
            SybasePrivilege privilege = SybasesqlmodelFactory.eINSTANCE.createSybasePrivilege();
            privilege.setObject(sqlObj);
            privilege.setGrantee((AuthorizationIdentifier)clonedUser);
            privilege.setRevoked(true);
            privilege.setAction(action);
            clonedUser.getReceivedPrivilege().add((Object)privilege);
            if (!(sqlObj instanceof SybaseAuthorizedObject)) continue;
            ((SybaseAuthorizedObject)sqlObj).getPrivileges().add((Object)privilege);
        }
    }
}

