/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.doubleclick;

import java.util.Arrays;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class CSSDoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    private static final char[] NON_BREAKERS = new char[]{'-'};

    static {
        Arrays.sort(NON_BREAKERS);
    }

    protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
        IRegion word = super.findExtendedDoubleClickSelection(document, offset);
        if (word != null) {
            return word;
        }
        word = this.findWord(document, offset);
        if (word != null) {
            int end;
            int start;
            block9: {
                IRegion line;
                block8: {
                    line = document.getLineInformationOfOffset(offset);
                    if (offset != line.getOffset() + line.getLength()) break block8;
                    return null;
                }
                try {
                    start = word.getOffset();
                    end = start + word.getLength();
                    while (start > 0 && Arrays.binarySearch(NON_BREAKERS, document.getChar(start - 1)) > -1) {
                        IRegion previous;
                        if ((previous = this.findWord(document, --start)) == null) break;
                        start = previous.getOffset();
                    }
                    while (end < line.getOffset() + line.getLength() && Arrays.binarySearch(NON_BREAKERS, document.getChar(end)) > -1) {
                        IRegion next = this.findExtendedDoubleClickSelection(document, end + 1);
                        if (next == null) break;
                        end = next.getOffset() + next.getLength();
                    }
                    if (start != end) break block9;
                    return null;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            return new Region(start, end - start);
        }
        return null;
    }
}

