/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.JaxbTypeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaContextNode;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.jpt.jaxb.core.xsd.XsdUtil;

public abstract class AbstractJavaAttributeMapping<A extends Annotation>
extends AbstractJavaContextNode
implements JavaAttributeMapping {
    protected boolean default_ = this.buildDefault();

    protected AbstractJavaAttributeMapping(JavaPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public JaxbClassMapping getClassMapping() {
        return this.getPersistentAttribute().getClassMapping();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncDefault();
    }

    public A getAnnotation() {
        return (A)this.getJavaResourceAttribute().getAnnotation(this.getAnnotationName());
    }

    protected abstract String getAnnotationName();

    public A getOrCreateAnnotation() {
        A annotation = this.getAnnotation();
        if (annotation == null) {
            this.getPersistentAttribute().setMappingKey(this.getKey());
            annotation = this.getAnnotation();
            if (annotation == null) {
                throw new IllegalStateException("missing annotation: " + this);
            }
        }
        return annotation;
    }

    @Override
    public boolean isDefault() {
        return this.default_;
    }

    protected void setDefault(boolean default_) {
        boolean old = this.default_;
        this.default_ = default_;
        this.firePropertyChanged("default", old, default_);
    }

    public void syncDefault() {
        this.setDefault(this.buildDefault());
    }

    protected boolean buildDefault() {
        return this.getAnnotation() == null;
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getAnnotation() == null ? this.getJavaResourceAttribute().getNameTextRange() : this.getAnnotation().getTextRange();
    }

    @Override
    public JavaPersistentAttribute getPersistentAttribute() {
        return (JavaPersistentAttribute)super.getParent();
    }

    protected JaxbPackage getJaxbPackage() {
        return this.getClassMapping().getJaxbPackage();
    }

    @Override
    public JavaResourceAttribute getJavaResourceAttribute() {
        return this.getPersistentAttribute().getJavaResourceAttribute();
    }

    @Override
    public String getBoundTypeName() {
        return this.getPersistentAttribute().getJavaResourceAttributeBaseTypeName();
    }

    @Override
    public String getValueTypeName() {
        return this.getBoundTypeName();
    }

    @Override
    public String getDataTypeName() {
        return this.getValueTypeName();
    }

    @Override
    public XsdTypeDefinition getDataTypeXsdTypeDefinition() {
        JaxbTypeMapping jaxbTypeMapping;
        JaxbPackageInfo pkgInfo;
        String dataType = this.getDataTypeName();
        if (StringTools.isBlank((String)dataType)) {
            return null;
        }
        JaxbPackage pkg = this.getJaxbPackage();
        JaxbPackageInfo jaxbPackageInfo = pkgInfo = pkg == null ? null : pkg.getPackageInfo();
        if (pkgInfo != null) {
            for (XmlSchemaType schemaType : pkgInfo.getXmlSchemaTypes()) {
                if (!dataType.equals(schemaType.getFullyQualifiedType())) continue;
                return schemaType.getXsdTypeDefinition();
            }
        }
        if ((jaxbTypeMapping = this.getContextRoot().getTypeMapping(dataType)) != null) {
            return jaxbTypeMapping.getXsdTypeDefinition();
        }
        String builtInType = this.getJaxbProject().getPlatform().getDefinition().getSchemaTypeMapping(dataType);
        if (builtInType != null && this.getJaxbPackage().getXsdSchema() != null) {
            return XsdUtil.getSchemaForSchema().getTypeDefinition(builtInType);
        }
        return null;
    }

    @Override
    public Iterable<String> getReferencedXmlTypeNames() {
        return new SingleElementIterable((Object)this.getValueTypeName());
    }

    @Override
    public boolean isParticleMapping() {
        return false;
    }

    @Override
    public boolean isTransient() {
        return false;
    }
}

