/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.core.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.data.internal.core.editor.ITableEditorResultFilter;

public class TableEditorFilterRegistryReader {
    public static final String TABLE_EDITOR_RESULT_FILTER = "org.eclipse.datatools.sqltools.data.core.tableEditorResultFilter";
    public static final String TABLE_EDITOR_RESULT_FILTER_VENDOR = "vendor";
    public static final String TABLE_EDITOR_RESULT_FILTER_CLASS = "class";
    private static TableEditorFilterRegistryReader myInstance;
    private boolean filterCanceled;
    private ITableEditorResultFilter filterClass;

    private TableEditorFilterRegistryReader() {
    }

    public static synchronized TableEditorFilterRegistryReader getInstance() {
        if (myInstance == null) {
            myInstance = new TableEditorFilterRegistryReader();
        }
        return myInstance;
    }

    public String getVendor() {
        IExtension ext;
        IConfigurationElement[] configElements;
        IExtension[] extensions;
        String vendor = null;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(TABLE_EDITOR_RESULT_FILTER);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length > 0 && (configElements = (ext = extensions[0]).getConfigurationElements()).length > 0) {
            vendor = configElements[0].getAttribute(TABLE_EDITOR_RESULT_FILTER_VENDOR);
        }
        return vendor;
    }

    public ITableEditorResultFilter getTableEditorResultFilter() {
        if (this.filterClass == null) {
            return this.createTableEditorResultFilterExecutable();
        }
        return this.filterClass;
    }

    public ITableEditorResultFilter createTableEditorResultFilterExecutable() {
        this.filterClass = null;
        try {
            IExtension ext;
            IConfigurationElement[] configElements;
            IExtension[] extensions;
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(TABLE_EDITOR_RESULT_FILTER);
            if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length > 0 && (configElements = (ext = extensions[0]).getConfigurationElements()).length > 0) {
                this.filterClass = (ITableEditorResultFilter)configElements[0].createExecutableExtension(TABLE_EDITOR_RESULT_FILTER_CLASS);
            }
        }
        catch (CoreException coreException) {}
        return this.filterClass;
    }

    public boolean isMatchingVendor(Table aTable) {
        boolean matching = false;
        if (aTable != null) {
            String vendor = this.getVendor();
            if (vendor == null || vendor.trim().equals("")) {
                matching = true;
            } else {
                String vendorFromTable = aTable.getSchema().getDatabase().getVendor();
                if (vendor.equalsIgnoreCase(vendorFromTable)) {
                    matching = true;
                }
            }
        }
        return matching;
    }

    public boolean isExtenionFound() {
        IExtension[] extensions;
        boolean found = false;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(TABLE_EDITOR_RESULT_FILTER);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()).length > 0) {
            found = true;
        }
        return found;
    }

    public void setFilterCanceled(boolean cancel) {
        this.filterCanceled = cancel;
    }

    public boolean isFilterCanceled() {
        return this.filterCanceled;
    }
}

