/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model;

import com.google.common.base.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;

public class TableColumnDescriptor
implements ITableColumnDescriptor {
    private final long fId;
    private final String fText;
    private final String fTooltipText;
    private final DataType fDataType;
    private final boolean fHiddenByDefault;

    private TableColumnDescriptor(Builder builder) {
        this.fId = builder.fId;
        this.fText = builder.fText;
        this.fTooltipText = builder.fTooltipText;
        this.fDataType = builder.fDataType;
        this.fHiddenByDefault = builder.fHiddenByDefault;
    }

    @Override
    public long getId() {
        return this.fId;
    }

    @Override
    public String getText() {
        return this.fText;
    }

    @Override
    public String getTooltip() {
        return this.fTooltipText;
    }

    @Override
    public boolean isHiddenByDefault() {
        return this.fHiddenByDefault;
    }

    @Override
    public DataType getDataType() {
        return this.fDataType;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ITableColumnDescriptor)) {
            return false;
        }
        ITableColumnDescriptor other = (ITableColumnDescriptor)obj;
        return Objects.equal((Object)this.fId, (Object)other.getId()) && Objects.equal((Object)this.fText, (Object)other.getText()) && Objects.equal((Object)this.fTooltipText, (Object)other.getTooltip()) && Objects.equal((Object)((Object)this.fDataType), (Object)((Object)other.getDataType())) && Objects.equal((Object)this.fHiddenByDefault, (Object)other.isHiddenByDefault());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fId, this.fText, this.fTooltipText, this.fDataType, this.fHiddenByDefault});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        if (this.fId != -1L) {
            builder.append("id=").append(this.fId).append(" ");
        }
        builder.append("text=").append(this.fText).append(" tooltip=").append(this.fTooltipText).append(" dataType=").append(this.fDataType.toString());
        if (this.fHiddenByDefault) {
            builder.append(" hiddenByDefault=").append(this.fHiddenByDefault);
        }
        builder.append("]");
        return builder.toString();
    }

    public static class Builder {
        private long fId = -1L;
        private String fText = "";
        private String fTooltipText = "";
        private DataType fDataType = DataType.STRING;
        private boolean fHiddenByDefault = false;

        public Builder setId(long id) {
            this.fId = id;
            return this;
        }

        public Builder setText(String text) {
            this.fText = text;
            return this;
        }

        public Builder setTooltip(String tooltip) {
            this.fTooltipText = tooltip;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.fDataType = dataType;
            return this;
        }

        public Builder setHiddenByDefault(boolean hiddenByDefault) {
            this.fHiddenByDefault = hiddenByDefault;
            return this;
        }

        public TableColumnDescriptor build() {
            return new TableColumnDescriptor(this);
        }
    }
}

