/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;

public class TextTaskAttachmentSource
extends AbstractTaskAttachmentSource {
    private final String contents;

    public TextTaskAttachmentSource(String contents) {
        this.contents = contents;
    }

    @Override
    public InputStream createInputStream(IProgressMonitor monitor) throws CoreException {
        return new ByteArrayInputStream(this.contents.getBytes());
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public long getLength() {
        return this.contents.getBytes().length;
    }

    @Override
    public String getName() {
        return "clipboard.txt";
    }

    @Override
    public boolean isLocal() {
        return true;
    }
}

