/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.EditDistance;
import org.apache.commons.text.similarity.SimilarityInput;

public class DamerauLevenshteinDistance
implements EditDistance<Integer> {
    private final Integer threshold;

    private static int clampDistance(int distance, int threshold) {
        return distance > threshold ? -1 : distance;
    }

    private static <E> int limitedCompare(SimilarityInput<E> left, SimilarityInput<E> right, int threshold) {
        int rightIndex;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Left/right inputs must not be null");
        }
        int leftLength = left.length();
        int rightLength = right.length();
        if (leftLength == 0) {
            return DamerauLevenshteinDistance.clampDistance(rightLength, threshold);
        }
        if (rightLength == 0) {
            return DamerauLevenshteinDistance.clampDistance(leftLength, threshold);
        }
        if (rightLength > leftLength) {
            SimilarityInput<E> tmp = left;
            left = right;
            right = tmp;
            leftLength = rightLength;
            rightLength = right.length();
        }
        if (leftLength - rightLength > threshold) {
            return -1;
        }
        int[] curr = new int[rightLength + 1];
        int[] prev = new int[rightLength + 1];
        int[] prevPrev = new int[rightLength + 1];
        for (rightIndex = 0; rightIndex <= rightLength; ++rightIndex) {
            prev[rightIndex] = rightIndex;
        }
        for (int leftIndex = 1; leftIndex <= leftLength; ++leftIndex) {
            curr[0] = leftIndex;
            int minCost = Integer.MAX_VALUE;
            for (rightIndex = 1; rightIndex <= rightLength; ++rightIndex) {
                int cost = left.at(leftIndex - 1) == right.at(rightIndex - 1) ? 0 : 1;
                curr[rightIndex] = Math.min(Math.min(prev[rightIndex] + 1, curr[rightIndex - 1] + 1), prev[rightIndex - 1] + cost);
                if (leftIndex > 1 && rightIndex > 1 && left.at(leftIndex - 1) == right.at(rightIndex - 2) && left.at(leftIndex - 2) == right.at(rightIndex - 1)) {
                    curr[rightIndex] = Math.min(curr[rightIndex], prevPrev[rightIndex - 2] + cost);
                }
                minCost = Math.min(curr[rightIndex], minCost);
            }
            if (minCost > threshold) {
                return -1;
            }
            int[] temp = prevPrev;
            prevPrev = prev;
            prev = curr;
            curr = temp;
        }
        return DamerauLevenshteinDistance.clampDistance(prev[rightLength], threshold);
    }

    private static <E> int unlimitedCompare(SimilarityInput<E> left, SimilarityInput<E> right) {
        int rightIndex;
        if (left == null || right == null) {
            throw new IllegalArgumentException("Left/right inputs must not be null");
        }
        int leftLength = left.length();
        int rightLength = right.length();
        if (leftLength == 0) {
            return rightLength;
        }
        if (rightLength == 0) {
            return leftLength;
        }
        if (rightLength > leftLength) {
            SimilarityInput<E> tmp = left;
            left = right;
            right = tmp;
            leftLength = rightLength;
            rightLength = right.length();
        }
        int[] curr = new int[rightLength + 1];
        int[] prev = new int[rightLength + 1];
        int[] prevPrev = new int[rightLength + 1];
        for (rightIndex = 0; rightIndex <= rightLength; ++rightIndex) {
            prev[rightIndex] = rightIndex;
        }
        for (int leftIndex = 1; leftIndex <= leftLength; ++leftIndex) {
            curr[0] = leftIndex;
            for (rightIndex = 1; rightIndex <= rightLength; ++rightIndex) {
                int cost = left.at(leftIndex - 1) == right.at(rightIndex - 1) ? 0 : 1;
                curr[rightIndex] = Math.min(Math.min(prev[rightIndex] + 1, curr[rightIndex - 1] + 1), prev[rightIndex - 1] + cost);
                if (leftIndex <= 1 || rightIndex <= 1 || left.at(leftIndex - 1) != right.at(rightIndex - 2) || left.at(leftIndex - 2) != right.at(rightIndex - 1)) continue;
                curr[rightIndex] = Math.min(curr[rightIndex], prevPrev[rightIndex - 2] + cost);
            }
            int[] temp = prevPrev;
            prevPrev = prev;
            prev = curr;
            curr = temp;
        }
        return prev[rightLength];
    }

    public DamerauLevenshteinDistance() {
        this(null);
    }

    public DamerauLevenshteinDistance(Integer threshold) {
        if (threshold != null && threshold < 0) {
            throw new IllegalArgumentException("Threshold must not be negative");
        }
        this.threshold = threshold;
    }

    @Override
    public Integer apply(CharSequence left, CharSequence right) {
        return this.apply(SimilarityInput.input(left), SimilarityInput.input(right));
    }

    @Override
    public <E> Integer apply(SimilarityInput<E> left, SimilarityInput<E> right) {
        if (this.threshold != null) {
            return DamerauLevenshteinDistance.limitedCompare(left, right, this.threshold);
        }
        return DamerauLevenshteinDistance.unlimitedCompare(left, right);
    }

    public Integer getThreshold() {
        return this.threshold;
    }
}

