/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.cdt.debug.internal.core.RegisterGroupsPersistance;
import org.eclipse.cdt.debug.internal.core.model.IRegisterGroupDescriptor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.CompositeDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRegisters;
import org.eclipse.cdt.dsf.debug.service.IRegisters2;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.Messages;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIProcessDMContext;
import org.eclipse.cdt.dsf.mi.service.MIRegisters;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;

public class GDBRegisters
extends MIRegisters
implements IRegisters2 {
    private boolean groupsRead = false;
    private static int fGroupBookingCount = 1;
    private final ContextToGroupsMap<IRunControl.IContainerDMContext, MIRegisters.MIRegisterGroupDMC[]> fContextToGroupsMap = new ContextToGroupsMap();
    private final GroupRegistersMap<MIRegisters.MIRegisterGroupDMC, MIRegisters.MIRegisterDMC[]> fGroupToRegistersMap = new GroupRegistersMap();
    private final Map<Integer, IRegisterGroupDescriptor> fGroupMementoDescriptorIndex = new HashMap<Integer, IRegisterGroupDescriptor>();

    public GDBRegisters(DsfSession session) {
        super(session);
    }

    @Override
    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            public void handleSuccess() {
                GDBRegisters.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{IRegisters.class.getName(), IRegisters2.class.getName(), MIRegisters.class.getName(), GDBRegisters.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    @Override
    public void getRegisterGroups(IDMContext ctx, final DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]> rm) {
        final IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IRunControl.IContainerDMContext.class);
        if (contDmc == null) {
            Status status = new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Container context not provided, unable to get Register Groups", null);
            rm.setStatus((IStatus)status);
            rm.done();
            return;
        }
        if (this.fContextToGroupsMap.containsKey(contDmc)) {
            rm.setData((Object)this.fContextToGroupsMap.getReversed((IDMContext)contDmc));
            rm.done();
            return;
        }
        super.getRegisterGroups(ctx, (DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]>)new ImmediateDataRequestMonitor<IRegisters.IRegisterGroupDMContext[]>(rm){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                IRegisters.IRegisterGroupDMContext[] regGroups = (IRegisters.IRegisterGroupDMContext[])this.getData();
                if (!$assertionsDisabled && regGroups.length != 1) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !(regGroups[0] instanceof MIRegisters.MIRegisterGroupDMC)) {
                    throw new AssertionError();
                }
                MIRegisters.MIRegisterGroupDMC miGroup = (MIRegisters.MIRegisterGroupDMC)regGroups[0];
                MIRegisters.MIRegisterGroupDMC[] mementoGroups = GDBRegisters.this.readGroupsFromMemento(contDmc);
                MIRegisters.MIRegisterGroupDMC[] regGroupsCtx = GDBRegisters.this.concatenateArr(new MIRegisters.MIRegisterGroupDMC[]{miGroup}, mementoGroups);
                GDBRegisters.this.fContextToGroupsMap.put(contDmc, regGroupsCtx);
                rm.setData((Object)GDBRegisters.this.fContextToGroupsMap.getReversed((IDMContext)contDmc));
                rm.done();
            }
        });
    }

    @Override
    public void getRegisterGroupData(IRegisters.IRegisterGroupDMContext regGroupDmc, DataRequestMonitor<IRegisters.IRegisterGroupDMData> rm) {
        assert (regGroupDmc instanceof MIRegisters.MIRegisterGroupDMC);
        if (regGroupDmc instanceof MIRegisters.MIRegisterGroupDMC) {
            MIRegisters.MIRegisterGroupDMC groupDmc = (MIRegisters.MIRegisterGroupDMC)regGroupDmc;
            rm.setData((Object)this.createRegisterGroupData(groupDmc));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unable to resolve Group Data, Invalid Register Group provided", null));
        }
        rm.done();
    }

    private IRegisters.IRegisterGroupDMData createRegisterGroupData(final MIRegisters.MIRegisterGroupDMC groupDmc) {
        IRegisters.IRegisterGroupDMData groupData = new IRegisters.IRegisterGroupDMData(){

            public String getName() {
                return groupDmc.getName();
            }

            public String getDescription() {
                if (groupDmc.getName().equals(ROOT_GROUP_NAME)) {
                    return ROOT_GROUP_DESCRIPTION;
                }
                return "";
            }
        };
        if (this.fGroupToRegistersMap.get((Object)groupDmc) == null) {
            this.fGroupToRegistersMap.put(groupDmc, new MIRegisters.MIRegisterDMC[0]);
        }
        return groupData;
    }

    @Override
    public void getRegisters(final IDMContext aCtx, final DataRequestMonitor<IRegisters.IRegisterDMContext[]> rm) {
        this.findRegisterGroup(aCtx, ROOT_GROUP_NAME, (DataRequestMonitor<IRegisters.IRegisterGroupDMContext>)new ImmediateDataRequestMonitor<IRegisters.IRegisterGroupDMContext>(){

            protected void handleSuccess() {
                IRegisters.IRegisterGroupDMContext rootGroup = (IRegisters.IRegisterGroupDMContext)this.getData();
                if (!$assertionsDisabled && !(rootGroup instanceof MIRegisters.MIRegisterGroupDMC)) {
                    throw new AssertionError();
                }
                final MIRegisters.MIRegisterGroupDMC rootGroupContext = (MIRegisters.MIRegisterGroupDMC)rootGroup;
                MIRegisters.MIRegisterGroupDMC tGroupDmc = (MIRegisters.MIRegisterGroupDMC)DMContexts.getAncestorOfType((IDMContext)aCtx, MIRegisters.MIRegisterGroupDMC.class);
                IDMContext tCtx = aCtx;
                if (tGroupDmc == null) {
                    tGroupDmc = rootGroupContext;
                    tCtx = new CompositeDMContext(new IDMContext[]{aCtx, tGroupDmc});
                }
                final IDMContext ctx = tCtx;
                final MIRegisters.MIRegisterGroupDMC groupDmc = tGroupDmc;
                MIRegisters.MIRegisterDMC[] baseRegisters = (MIRegisters.MIRegisterDMC[])GDBRegisters.this.fGroupToRegistersMap.get((Object)groupDmc);
                if (baseRegisters != null && baseRegisters.length > 0) {
                    GDBRegisters.this.buildGroupRegisters(ctx, baseRegisters, (DataRequestMonitor<IRegisters.IRegisterDMContext[]>)rm);
                    return;
                }
                IRunControl.IContainerDMContext rootGroupContainer = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)rootGroupContext, IRunControl.IContainerDMContext.class);
                MIRegisters.MIRegisterDMC[] registerBase = (MIRegisters.MIRegisterDMC[])GDBRegisters.this.fGroupToRegistersMap.get(rootGroupContainer);
                if (registerBase == null || registerBase.length < 1) {
                    IDMContext miExecDmc = DMContexts.getAncestorOfType((IDMContext)ctx, IStack.IFrameDMContext.class);
                    if (miExecDmc == null) {
                        miExecDmc = DMContexts.getAncestorOfType((IDMContext)ctx, IMIExecutionDMContext.class);
                    }
                    CompositeDMContext compCtx = miExecDmc != null ? new CompositeDMContext(new IDMContext[]{rootGroupContext, miExecDmc}) : new CompositeDMContext(new IDMContext[]{rootGroupContext});
                    GDBRegisters.access$2(GDBRegisters.this, (IDMContext)compCtx, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMContext[]>((Executor)GDBRegisters.this.getExecutor(), (RequestMonitor)rm){

                        @ConfinedToDsfExecutor(value="fExecutor")
                        protected void handleSuccess() {
                            IRegisters.IRegisterDMContext[] iregisters = (IRegisters.IRegisterDMContext[])this.getData();
                            MIRegisters.MIRegisterDMC[] registers = (MIRegisters.MIRegisterDMC[])Arrays.copyOf(iregisters, iregisters.length, MIRegisters.MIRegisterDMC[].class);
                            (this).GDBRegisters.this.fGroupToRegistersMap.put(rootGroupContext, GDBRegisters.this.toBareRegisters(registers));
                            if (groupDmc.getName().equals(ROOT_GROUP_NAME)) {
                                GDBRegisters.this.buildGroupRegisters(ctx, registers, (DataRequestMonitor<IRegisters.IRegisterDMContext[]>)rm);
                                return;
                            }
                            GDBRegisters.this.getUserGroupRegisters(ctx, (DataRequestMonitor<IRegisters.IRegisterDMContext[]>)rm);
                        }
                    });
                } else if (groupDmc.getName().equals(ROOT_GROUP_NAME)) {
                    GDBRegisters.this.buildGroupRegisters(ctx, registerBase, (DataRequestMonitor<IRegisters.IRegisterDMContext[]>)rm);
                } else {
                    GDBRegisters.this.getUserGroupRegisters(ctx, (DataRequestMonitor<IRegisters.IRegisterDMContext[]>)rm);
                }
            }
        });
    }

    public void canAddRegisterGroup(IDMContext selectionContext, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    public void addRegisterGroup(IDMContext containerContext, String groupName, IRegisters.IRegisterDMContext[] registers, RequestMonitor rm) {
        if (registers == null || registers.length < 1) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, Messages.RegisterGroup_invalid_number_of_registers, null));
            rm.done();
            return;
        }
        if (groupName.trim().toLowerCase().equals(ROOT_GROUP_NAME.toLowerCase())) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, NLS.bind((String)Messages.RegisterGroup_name_reserved, (Object)ROOT_GROUP_NAME), null));
            rm.done();
            return;
        }
        if (!(registers[0] instanceof MIRegisters.MIRegisterDMC)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Unexpected IRegisterDMContext input instance type", null));
            rm.done();
            return;
        }
        IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)registers[0], IRunControl.IContainerDMContext.class);
        if (contDmc == null && (contDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)containerContext, IRunControl.IContainerDMContext.class)) == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Unable to add Register group, Invalid Container", null));
            rm.done();
            return;
        }
        if (this.fContextToGroupsMap.getGroupNameMap(contDmc).get(groupName) != null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, NLS.bind((String)Messages.RegisterGroup_name_used, (Object)groupName), null));
            rm.done();
            return;
        }
        MIRegisters.MIRegisterGroupDMC group = new MIRegisters.MIRegisterGroupDMC(this, contDmc, fGroupBookingCount, groupName);
        ++fGroupBookingCount;
        this.fContextToGroupsMap.put(contDmc, this.concatenateArr((MIRegisters.MIRegisterGroupDMC[])this.fContextToGroupsMap.get(contDmc), new MIRegisters.MIRegisterGroupDMC[]{group}));
        MIRegisters.MIRegisterDMC[] miRegisters = (MIRegisters.MIRegisterDMC[])Arrays.copyOf(registers, registers.length, MIRegisters.MIRegisterDMC[].class);
        MIRegisters.MIRegisterDMC[] bareRegisters = this.toBareRegisters(miRegisters);
        this.fGroupToRegistersMap.put(group, bareRegisters);
        this.getSession().dispatchEvent((Object)new MIRegisters.GroupsChangedDMEvent(contDmc), null);
        rm.done();
    }

    public void canEditRegisterGroup(IRegisters.IRegisterGroupDMContext group, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.canEditRegisterGroup(group));
        rm.done();
    }

    public void editRegisterGroup(IRegisters.IRegisterGroupDMContext group, String newGroupName, IRegisters.IRegisterDMContext[] iRegisters, RequestMonitor rm) {
        if (iRegisters != null && iRegisters.length == 0) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, Messages.RegisterGroup_invalid_number_of_registers, null));
            return;
        }
        if (!(group instanceof MIRegisters.MIRegisterGroupDMC)) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unknown DMC type", null));
            return;
        }
        IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)group, IRunControl.IContainerDMContext.class);
        if (contDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Unable to edit Register group, Invalid Container", null));
            rm.done();
        }
        MIRegisters.MIRegisterGroupDMC miGroup = (MIRegisters.MIRegisterGroupDMC)group;
        if (!this.canEditRegisterGroup(group)) {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Cannot currently edit register groups", null));
            return;
        }
        if (newGroupName != null && !newGroupName.isEmpty()) {
            if (newGroupName.trim().toLowerCase().equals(ROOT_GROUP_NAME.toLowerCase())) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, NLS.bind((String)Messages.RegisterGroup_name_reserved, (Object)ROOT_GROUP_NAME), null));
                rm.done();
                return;
            }
            if (!miGroup.getName().equals(newGroupName) && this.fContextToGroupsMap.getGroupNameMap(contDmc).get(newGroupName) != null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10003, NLS.bind((String)Messages.RegisterGroup_name_used, (Object)newGroupName), null));
                rm.done();
                return;
            }
            miGroup.setName(newGroupName);
            this.fContextToGroupsMap.resetGroupNameMap(contDmc);
            this.generateRegisterGroupChangedEvent(miGroup);
        }
        if (iRegisters != null) {
            assert (iRegisters.length > 0);
            MIRegisters.MIRegisterDMC[] registers = this.arrangeRegisters(iRegisters);
            registers = this.toBareRegisters(registers);
            this.fGroupToRegistersMap.put(miGroup, registers);
            this.generateRegistersChangedEvent(miGroup);
        }
        rm.done();
    }

    public void removeRegisterGroups(IRegisters.IRegisterGroupDMContext[] groups, RequestMonitor rm) {
        this.removeRegisterGroups(groups, false, rm);
    }

    public void restoreDefaultGroups(IDMContext selectionContext, RequestMonitor rm) {
        for (IDMContext context : this.fContextToGroupsMap.keySet()) {
            this.removeRegisterGroups(context);
        }
        this.save();
        this.fContextToGroupsMap.clear();
        rm.done();
    }

    public void reset(RequestMonitor rm) {
        for (IDMContext context : this.fContextToGroupsMap.keySet()) {
            this.removeRegisterGroups(context);
        }
        this.fContextToGroupsMap.clear();
        rm.done();
    }

    @Override
    public void findRegisterGroup(IDMContext ctx, final String name, final DataRequestMonitor<IRegisters.IRegisterGroupDMContext> rm) {
        final IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IRunControl.IContainerDMContext.class);
        if (contDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Container context not found", null));
            rm.done();
            return;
        }
        if (this.fContextToGroupsMap.get(ctx) == null) {
            this.getRegisterGroups((IDMContext)contDmc, new DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    GDBRegisters.this.findRegisterGroup(contDmc, name, (DataRequestMonitor<IRegisters.IRegisterGroupDMContext>)rm);
                }
            });
        } else {
            this.findRegisterGroup(contDmc, name, rm);
        }
    }

    private void findRegisterGroup(IRunControl.IContainerDMContext contDmc, String name, DataRequestMonitor<IRegisters.IRegisterGroupDMContext> rm) {
        Map<String, MIRegisters.MIRegisterGroupDMC> nameToGroup = this.fContextToGroupsMap.getGroupNameMap(contDmc);
        if (nameToGroup != null) {
            rm.setData((Object)nameToGroup.get(name));
        } else {
            rm.setData(null);
        }
        rm.done();
    }

    @Override
    public void shutdown(RequestMonitor rm) {
        if (this.groupsRead) {
            this.save();
        }
        super.shutdown(rm);
    }

    public void save() {
        IRegisterGroupDescriptor[] groups = this.buildDescriptors();
        ILaunchConfiguration launchConfig = this.getLaunchConfig();
        if (launchConfig != null) {
            RegisterGroupsPersistance serializer = new RegisterGroupsPersistance(launchConfig);
            try {
                serializer.saveGroups(groups);
            }
            catch (CoreException e) {
                GdbPlugin.log(e);
            }
        }
    }

    private MIRegisters.MIRegisterDMC[] arrangeRegisters(IRegisters.IRegisterDMContext[] iRegisters) {
        TreeMap<Integer, MIRegisters.MIRegisterDMC> sortedRegisters = new TreeMap<Integer, MIRegisters.MIRegisterDMC>();
        int i = 0;
        while (i < iRegisters.length) {
            assert (iRegisters[i] instanceof MIRegisters.MIRegisterDMC);
            MIRegisters.MIRegisterDMC register = (MIRegisters.MIRegisterDMC)iRegisters[i];
            sortedRegisters.put(register.getRegNo(), register);
            ++i;
        }
        return sortedRegisters.values().toArray(new MIRegisters.MIRegisterDMC[sortedRegisters.size()]);
    }

    private void removeRegisterGroups(IRegisters.IRegisterGroupDMContext[] groups, boolean removeRoot, RequestMonitor rm) {
        block10: {
            if (groups == null) break block10;
            HashSet<IRunControl.IContainerDMContext> updatedContainers = new HashSet<IRunControl.IContainerDMContext>();
            IRegisters.IRegisterGroupDMContext[] iRegisterGroupDMContextArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                block13: {
                    IRegisters.IRegisterGroupDMContext group;
                    block11: {
                        block12: {
                            group = iRegisterGroupDMContextArray[n2];
                            if (removeRoot) break block11;
                            if (group instanceof MIRegisters.MIRegisterGroupDMC) break block12;
                            assert (false);
                            break block13;
                        }
                        if (((MIRegisters.MIRegisterGroupDMC)group).getName().equals(ROOT_GROUP_NAME)) break block13;
                    }
                    IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)group, IRunControl.IContainerDMContext.class);
                    MIRegisters.MIRegisterGroupDMC[] groupsCtx = (MIRegisters.MIRegisterGroupDMC[])this.fContextToGroupsMap.get(containerDmc);
                    assert (groupsCtx != null);
                    if (groupsCtx != null) {
                        ArrayList<MIRegisters.MIRegisterGroupDMC> groupsList = new ArrayList<MIRegisters.MIRegisterGroupDMC>(Arrays.asList(groupsCtx));
                        groupsList.remove(group);
                        this.fContextToGroupsMap.put(containerDmc, groupsList.toArray(new MIRegisters.MIRegisterGroupDMC[groupsList.size()]));
                        if (this.fGroupToRegistersMap.remove(group) != null) {
                            updatedContainers.add(containerDmc);
                        }
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Unable to remove Register group, Invalid Container", null));
                        rm.done();
                        return;
                    }
                }
                ++n2;
            }
            for (IRunControl.IContainerDMContext container : updatedContainers) {
                this.getSession().dispatchEvent((Object)new MIRegisters.GroupsChangedDMEvent(container), null);
            }
        }
        rm.done();
    }

    private void removeRegisterGroups(IDMContext containerDmc) {
        IRegisters.IRegisterGroupDMContext[] groups = (MIRegisters.MIRegisterGroupDMC[])this.fContextToGroupsMap.get(containerDmc);
        if (groups != null) {
            this.removeRegisterGroups(groups, true, new RequestMonitor((Executor)this.getExecutor(), null){});
        }
    }

    private boolean canEditRegisterGroup(IRegisters.IRegisterGroupDMContext group) {
        if (group instanceof MIRegisters.MIRegisterGroupDMC) {
            MIRegisters.MIRegisterGroupDMC miGroup = (MIRegisters.MIRegisterGroupDMC)group;
            if (miGroup.getName().trim().toLowerCase().equals(ROOT_GROUP_NAME.toLowerCase())) {
                return false;
            }
            if (this.fGroupToRegistersMap.containsKey(group)) {
                return true;
            }
        }
        return false;
    }

    private ILaunchConfiguration getLaunchConfig() {
        ILaunch launch = (ILaunch)this.getSession().getModelAdapter(ILaunch.class);
        if (launch == null) {
            return null;
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        return config;
    }

    IRegisterGroupDescriptor[] buildDescriptors() {
        TreeMap<Integer, MIRegisters.MIRegisterGroupDMC> sortedGroups = new TreeMap<Integer, MIRegisters.MIRegisterGroupDMC>();
        for (MIRegisters.MIRegisterGroupDMC group : this.fGroupToRegistersMap.keySet()) {
            sortedGroups.put(group.getGroupNo(), group);
        }
        sortedGroups.remove(0);
        Set groupSet = sortedGroups.entrySet();
        IRegisterGroupDescriptor[] descriptors = new IRegisterGroupDescriptor[groupSet.size()];
        int i = 0;
        for (Map.Entry groupEntry : groupSet) {
            descriptors[i] = new RegisterGroupDescriptor((MIRegisters.MIRegisterGroupDMC)((Object)groupEntry.getValue()), true);
            ++i;
        }
        return descriptors;
    }

    private <T> T[] concatenateArr(T[] origArr, T[] deltaArr) {
        if (origArr == null) {
            return deltaArr;
        }
        if (deltaArr == null) {
            return origArr;
        }
        T[] newArr = Arrays.copyOf(origArr, origArr.length + deltaArr.length);
        System.arraycopy(deltaArr, 0, newArr, origArr.length, deltaArr.length);
        return newArr;
    }

    MIRegisters.MIRegisterGroupDMC[] readGroupsFromMemento(IRunControl.IContainerDMContext contDmc) {
        IRegisterGroupDescriptor[] groupDescriptions;
        this.groupsRead = true;
        String containerId = this.getPersistenceIdForRegisterGroupContainer(contDmc);
        RegisterGroupsPersistance deserializer = new RegisterGroupsPersistance(this.getLaunchConfig());
        try {
            groupDescriptions = deserializer.parseGroups(containerId);
        }
        catch (CoreException e) {
            return new MIRegisters.MIRegisterGroupDMC[0];
        }
        ArrayList<MIRegisters.MIRegisterGroupDMC> groups = new ArrayList<MIRegisters.MIRegisterGroupDMC>();
        IRegisterGroupDescriptor[] iRegisterGroupDescriptorArray = groupDescriptions;
        int n = groupDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            IRegisterGroupDescriptor group = iRegisterGroupDescriptorArray[n2];
            this.fGroupMementoDescriptorIndex.put(fGroupBookingCount, group);
            groups.add(new MIRegisters.MIRegisterGroupDMC(this, contDmc, fGroupBookingCount, group.getName()));
            ++fGroupBookingCount;
            ++n2;
        }
        return groups.toArray(new MIRegisters.MIRegisterGroupDMC[groups.size()]);
    }

    protected String getPersistenceIdForRegisterGroupContainer(IRunControl.IContainerDMContext contDmc) {
        if (this.useProcessIdAsRegisterGroupPersistanceId()) {
            IMIProcessDMContext processDmc = (IMIProcessDMContext)DMContexts.getAncestorOfType((IDMContext)contDmc, IMIProcessDMContext.class);
            return processDmc == null ? null : processDmc.getProcId();
        }
        return null;
    }

    protected boolean useProcessIdAsRegisterGroupPersistanceId() {
        return false;
    }

    private void getUserGroupRegisters(IDMContext ctx, DataRequestMonitor<IRegisters.IRegisterDMContext[]> rm) {
        MIRegisters.MIRegisterDMC[] registers;
        MIRegisters.MIRegisterGroupDMC groupDmc = (MIRegisters.MIRegisterGroupDMC)DMContexts.getAncestorOfType((IDMContext)ctx, MIRegisters.MIRegisterGroupDMC.class);
        IRegisterGroupDescriptor grpDescriptor = this.fGroupMementoDescriptorIndex.get(groupDmc.getGroupNo());
        if (grpDescriptor == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "The Register Group Descriptor does not exist for group: " + groupDmc.getName(), null));
            rm.done();
            return;
        }
        try {
            registers = this.resolveRegisters(grpDescriptor, ctx);
        }
        catch (CoreException e) {
            rm.setStatus(e.getStatus());
            rm.done();
            return;
        }
        this.fGroupToRegistersMap.put(groupDmc, registers);
        this.buildGroupRegisters(ctx, registers, rm);
    }

    private MIRegisters.MIRegisterDMC[] resolveRegisters(IRegisterGroupDescriptor grpDescriptor, IDMContext ctx) throws CoreException {
        ArrayList<MIRegisters.MIRegisterDMC> registerContexts = new ArrayList<MIRegisters.MIRegisterDMC>();
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IRunControl.IContainerDMContext.class);
        MIRegisters.MIRegisterGroupDMC groupDmc = (MIRegisters.MIRegisterGroupDMC)DMContexts.getAncestorOfType((IDMContext)ctx, MIRegisters.MIRegisterGroupDMC.class);
        IRegisterDescriptor[] registerDescriptions = grpDescriptor.getChildren();
        MIRegisters.MIRegisterGroupDMC[] groupContexts = (MIRegisters.MIRegisterGroupDMC[])this.fContextToGroupsMap.get(containerDmc);
        if (groupContexts != null && groupContexts.length > 0) {
            Map<String, MIRegisters.MIRegisterDMC> indexedRegisterBase = this.fGroupToRegistersMap.getIndexedRegisters(groupContexts[0]);
            IRegisterDescriptor[] iRegisterDescriptorArray = registerDescriptions;
            int n = registerDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                IRegisterDescriptor registerDescription = iRegisterDescriptorArray[n2];
                MIRegisters.MIRegisterDMC registerDmc = indexedRegisterBase.get(registerDescription.getName());
                if (registerDmc == null) {
                    registerDmc = new MIRegisters.MIRegisterDMC(this, groupDmc, -1, registerDescription.getName());
                }
                registerContexts.add(registerDmc);
                ++n2;
            }
        }
        return registerContexts.toArray(new MIRegisters.MIRegisterDMC[registerContexts.size()]);
    }

    @Override
    protected void generateRegisterChangedEvent(IRegisters.IRegisterDMContext dmc) {
        this.getSession().dispatchEvent((Object)new MIRegisters.RegisterChangedDMEvent(dmc), this.getProperties());
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IContainerDMContext.class);
        this.generateRegistersChangedEvent(containerDmc);
    }

    private void generateRegistersChangedEvent(IRunControl.IContainerDMContext containerDmc) {
        MIRegisters.MIRegisterGroupDMC[] groups = (MIRegisters.MIRegisterGroupDMC[])this.fContextToGroupsMap.get(containerDmc);
        int i = 0;
        while (i < groups.length) {
            this.generateRegistersChangedEvent(groups[i]);
            ++i;
        }
    }

    private void generateRegistersChangedEvent(final MIRegisters.MIRegisterGroupDMC groupDmc) {
        IRegisters.IRegistersChangedDMEvent event = new IRegisters.IRegistersChangedDMEvent(){

            public IRegisters.IRegisterGroupDMContext getDMContext() {
                return groupDmc;
            }
        };
        this.getSession().dispatchEvent((Object)event, this.getProperties());
    }

    private void generateRegisterGroupChangedEvent(final MIRegisters.MIRegisterGroupDMC groupDmc) {
        IRegisters.IGroupChangedDMEvent event = new IRegisters.IGroupChangedDMEvent(){

            public IRegisters.IRegisterGroupDMContext getDMContext() {
                return groupDmc;
            }
        };
        this.getSession().dispatchEvent((Object)event, this.getProperties());
    }

    private MIRegisters.MIRegisterDMC[] toBareRegisters(MIRegisters.MIRegisterDMC[] registers) {
        MIRegisters.MIRegisterDMC[] bareRegisters = new MIRegisters.MIRegisterDMC[registers.length];
        int i = 0;
        while (i < registers.length) {
            MIRegisters.MIRegisterGroupDMC groupDmc = (MIRegisters.MIRegisterGroupDMC)DMContexts.getAncestorOfType((IDMContext)registers[i], MIRegisters.MIRegisterGroupDMC.class);
            assert (groupDmc != null);
            bareRegisters[i] = new MIRegisters.MIRegisterDMC(this, groupDmc, registers[i].getRegNo(), registers[i].getName());
            ++i;
        }
        return bareRegisters;
    }

    private void buildGroupRegisters(IDMContext ctx, final MIRegisters.MIRegisterDMC[] baseRegisters, final DataRequestMonitor<IRegisters.IRegisterDMContext[]> rm) {
        IStack stackService;
        IMIExecutionDMContext execDmc;
        final MIRegisters.MIRegisterGroupDMC groupDmc = (MIRegisters.MIRegisterGroupDMC)DMContexts.getAncestorOfType((IDMContext)ctx, MIRegisters.MIRegisterGroupDMC.class);
        assert (groupDmc != null);
        IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IStack.IFrameDMContext.class);
        if (frameDmc == null && (execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMIExecutionDMContext.class)) != null && (stackService = (IStack)this.getServicesTracker().getService(IStack.class)) != null) {
            stackService.getTopFrame((IDMContext)execDmc, (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IFrameDMContext>(rm){

                protected void handleSuccess() {
                    GDBRegisters.this.cloneRegistersToContext(groupDmc, (IStack.IFrameDMContext)this.getData(), baseRegisters, (DataRequestMonitor<IRegisters.IRegisterDMContext[]>)rm);
                }

                protected void handleFailure() {
                    GDBRegisters.this.cloneRegistersToContext(groupDmc, null, baseRegisters, (DataRequestMonitor<IRegisters.IRegisterDMContext[]>)rm);
                }
            });
            return;
        }
        this.cloneRegistersToContext(groupDmc, frameDmc, baseRegisters, rm);
    }

    private void cloneRegistersToContext(MIRegisters.MIRegisterGroupDMC groupDmc, IStack.IFrameDMContext frameDmc, MIRegisters.MIRegisterDMC[] baseRegisters, DataRequestMonitor<IRegisters.IRegisterDMContext[]> rm) {
        MIRegisters.MIRegisterDMC[] registers = new MIRegisters.MIRegisterDMC[baseRegisters.length];
        if (frameDmc != null) {
            int i = 0;
            while (i < registers.length) {
                registers[i] = new MIRegisters.MIRegisterDMC((MIRegisters)this, groupDmc, frameDmc, baseRegisters[i].getRegNo(), baseRegisters[i].getName());
                ++i;
            }
        } else {
            int i = 0;
            while (i < registers.length) {
                registers[i] = new MIRegisters.MIRegisterDMC(this, groupDmc, baseRegisters[i].getRegNo(), baseRegisters[i].getName());
                ++i;
            }
        }
        rm.setData((Object)registers);
        rm.done();
    }

    public void canRemoveRegisterGroups(IRegisters.IRegisterGroupDMContext[] groups, DataRequestMonitor<Boolean> rm) {
        if (groups == null || groups.length < 1) {
            rm.setData((Object)false);
            rm.done();
            return;
        }
        IRegisters.IRegisterGroupDMContext[] iRegisterGroupDMContextArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            IRegisters.IRegisterGroupDMContext group = iRegisterGroupDMContextArray[n2];
            assert (group instanceof MIRegisters.MIRegisterGroupDMC);
            MIRegisters.MIRegisterGroupDMC miGroup = (MIRegisters.MIRegisterGroupDMC)group;
            if (miGroup.getName().equals(ROOT_GROUP_NAME)) {
                rm.setData((Object)false);
                rm.done();
                return;
            }
            ++n2;
        }
        rm.setData((Object)true);
        rm.done();
    }

    public void canRestoreDefaultGroups(IDMContext selectionContext, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)true);
        rm.done();
    }

    static /* synthetic */ void access$2(GDBRegisters gDBRegisters, IDMContext iDMContext, DataRequestMonitor dataRequestMonitor) {
        super.getRegisters(iDMContext, (DataRequestMonitor<IRegisters.IRegisterDMContext[]>)dataRequestMonitor);
    }

    private class ContextToGroupsMap<K, V>
    extends HashMap<IRunControl.IContainerDMContext, MIRegisters.MIRegisterGroupDMC[]> {
        private static final long serialVersionUID = 1L;
        private final Map<IRunControl.IContainerDMContext, Map<String, MIRegisters.MIRegisterGroupDMC>> fNameToGroupMap = new HashMap<IRunControl.IContainerDMContext, Map<String, MIRegisters.MIRegisterGroupDMC>>();

        private ContextToGroupsMap() {
        }

        @Override
        public MIRegisters.MIRegisterGroupDMC[] put(IRunControl.IContainerDMContext key, MIRegisters.MIRegisterGroupDMC[] value) {
            if (key == null || value == null) {
                return null;
            }
            this.fNameToGroupMap.remove(key);
            return super.put(key, value);
        }

        @Override
        public void clear() {
            this.fNameToGroupMap.clear();
            GDBRegisters.this.fGroupMementoDescriptorIndex.clear();
            GDBRegisters.this.fGroupToRegistersMap.clear();
            super.clear();
        }

        @Override
        public MIRegisters.MIRegisterGroupDMC[] remove(Object key) {
            this.fNameToGroupMap.remove(key);
            return (MIRegisters.MIRegisterGroupDMC[])super.remove(key);
        }

        public Map<String, MIRegisters.MIRegisterGroupDMC> getGroupNameMap(IRunControl.IContainerDMContext key) {
            if (key == null) {
                return null;
            }
            Map<String, MIRegisters.MIRegisterGroupDMC> nameMap = this.fNameToGroupMap.get(key);
            if (nameMap == null) {
                nameMap = new HashMap<String, MIRegisters.MIRegisterGroupDMC>();
                MIRegisters.MIRegisterGroupDMC[] groupsArr = (MIRegisters.MIRegisterGroupDMC[])super.get(key);
                if (groupsArr != null) {
                    MIRegisters.MIRegisterGroupDMC[] mIRegisterGroupDMCArray = groupsArr;
                    int n = groupsArr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MIRegisters.MIRegisterGroupDMC group = mIRegisterGroupDMCArray[n2];
                        nameMap.put(group.getName(), group);
                        ++n2;
                    }
                    this.fNameToGroupMap.put(key, nameMap);
                }
            }
            return nameMap;
        }

        public void resetGroupNameMap(IRunControl.IContainerDMContext key) {
            this.fNameToGroupMap.remove(key);
        }

        public MIRegisters.MIRegisterGroupDMC[] getReversed(IDMContext key) {
            MIRegisters.MIRegisterGroupDMC[] groups = (MIRegisters.MIRegisterGroupDMC[])this.get(key);
            MIRegisters.MIRegisterGroupDMC[] reversedGroups = new MIRegisters.MIRegisterGroupDMC[groups.length];
            int size = groups.length;
            int i = 0;
            while (i < size) {
                reversedGroups[size - 1 - i] = groups[i];
                ++i;
            }
            return reversedGroups;
        }
    }

    private class GroupRegistersMap<K, V>
    extends HashMap<MIRegisters.MIRegisterGroupDMC, MIRegisters.MIRegisterDMC[]> {
        private static final long serialVersionUID = 1L;
        private final Map<MIRegisters.MIRegisterGroupDMC, Map<String, MIRegisters.MIRegisterDMC>> fNameToRegisterMap = new HashMap<MIRegisters.MIRegisterGroupDMC, Map<String, MIRegisters.MIRegisterDMC>>();

        private GroupRegistersMap() {
        }

        @Override
        public MIRegisters.MIRegisterDMC[] put(MIRegisters.MIRegisterGroupDMC key, MIRegisters.MIRegisterDMC[] value) {
            this.fNameToRegisterMap.remove((Object)key);
            return super.put(key, value);
        }

        public Map<String, MIRegisters.MIRegisterDMC> getIndexedRegisters(MIRegisters.MIRegisterGroupDMC key) {
            Map<String, MIRegisters.MIRegisterDMC> nameToRegisterMap = this.fNameToRegisterMap.get((Object)key);
            if (nameToRegisterMap == null && this.get((Object)key) != null && (nameToRegisterMap = this.indexRegisters(key)) != null) {
                this.fNameToRegisterMap.put(key, nameToRegisterMap);
            }
            return nameToRegisterMap;
        }

        @Override
        public void clear() {
            this.fNameToRegisterMap.clear();
            super.clear();
        }

        @Override
        public MIRegisters.MIRegisterDMC[] remove(Object key) {
            this.fNameToRegisterMap.remove(key);
            return (MIRegisters.MIRegisterDMC[])super.remove(key);
        }

        private Map<String, MIRegisters.MIRegisterDMC> indexRegisters(MIRegisters.MIRegisterGroupDMC registerGroup) {
            MIRegisters.MIRegisterDMC[] registers = (MIRegisters.MIRegisterDMC[])super.get((Object)registerGroup);
            if (registers == null || registers.length < 1) {
                return null;
            }
            HashMap<String, MIRegisters.MIRegisterDMC> registerNameMap = new HashMap<String, MIRegisters.MIRegisterDMC>();
            MIRegisters.MIRegisterDMC[] mIRegisterDMCArray = registers;
            int n = registers.length;
            int n2 = 0;
            while (n2 < n) {
                MIRegisters.MIRegisterDMC register = mIRegisterDMCArray[n2];
                assert (register instanceof MIRegisters.MIRegisterDMC);
                MIRegisters.MIRegisterDMC registerDmc = register;
                registerNameMap.put(registerDmc.getName(), registerDmc);
                ++n2;
            }
            return registerNameMap;
        }
    }

    private class RegisterDescriptor
    implements IRegisterDescriptor {
        private final MIRegisters.MIRegisterDMC fRegister;
        private static final String ORIGINAL_GROUP_NAME = "Main";

        public RegisterDescriptor(MIRegisters.MIRegisterDMC register) {
            this.fRegister = register;
        }

        public String getName() {
            return this.fRegister.getName();
        }

        public String getGroupName() {
            return ORIGINAL_GROUP_NAME;
        }
    }

    private class RegisterGroupDescriptor
    implements IRegisterGroupDescriptor {
        private final boolean fEnabled;
        private final MIRegisters.MIRegisterGroupDMC fgroup;

        public RegisterGroupDescriptor(MIRegisters.MIRegisterGroupDMC group, boolean enabled) {
            this.fgroup = group;
            this.fEnabled = enabled;
        }

        public String getName() {
            return this.fgroup.getName();
        }

        public boolean isEnabled() {
            return this.fEnabled;
        }

        public String getContainerId() {
            IRunControl.IContainerDMContext parent = this.fgroup.getContainerParent();
            return GDBRegisters.this.getPersistenceIdForRegisterGroupContainer(parent);
        }

        public IRegisterDescriptor[] getChildren() throws CoreException {
            IRegisterDescriptor[] regDescriptors = null;
            MIRegisters.MIRegisterDMC[] registers = (MIRegisters.MIRegisterDMC[])GDBRegisters.this.fGroupToRegistersMap.get((Object)this.fgroup);
            if (registers != null && registers.length > 0) {
                regDescriptors = new IRegisterDescriptor[registers.length];
                int i = 0;
                while (i < registers.length) {
                    regDescriptors[i] = new RegisterDescriptor(registers[i]);
                    ++i;
                }
            } else {
                IRegisterGroupDescriptor groupMementoDescriptor = GDBRegisters.this.fGroupMementoDescriptorIndex.get(this.fgroup.getGroupNo());
                if (groupMementoDescriptor != null) {
                    regDescriptors = groupMementoDescriptor.getChildren();
                }
            }
            return regDescriptors;
        }
    }
}

