/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader;

import java.util.Objects;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvCallbackHandler;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.CsvParseException;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.FieldModifier;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.FieldModifiers;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.reader.RecordType;
import org.junit.jupiter.params.shadow.de.siegmar.fastcsv.util.Preconditions;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractInternalCsvCallbackHandler<T>
extends CsvCallbackHandler<T> {
    private static final int DEFAULT_INITIAL_FIELDS_SIZE = 32;
    protected final int maxFields;
    protected final int maxFieldSize;
    protected final int maxRecordSize;
    protected final FieldModifier fieldModifier;
    protected long startingLineNumber;
    protected String[] fields;
    protected int recordSize;
    protected int fieldIdx;
    protected RecordType recordType = RecordType.DATA;

    protected AbstractInternalCsvCallbackHandler(int maxFields, int maxFieldSize, int maxRecordSize, FieldModifier fieldModifier) {
        Preconditions.checkArgument(maxRecordSize >= maxFieldSize, "maxRecordSize must be >= maxFieldSize");
        this.maxFields = maxFields;
        this.maxFieldSize = maxFieldSize;
        this.maxRecordSize = maxRecordSize;
        this.fieldModifier = Objects.requireNonNull(fieldModifier, "fieldModifier must not be null");
        this.fields = new String[Math.min(32, maxFields)];
    }

    @Override
    public RecordType getRecordType() {
        return this.recordType;
    }

    @Override
    protected int getFieldCount() {
        return this.fieldIdx;
    }

    @Override
    protected void beginRecord(long startingLineNumber) {
        this.startingLineNumber = startingLineNumber;
        this.fieldIdx = 0;
        this.recordSize = 0;
        this.recordType = RecordType.DATA;
    }

    @Override
    protected void addField(char[] buf, int offset, int len, boolean quoted) {
        String modifiedField = this.modifyField(new String(buf, offset, len), quoted);
        int modifiedFieldLength = modifiedField.length();
        if (this.maxFieldSize < modifiedFieldLength) {
            throw new CsvParseException(this.maxFieldSizeExceededMessage());
        }
        if (this.maxRecordSize < this.recordSize + modifiedFieldLength) {
            throw new CsvParseException(this.maxRecordSizeExceededMessage());
        }
        if (this.fieldIdx == this.fields.length) {
            this.extendCapacity();
        }
        this.fields[this.fieldIdx++] = modifiedField;
        this.recordSize += modifiedFieldLength;
    }

    protected String modifyField(String value, boolean quoted) {
        return this.fieldModifier.modify(this.startingLineNumber, this.fieldIdx, quoted, value);
    }

    private String maxFieldSizeExceededMessage() {
        return "Field at index %d in record starting at line %d exceeds the max field size of %d characters".formatted(this.fieldIdx, this.startingLineNumber, this.maxFieldSize);
    }

    private String maxRecordSizeExceededMessage() {
        return "Field at index %d in record starting at line %d exceeds the max record size of %d characters".formatted(this.fieldIdx, this.startingLineNumber, this.maxRecordSize);
    }

    @Override
    protected void setComment(char[] buf, int offset, int len) {
        this.recordType = RecordType.COMMENT;
        String modifiedComment = this.modifyComment(new String(buf, offset, len));
        int modifiedCommentLength = modifiedComment.length();
        if (this.maxFieldSize < modifiedCommentLength) {
            throw new CsvParseException(this.maxFieldSizeExceededMessage());
        }
        this.recordSize += modifiedCommentLength;
        this.fields[0] = modifiedComment;
        this.fieldIdx = 1;
    }

    protected String modifyComment(String field) {
        return this.fieldModifier.modifyComment(this.startingLineNumber, field);
    }

    @Override
    protected void setEmpty() {
        this.recordType = RecordType.EMPTY;
        this.fields[0] = "";
        this.fieldIdx = 1;
    }

    private void extendCapacity() {
        if (this.fields.length == this.maxFields) {
            throw new CsvParseException("Record starting at line %d has surpassed the maximum limit of %d fields".formatted(this.startingLineNumber, this.maxFields));
        }
        String[] newFields = new String[Math.min(this.maxFields, this.fields.length * 2)];
        System.arraycopy(this.fields, 0, newFields, 0, this.fieldIdx);
        this.fields = newFields;
    }

    protected String[] compactFields() {
        String[] ret = new String[this.fieldIdx];
        System.arraycopy(this.fields, 0, ret, 0, this.fieldIdx);
        return ret;
    }

    public static abstract class AbstractInternalCsvCallbackHandlerBuilder<T extends AbstractInternalCsvCallbackHandlerBuilder<?>> {
        private static final int DEFAULT_MAX_FIELDS = 16384;
        private static final int DEFAULT_MAX_FIELD_SIZE = 0x1000000;
        private static final int DEFAULT_MAX_RECORD_SIZE = 0x4000000;
        protected int maxFields = 16384;
        protected int maxFieldSize = 0x1000000;
        protected int maxRecordSize = 0x4000000;
        protected FieldModifier fieldModifier = FieldModifiers.NOP;

        protected AbstractInternalCsvCallbackHandlerBuilder() {
        }

        protected abstract T self();

        public T maxFields(int maxFields) {
            Preconditions.checkArgument(maxFields > 0, "maxFields must be > 0");
            this.maxFields = maxFields;
            return this.self();
        }

        public T maxFieldSize(int maxFieldSize) {
            Preconditions.checkArgument(maxFieldSize > 0, "maxFieldSize must be > 0");
            this.maxFieldSize = maxFieldSize;
            return this.self();
        }

        public T maxRecordSize(int maxRecordSize) {
            Preconditions.checkArgument(maxRecordSize > 0, "maxRecordSize must be > 0");
            this.maxRecordSize = maxRecordSize;
            return this.self();
        }

        public T fieldModifier(FieldModifier fieldModifier) {
            Objects.requireNonNull(fieldModifier, "fieldModifier must not be null");
            this.fieldModifier = fieldModifier;
            return this.self();
        }
    }
}

