/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.bndtools.templating.Template;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.wizards.plugin.TemplatePluginContentWizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPluginContribution;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class WizardElement
extends NamedElement
implements IPluginContribution,
IAdaptable {
    public static final String ATT_NAME = "name";
    public static final String TAG_DESCRIPTION = "description";
    public static final String ATT_ICON = "icon";
    public static final String ATT_ID = "id";
    public static final String ATT_CLASS = "class";
    public static final String ATT_TEMPLATE = "template";
    public static final String ATT_POINT = "point";
    private String description;
    private IConfigurationElement configurationElement;
    private IConfigurationElement template;
    private Template bndTemplate;
    private String id;

    WizardElement(IConfigurationElement config) {
        super(config.getAttribute(ATT_NAME));
        this.configurationElement = config;
    }

    WizardElement(Template template, String id) {
        super(template.getName());
        this.bndTemplate = template;
        this.id = id;
    }

    public Object createExecutableExtension() throws CoreException {
        if (this.configurationElement != null) {
            return this.configurationElement.createExecutableExtension(ATT_CLASS);
        }
        return new TemplatePluginContentWizard(this.bndTemplate);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getDescription() {
        IConfigurationElement[] children;
        if (this.description == null && this.configurationElement != null && (children = this.configurationElement.getChildren(TAG_DESCRIPTION)).length > 0) {
            this.description = this.expandDescription(children[0].getValue());
        }
        if (this.description == null && this.bndTemplate != null) {
            this.description = this.bndTemplate.getShortDescription();
        }
        return this.description;
    }

    public Boolean getFlag(String name) {
        String value;
        if (this.configurationElement != null && (value = this.configurationElement.getAttribute(name)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return null;
    }

    public boolean getFlag(String name, boolean defaultValue) {
        if (this.configurationElement != null) {
            String value = this.configurationElement.getAttribute(name);
            if (value != null) {
                return value.equalsIgnoreCase("true");
            }
        } else if (this.bndTemplate != null) {
            return "bnd".equals(name);
        }
        return defaultValue;
    }

    public String getName() {
        return this.getLabel();
    }

    public Version getVersion() {
        if (this.bndTemplate != null) {
            return this.bndTemplate.getVersion();
        }
        return Version.emptyVersion;
    }

    private String expandDescription(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        if (source.indexOf(37) == -1) {
            return source;
        }
        Bundle bundle = Platform.getBundle((String)this.configurationElement.getNamespaceIdentifier());
        if (bundle == null) {
            return source;
        }
        ResourceBundle resourceBundle = Platform.getResourceBundle((Bundle)bundle);
        if (resourceBundle == null) {
            return source;
        }
        StringBuilder buf = new StringBuilder();
        boolean keyMode = false;
        int keyStartIndex = -1;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == '%') {
                char c2 = source.charAt(i + 1);
                if (c2 == '%') {
                    ++i;
                    buf.append('%');
                } else if (keyMode) {
                    String key;
                    keyMode = false;
                    String value = key = source.substring(keyStartIndex, i);
                    try {
                        value = resourceBundle.getString(key);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    buf.append(value);
                } else {
                    keyStartIndex = i + 1;
                    keyMode = true;
                }
            } else if (!keyMode) {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public String getID() {
        if (this.configurationElement != null) {
            return this.configurationElement.getAttribute(ATT_ID);
        }
        return this.id;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public Image getImage() {
        if (this.image == null && this.bndTemplate != null) {
            this.setImage((Image)Adapters.adapt((Object)this.bndTemplate, Image.class));
        }
        return this.image;
    }

    public String getTemplateId() {
        if (this.configurationElement != null) {
            return this.configurationElement.getAttribute(ATT_TEMPLATE);
        }
        return null;
    }

    public boolean isTemplate() {
        return this.getTemplateId() != null;
    }

    public IConfigurationElement getTemplateElement() {
        if (this.template == null && this.configurationElement != null) {
            this.template = this.findTemplateElement();
        }
        return this.template;
    }

    private IConfigurationElement findTemplateElement() {
        IConfigurationElement[] templates;
        String templateId = this.getTemplateId();
        if (templateId == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = templates = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.ui.templates");
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement template = iConfigurationElementArray[n2];
            String id = template.getAttribute(ATT_ID);
            if (id != null && id.equals(templateId)) {
                return template;
            }
            ++n2;
        }
        return null;
    }

    public String getContributingId() {
        IConfigurationElement tel = this.getTemplateElement();
        return tel == null ? null : tel.getAttribute("contributingId");
    }

    public String getLocalId() {
        return this.getID();
    }

    public String getPluginId() {
        return null;
    }

    public static WizardElement create(IConfigurationElement config, String ... requiredAttributes) {
        String[] stringArray = requiredAttributes;
        int n = requiredAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            String required = stringArray[n2];
            if (config.getAttribute(required) == null) {
                return null;
            }
            ++n2;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute(ATT_ICON);
        if (imageName != null) {
            String pluginID = config.getNamespaceIdentifier();
            Image image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pluginID, imageName);
            element.setImage(image);
        }
        return element;
    }

    public static WizardElement create(Template template, String id) {
        String name = template.getName();
        if (name == null || name.isBlank()) {
            return null;
        }
        return new WizardElement(template, id);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == Template.class) {
            return adapter.cast(this.bndTemplate);
        }
        return null;
    }
}

