/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.eclipse.swt.graphics.GC;

public class StructuredTextLineBreakingReader {
    private GC fGC;
    private int fIndex;
    private String fLine;
    private int fMaxWidth;
    private BufferedReader fReader;

    public StructuredTextLineBreakingReader(Reader reader, GC gc, int maxLineWidth) {
        this.fReader = new BufferedReader(reader);
        this.fGC = gc;
        this.fMaxWidth = maxLineWidth;
        this.fLine = null;
        this.fIndex = 0;
    }

    private int findNextBreakIndex(int currIndex) {
        int currWidth = 0;
        int lineLength = this.fLine.length();
        while (currIndex < lineLength) {
            char ch = this.fLine.charAt(currIndex);
            int nextIndex = currIndex + 1;
            if (Character.isWhitespace(ch)) {
                while (nextIndex < lineLength && Character.isWhitespace(this.fLine.charAt(nextIndex))) {
                    ++nextIndex;
                }
            }
            while (nextIndex < lineLength && !Character.isWhitespace(this.fLine.charAt(nextIndex))) {
                ++nextIndex;
            }
            String word = this.fLine.substring(currIndex, nextIndex);
            int wordWidth = this.fGC.textExtent((String)word).x;
            int nextWidth = wordWidth + currWidth;
            if (nextWidth > this.fMaxWidth && wordWidth < this.fMaxWidth) {
                return currIndex;
            }
            currWidth = nextWidth;
            currIndex = nextIndex;
        }
        return currIndex;
    }

    private int findWordBegin(int idx) {
        while (idx < this.fLine.length() && Character.isWhitespace(this.fLine.charAt(idx))) {
            ++idx;
        }
        return idx;
    }

    public String readLine() throws IOException {
        if (this.fLine == null) {
            String line = this.fReader.readLine();
            if (line == null) {
                return null;
            }
            int lineLen = this.fGC.textExtent((String)line).x;
            if (lineLen < this.fMaxWidth) {
                return line;
            }
            this.fLine = line;
            this.fIndex = 0;
        }
        int breakIdx = this.findNextBreakIndex(this.fIndex);
        String res = this.fLine.substring(this.fIndex, breakIdx);
        if (breakIdx < this.fLine.length()) {
            this.fIndex = this.findWordBegin(breakIdx);
        } else {
            this.fLine = null;
        }
        return res;
    }
}

