/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.eclipse.scout.sdk.core.util.Ensure;

public class DelayedBuffer<T> {
    private final long m_silentTime;
    private final TimeUnit m_silentTimeUnit;
    private final ScheduledExecutorService m_executorService;
    private final boolean m_allowParallelProcessing;
    private final Consumer<List<T>> m_processor;
    private final List<T> m_buffer;
    private final Object m_workLock;
    private ScheduledFuture<?> m_future;

    public DelayedBuffer(long silentTime, TimeUnit silentTimeUnit, ScheduledExecutorService executorService, boolean allowParallelProcessing, Consumer<List<T>> processor) {
        this.m_silentTime = silentTime;
        this.m_silentTimeUnit = Ensure.notNull(silentTimeUnit);
        this.m_executorService = Ensure.notNull(executorService);
        this.m_allowParallelProcessing = allowParallelProcessing;
        this.m_processor = Ensure.notNull(processor);
        this.m_workLock = new Object();
        this.m_buffer = new ArrayList<T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(T element) {
        List<T> list = this.m_buffer;
        synchronized (list) {
            this.cancelExistingFuture();
            this.registerElement(element);
            this.scheduleNewProcessing();
        }
    }

    public void awaitAllProcessed(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ScheduledFuture<?> current = this.m_future;
        if (current == null) {
            return;
        }
        current.get(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processElements() {
        List<T> myWork = this.getMyWork();
        if (myWork.isEmpty()) {
            return;
        }
        if (this.isAllowParallelProcessing()) {
            this.processor().accept(myWork);
        } else {
            Object object = this.m_workLock;
            synchronized (object) {
                this.processor().accept(myWork);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<T> getMyWork() {
        ArrayList<T> myWork;
        List<T> list = this.m_buffer;
        synchronized (list) {
            myWork = new ArrayList<T>(this.m_buffer);
            this.m_buffer.clear();
        }
        return myWork;
    }

    void registerElement(T element) {
        this.m_buffer.add(element);
    }

    void cancelExistingFuture() {
        ScheduledFuture<?> current = this.m_future;
        if (current == null) {
            return;
        }
        current.cancel(false);
    }

    void scheduleNewProcessing() {
        this.m_future = this.executorService().schedule(this::processElements, this.silentTime(), this.silentTimeUnit());
    }

    public boolean isAllowParallelProcessing() {
        return this.m_allowParallelProcessing;
    }

    public Consumer<List<T>> processor() {
        return this.m_processor;
    }

    public long silentTime() {
        return this.m_silentTime;
    }

    public TimeUnit silentTimeUnit() {
        return this.m_silentTimeUnit;
    }

    public ScheduledExecutorService executorService() {
        return this.m_executorService;
    }
}

