/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.snippets;

import org.eclipse.lemminx.dom.DOMCDATASection;
import org.eclipse.lemminx.dom.DOMComment;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;

public class SnippetContextUtils {
    private SnippetContextUtils() {
    }

    public static boolean canAcceptExpression(ICompletionRequest request) {
        DOMElement parent;
        DOMNode node = request.getNode();
        int offset = request.getOffset();
        if (node.getNodeType() == 9) {
            return true;
        }
        if (node.isElement()) {
            DOMElement element = (DOMElement)node;
            if (element.isOrphanEndTag()) {
                return false;
            }
            if (!element.hasTagName()) {
                return true;
            }
            if (element.isInInsideStartEndTag(offset)) {
                String text = request.getXMLDocument().getText();
                return text.charAt(offset - 1) != '/';
            }
            if (element.isInStartTag(offset)) {
                return offset >= node.getEnd();
            }
            if (element.isInEndTag(offset)) {
                return false;
            }
            if (!element.hasEndTag()) {
                String text = request.getXMLDocument().getText();
                return text.charAt(node.getEnd() - 1) != '/';
            }
            return offset >= node.getEnd();
        }
        if (offset > node.getEnd() && (parent = node.getParentElement()) != null && parent.isInEndTag(offset)) {
            return false;
        }
        if (offset < node.getEnd()) {
            if (node.isComment()) {
                DOMComment comment = (DOMComment)node;
                return comment.getStartContent() == offset;
            }
            if (node.isCDATA()) {
                DOMCDATASection cdata = (DOMCDATASection)node;
                return cdata.getStartContent() == offset;
            }
            return node.isText();
        }
        return true;
    }
}

