/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.AbstractExceptionAnalyzer;

class ExceptionAnalyzer
extends AbstractExceptionAnalyzer {
    ExceptionAnalyzer() {
    }

    public static ITypeBinding[] perform(ASTNode[] statements) {
        ExceptionAnalyzer analyzer = new ExceptionAnalyzer();
        int i = 0;
        while (i < statements.length) {
            statements[i].accept((ASTVisitor)analyzer);
            ++i;
        }
        List exceptions = analyzer.getCurrentExceptions();
        return exceptions.toArray(new ITypeBinding[exceptions.size()]);
    }

    @Override
    public boolean visit(ThrowStatement node) {
        ITypeBinding exception = node.getExpression().resolveTypeBinding();
        if (exception == null) {
            return true;
        }
        this.addException(exception);
        return true;
    }

    @Override
    public boolean visit(FunctionInvocation node) {
        SimpleName name = node.getName();
        if (name != null) {
            return this.handleExceptions((IFunctionBinding)name.resolveBinding());
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        return this.handleExceptions((IFunctionBinding)node.getName().resolveBinding());
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        return this.handleExceptions(node.resolveConstructorBinding());
    }

    private boolean handleExceptions(IFunctionBinding binding) {
        if (binding == null) {
            return true;
        }
        this.addExceptions(null);
        return true;
    }
}

