/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.sourcelookup.ui.internal;

import org.eclipse.jdt.internal.launching.sourcelookup.advanced.AdvancedSourceLookupSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SourceLookupPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public SourceLookupPreferencePage() {
        this.setMessage("Manual configuration of dynamic source lookup");
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.disableScrollingFor(composite);
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).margins(0, 0).applyTo(composite);
        this.createLabel("VM arguments:", composite);
        GridDataFactory textGridDataFactory = GridDataFactory.swtDefaults().align(4, 4).grab(true, false).span(1, 1).hint(parent.getSize().x, -1);
        String javaagentString = AdvancedSourceLookupSupport.getJavaagentString();
        this.createTextField(javaagentString, composite, textGridDataFactory);
        this.createLabel(".launch file VM arguments:", composite);
        this.createTextField("-javaagent:${sourcelookup_agent_path}", composite, textGridDataFactory);
        this.createLabel(".launch file attribute:", composite);
        this.createTextField("<stringAttribute key=\"org.eclipse.debug.core.source_locator_id\" value=\"org.eclipse.m2e.sourcelookupDirector\"/>\n", composite, textGridDataFactory);
        return composite;
    }

    private void createLabel(String text, Composite composite) {
        new Label(composite, 0).setText(text);
    }

    private void createTextField(String text, Composite composite, GridDataFactory gridDataFactory) {
        Text textField = new Text(composite, 2122);
        gridDataFactory.applyTo((Control)textField);
        textField.setText(text);
    }

    private void disableScrollingFor(Composite composite) {
        Composite temp = composite;
        while (temp != null && !(temp instanceof ScrolledComposite)) {
            temp = temp.getParent();
        }
        ScrolledComposite scrolledComposite = (ScrolledComposite)temp;
        if (scrolledComposite != null) {
            ControlListener resizeAndWrapRatherThanScroll = ControlListener.controlResizedAdapter(e -> {
                if (composite.isVisible()) {
                    scrolledComposite.setMinWidth(scrolledComposite.getSize().x);
                }
            });
            scrolledComposite.addControlListener(resizeAndWrapRatherThanScroll);
            composite.addDisposeListener(e -> scrolledComposite.removeControlListener(resizeAndWrapRatherThanScroll));
        }
    }
}

