/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class ModifyStyledTextRule
extends GenerationSimpleRule {
    private String newValue;
    private StyledText text;
    private String widgetLocator;

    @Override
    public boolean appliesTo(Event event) {
        if (event.widget instanceof StyledText && event.type == 24) {
            StyledText text = (StyledText)event.widget;
            return !text.getText().isEmpty();
        }
        return false;
    }

    @Override
    public void initializeForEvent(Event event) {
        this.text = (StyledText)event.widget;
        this.widgetLocator = WidgetUtils.widgetLocator(this.text);
        this.newValue = this.text.getText();
    }

    @Override
    public List<String> getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        StringBuilder res = new StringBuilder(this.widgetLocator);
        res.append(".setText(\"" + this.newValue + "\")");
        actions.add(res.toString());
        return actions;
    }

    @Override
    public List<String> getImports() {
        return null;
    }

    public StyledText getWidget() {
        return this.text;
    }
}

