/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.Framework;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.FrameworkAware;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.code.NoFramework;
import org.eclipse.passage.lic.base.diagnostic.code.SeveralFrameworks;
import org.eclipse.passage.lic.internal.equinox.i18n.AccessMessages;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class EquinoxFrameworkAware<S>
implements FrameworkAware {
    private final BundleContext context = FrameworkUtil.getBundle(EquinoxFrameworkAware.class).getBundleContext();
    private final Class<S> component;
    private final Function<S, Optional<Framework>> constructor;

    protected EquinoxFrameworkAware(Class<S> cls, Function<S, Optional<Framework>> constructor) {
        this.component = cls;
        this.constructor = constructor;
    }

    public final <T> ServiceInvocationResult<T> withFrameworkService(Function<Framework, ServiceInvocationResult<T>> invoke) {
        return this.withReference(reference -> Optional.ofNullable(this.context.getService(reference)).flatMap(this.constructor::apply).map(invoke::apply).orElseGet(this::noFramework), this::noFramework, this::severalFrameworks);
    }

    public final <T> Optional<T> withFramework(Function<Framework, T> invoke) {
        return this.withReference(reference -> Optional.ofNullable(this.context.getService(reference)).flatMap(this.constructor::apply).map(invoke::apply), Optional::empty, any -> Optional.empty());
    }

    private <T> ServiceInvocationResult<T> noFramework() {
        return new BaseServiceInvocationResult(new Trouble((TroubleCode)new NoFramework(), String.format(AccessMessages.EquinoxPassage_no_framework, new Object[0])));
    }

    private <T> ServiceInvocationResult<T> severalFrameworks(Collection<ServiceReference<S>> findings) {
        return new BaseServiceInvocationResult((Diagnostic)new BaseDiagnostic(findings.stream().map(foreign -> this.foreignFramework(findings.size(), (ServiceReference<S>)foreign)).collect(Collectors.toList()), Collections.emptyList()));
    }

    private Trouble foreignFramework(int singlings, ServiceReference<S> foreign) {
        return new Trouble((TroubleCode)new SeveralFrameworks(singlings), String.format(AccessMessages.EquinoxPassage_foreign_framework, foreign.getBundle().getSymbolicName()));
    }

    private <K> K withReference(Function<ServiceReference<S>, K> onFramework, Supplier<K> onNoFramework, Function<Collection<ServiceReference<S>>, K> onSeveralFrameworks) {
        Collection<ServiceReference<S>> candidates = this.frameworks();
        if (candidates.isEmpty()) {
            return onNoFramework.get();
        }
        if (candidates.size() > 1) {
            return onSeveralFrameworks.apply(candidates);
        }
        ServiceReference<S> reference = candidates.iterator().next();
        try {
            K k = onFramework.apply(reference);
            return k;
        }
        finally {
            this.context.ungetService(reference);
        }
    }

    private Collection<ServiceReference<S>> frameworks() {
        try {
            return this.context.getServiceReferences(this.component, null);
        }
        catch (InvalidSyntaxException e) {
            return Collections.emptyList();
        }
    }
}

