/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.templates;

import org.eclipse.core.runtime.Assert;
import org.eclipse.pde.ui.templates.AbstractChoiceOption;
import org.eclipse.pde.ui.templates.BaseOptionTemplateSection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RadioChoiceOption
extends AbstractChoiceOption {
    private Button[] fButtons;
    private Label fLabel;

    public RadioChoiceOption(BaseOptionTemplateSection section, String name, String label, String[][] choices) {
        super(section, name, label, choices);
        Assert.isTrue((choices.length == 2 ? 1 : 0) != 0);
    }

    private Button createRadioButton(Composite parent, int span, String[] choice) {
        Button button = new Button(parent, 16);
        button.setData((Object)choice[0]);
        button.setText(choice[1]);
        GridData gd = this.fill((Control)button, span);
        gd.horizontalIndent = 10;
        return button;
    }

    @Override
    public void createControl(Composite parent, int span) {
        this.fLabel = this.createLabel(parent, 1);
        this.fLabel.setEnabled(this.isEnabled());
        this.fill((Control)this.fLabel, span);
        Composite radioComp = this.createComposite(parent, span);
        GridData gd = this.fill((Control)radioComp, span);
        gd.horizontalIndent = 10;
        GridLayout layout = new GridLayout(this.fChoices.length, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        radioComp.setLayout((Layout)layout);
        this.fButtons = new Button[this.fChoices.length];
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> {
            Button b = (Button)e.widget;
            if (this.isBlocked()) {
                return;
            }
            if (b.getSelection()) {
                this.setValue(b.getData().toString());
                this.getSection().validateOptions(this);
            }
        });
        int i = 0;
        while (i < this.fChoices.length) {
            this.fButtons[i] = this.createRadioButton(radioComp, 1, this.fChoices[i]);
            this.fButtons[i].addSelectionListener(listener);
            this.fButtons[i].setEnabled(this.isEnabled());
            ++i;
        }
        if (this.getChoice() != null) {
            this.selectChoice(this.getChoice());
        }
    }

    @Override
    protected void setOptionValue(Object value) {
        if (this.fButtons != null && value != null) {
            this.selectChoice(value.toString());
        }
    }

    @Override
    protected void setOptionEnabled(boolean enabled) {
        if (this.fLabel != null) {
            this.fLabel.setEnabled(enabled);
            Button[] buttonArray = this.fButtons;
            int n = this.fButtons.length;
            int n2 = 0;
            while (n2 < n) {
                Button button = buttonArray[n2];
                button.setEnabled(enabled);
                ++n2;
            }
        }
    }

    @Override
    protected void selectOptionChoice(String choice) {
        Button[] buttonArray = this.fButtons;
        int n = this.fButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Button button = buttonArray[n2];
            String bname = button.getData().toString();
            if (bname.equals(choice)) {
                button.setSelection(true);
            } else {
                button.setSelection(false);
            }
            ++n2;
        }
    }
}

