/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.validation.ControlValidationUtility;
import org.eclipse.pde.internal.ui.editor.validation.TextValidator;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class GeneralInfoSection
extends PDESection {
    private static final String PLATFORM_FILTER = "Eclipse-PlatformFilter";
    private FormEntry fIdEntry;
    private FormEntry fVersionEntry;
    private FormEntry fNameEntry;
    private FormEntry fProviderEntry;
    private FormEntry fPlatformFilterEntry;
    private TextValidator fIdEntryValidator;
    private TextValidator fVersionEntryValidator;
    private TextValidator fNameEntryValidator;
    private TextValidator fProviderEntryValidator;
    private TextValidator fPlatformEntryValidator;
    private IPluginModelBase fModel;
    protected Button fSingleton;
    private Button fBundleShapeDefault;
    private Button fBundleShapeJar;
    private Button fBundleShapeDir;

    public GeneralInfoSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ManifestEditor_PluginSpecSection_title);
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        section.setDescription(this.getSectionDescription());
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 3));
        section.setClient((Control)client);
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.createIDEntry(client, toolkit, actionBars);
        this.createVersionEntry(client, toolkit, actionBars);
        this.createNameEntry(client, toolkit, actionBars);
        this.createProviderEntry(client, toolkit, actionBars);
        if (this.isBundle() && ((ManifestEditor)this.getPage().getEditor()).isEquinox()) {
            this.createPlatformFilterEntry(client, toolkit, actionBars);
        }
        this.createSpecificControls(client, toolkit, actionBars);
        this.createBundleShape(client, toolkit, PDEUIMessages.PluginGeneralInfoSection_bundleshape);
        toolkit.paintBordersFor(client);
        this.addListeners();
    }

    protected abstract String getSectionDescription();

    protected abstract void createSpecificControls(Composite var1, FormToolkit var2, IActionBars var3);

    protected IPluginBase getPluginBase() {
        IBaseModel model = this.getPage().getPDEEditor().getAggregateModel();
        if (model instanceof IPluginModelBase) {
            IPluginModelBase base = (IPluginModelBase)model;
            return base.getPluginBase();
        }
        return null;
    }

    protected IPluginModelBase getModelBase() {
        if (this.fModel == null) {
            this.fModel = PluginRegistry.findModel((IProject)this.getProject());
        }
        return this.fModel;
    }

    protected boolean isBundle() {
        return this.getBundleContext() != null;
    }

    private BundleInputContext getBundleContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (BundleInputContext)manager.findContext("bundle-context");
    }

    protected IBundle getBundle() {
        BundleInputContext context = this.getBundleContext();
        if (context != null) {
            BundleModel model = context.getModel();
            return model.getBundle();
        }
        return null;
    }

    private void createIDEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fIdEntry = new FormEntry(client, toolkit, PDEUIMessages.GeneralInfoSection_id, null, false);
        this.fIdEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                try {
                    GeneralInfoSection.this.getPluginBase().setId(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fIdEntry.setEditable(this.isEditable());
        this.fIdEntryValidator = new TextValidator(this.getManagedForm(), this.fIdEntry.getText(), this.getProject(), true){

            @Override
            protected boolean validateControl() {
                return GeneralInfoSection.this.validateIdEntry();
            }
        };
    }

    private boolean validateIdEntry() {
        return ControlValidationUtility.validateRequiredField(this.fIdEntry.getText().getText(), this.fIdEntryValidator, 3);
    }

    private void createVersionEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fVersionEntry = new FormEntry(client, toolkit, PDEUIMessages.GeneralInfoSection_version, null, false);
        this.fVersionEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                try {
                    GeneralInfoSection.this.getPluginBase().setVersion(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fVersionEntry.setEditable(this.isEditable());
        this.fVersionEntryValidator = new TextValidator(this.getManagedForm(), this.fVersionEntry.getText(), this.getProject(), true){

            @Override
            protected boolean validateControl() {
                return GeneralInfoSection.this.validateVersionEntry();
            }
        };
    }

    private boolean validateVersionEntry() {
        if (!ControlValidationUtility.validateRequiredField(this.fVersionEntry.getText().getText(), this.fVersionEntryValidator, 3)) {
            return false;
        }
        return ControlValidationUtility.validateVersionField(this.fVersionEntry.getText().getText(), this.fVersionEntryValidator);
    }

    private void createNameEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fNameEntry = new FormEntry(client, toolkit, PDEUIMessages.GeneralInfoSection_name, null, false);
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                try {
                    GeneralInfoSection.this.getPluginBase().setName(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fNameEntry.setEditable(this.isEditable());
        this.fNameEntryValidator = new TextValidator(this.getManagedForm(), this.fNameEntry.getText(), this.getProject(), true){

            @Override
            protected boolean validateControl() {
                return GeneralInfoSection.this.validateNameEntry();
            }
        };
    }

    private boolean validateNameEntry() {
        return ControlValidationUtility.validateTranslatableField(this.fNameEntry.getText().getText(), this.fNameEntryValidator, this.getModelBase(), this.getProject());
    }

    private void createProviderEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fProviderEntry = new FormEntry(client, toolkit, PDEUIMessages.GeneralInfoSection_provider, null, false);
        this.fProviderEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                try {
                    GeneralInfoSection.this.getPluginBase().setProviderName(entry.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.fProviderEntry.setEditable(this.isEditable());
        this.fProviderEntryValidator = new TextValidator(this.getManagedForm(), this.fProviderEntry.getText(), this.getProject(), true){

            @Override
            protected boolean validateControl() {
                return GeneralInfoSection.this.validateProviderEntry();
            }
        };
    }

    private boolean validateProviderEntry() {
        if (this.fProviderEntry.getText().getText().length() == 0) {
            return true;
        }
        return ControlValidationUtility.validateTranslatableField(this.fProviderEntry.getText().getText(), this.fProviderEntryValidator, this.getModelBase(), this.getProject());
    }

    private void createPlatformFilterEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.fPlatformFilterEntry = new FormEntry(client, toolkit, PDEUIMessages.GeneralInfoSection_platformFilter, null, false);
        this.fPlatformFilterEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                GeneralInfoSection.this.getBundle().setHeader(GeneralInfoSection.PLATFORM_FILTER, GeneralInfoSection.this.fPlatformFilterEntry.getValue());
            }
        });
        this.fPlatformFilterEntry.setEditable(this.isEditable());
        this.fPlatformEntryValidator = new TextValidator(this.getManagedForm(), this.fPlatformFilterEntry.getText(), this.getProject(), true){

            @Override
            protected boolean validateControl() {
                return GeneralInfoSection.this.validatePlatformEntry();
            }
        };
    }

    private boolean validatePlatformEntry() {
        if (this.fPlatformFilterEntry.getText().getText().length() == 0) {
            return true;
        }
        return ControlValidationUtility.validatePlatformFilterField(this.fPlatformFilterEntry.getText().getText(), this.fPlatformEntryValidator);
    }

    public void commit(boolean onSave) {
        this.fIdEntry.commit();
        this.fVersionEntry.commit();
        this.fNameEntry.commit();
        this.fProviderEntry.commit();
        if (this.fPlatformFilterEntry != null) {
            this.fPlatformFilterEntry.commit();
        }
        super.commit(onSave);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        String property;
        Object obj;
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        this.refresh();
        if (e.getChangeType() == 3 && (obj = e.getChangedObjects()[0]) instanceof IPluginBase && (property = e.getChangedProperty()) != null && property.equals(this.getPage().getPDEEditor().getTitleProperty())) {
            this.getPage().getPDEEditor().updateTitle();
        }
    }

    public void refresh() {
        block13: {
            Button selectedBundleShape;
            block14: {
                String value;
                IBundle bundle;
                IPluginModelBase model = (IPluginModelBase)this.getPage().getPDEEditor().getContextManager().getAggregateModel();
                IPluginBase pluginBase = model.getPluginBase();
                this.fIdEntry.setValue(pluginBase.getId(), true);
                this.fNameEntry.setValue(pluginBase.getName(), true);
                this.fVersionEntry.setValue(pluginBase.getVersion(), true);
                this.fProviderEntry.setValue(pluginBase.getProviderName(), true);
                if (this.fPlatformFilterEntry != null && (bundle = this.getBundle()) != null) {
                    this.fPlatformFilterEntry.setValue(bundle.getHeader(PLATFORM_FILTER), true);
                }
                this.getPage().getPDEEditor().updateTitle();
                if (this.fSingleton != null) {
                    IManifestHeader header = this.getSingletonHeader();
                    this.fSingleton.setSelection(header instanceof BundleSymbolicNameHeader && ((BundleSymbolicNameHeader)header).isSingleton());
                }
                Stream.of(this.fBundleShapeDefault, this.fBundleShapeJar, this.fBundleShapeDir).forEach(b -> b.setSelection(false));
                selectedBundleShape = this.fBundleShapeDefault;
                IBundle bundle2 = this.getBundle();
                if (bundle2 == null) break block13;
                IManifestHeader header = bundle2.getManifestHeader("Eclipse-BundleShape");
                if (header == null || (value = header.getValue()) == null) break block14;
                switch (value) {
                    case "jar": {
                        Button button = this.fBundleShapeJar;
                        break;
                    }
                    case "dir": {
                        Button button = this.fBundleShapeDir;
                        break;
                    }
                    default: {
                        Button button = selectedBundleShape = null;
                    }
                }
            }
            if (selectedBundleShape != null) {
                selectedBundleShape.setSelection(true);
            }
        }
        super.refresh();
    }

    @Override
    public void cancelEdit() {
        this.fIdEntry.cancelEdit();
        this.fNameEntry.cancelEdit();
        this.fVersionEntry.cancelEdit();
        this.fProviderEntry.cancelEdit();
        if (this.fPlatformFilterEntry != null) {
            this.fPlatformFilterEntry.cancelEdit();
        }
        super.cancelEdit();
    }

    protected void removeListeners() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).removeModelChangedListener((IModelChangedListener)this);
        }
    }

    protected void addListeners() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            IModelChangeProvider mod = (IModelChangeProvider)model;
            mod.addModelChangedListener((IModelChangedListener)this);
            this.getSection().addDisposeListener(e -> mod.removeModelChangedListener((IModelChangedListener)this));
        }
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        return d.getFocusControl() instanceof Text;
    }

    IManifestHeader getSingletonHeader() {
        IBundle bundle = this.getBundle();
        if (bundle instanceof Bundle) {
            IManifestHeader header = bundle.getManifestHeader("Bundle-SymbolicName");
            return header;
        }
        return null;
    }

    protected void createSingleton(Composite parent, FormToolkit toolkit, IActionBars actionBars, String label) {
        this.fSingleton = toolkit.createButton(parent, label, 32);
        TableWrapData td = new TableWrapData();
        td.colspan = 3;
        this.fSingleton.setLayoutData((Object)td);
        this.fSingleton.setEnabled(this.isEditable());
        this.fSingleton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IManifestHeader header = this.getSingletonHeader();
            if (header instanceof BundleSymbolicNameHeader) {
                ((BundleSymbolicNameHeader)header).setSingleton(this.fSingleton.getSelection());
            }
        }));
    }

    protected void createBundleShape(Composite parent, FormToolkit toolkit, String label) {
        Composite c = new Composite(parent, 0);
        TableWrapData td = new TableWrapData();
        td.colspan = 3;
        c.setLayoutData((Object)td);
        RowLayoutFactory.fillDefaults().spacing(5).applyTo(c);
        toolkit.createLabel(c, label, 0);
        this.fBundleShapeDefault = toolkit.createButton(c, PDEUIMessages.GeneralInfoSection_BundleShape_default, 16);
        this.fBundleShapeJar = toolkit.createButton(c, PDEUIMessages.GeneralInfoSection_BundleShape_jar, 16);
        this.fBundleShapeDir = toolkit.createButton(c, PDEUIMessages.GeneralInfoSection_BundleShape_dir, 16);
        this.fBundleShapeDir.setToolTipText(PDEUIMessages.GeneralInfoSection_BundleShape_dir_tooltip);
        this.fBundleShapeJar.setToolTipText(PDEUIMessages.GeneralInfoSection_BundleShape_jar_tooltip);
        this.fBundleShapeDefault.setToolTipText(PDEUIMessages.GeneralInfoSection_BundleShape_default_tooltip);
        this.fBundleShapeDefault.setSelection(true);
        this.fBundleShapeJar.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setBundleShapeHeader((SelectionEvent)event, "jar")));
        this.fBundleShapeDir.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setBundleShapeHeader((SelectionEvent)event, "dir")));
        this.fBundleShapeDefault.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.setBundleShapeHeader((SelectionEvent)event, null)));
    }

    private void setBundleShapeHeader(SelectionEvent event, String shape) {
        if (((Button)event.widget).getSelection()) {
            IBundle bundle = this.getBundle();
            if (shape != null) {
                bundle.setHeader("Eclipse-BundleShape", shape);
            } else {
                bundle.getManifestHeader("Eclipse-BundleShape").setValue(null);
            }
        }
    }
}

