/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.pattern;

import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class PatternTypingFilter
extends TokenFilter {
    private final PatternTypingRule[] replacementAndFlagByPattern;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final FlagsAttribute flagAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

    public PatternTypingFilter(TokenStream input, PatternTypingRule ... replacementAndFlagByPattern) {
        super(input);
        if (replacementAndFlagByPattern == null || Stream.of(replacementAndFlagByPattern).anyMatch(Objects::isNull)) {
            throw new NullPointerException("replacementAndFlagByPattern");
        }
        this.replacementAndFlagByPattern = replacementAndFlagByPattern;
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            for (PatternTypingRule rule : this.replacementAndFlagByPattern) {
                Matcher matcher = rule.pattern().matcher((CharSequence)this.termAtt);
                if (!matcher.find()) continue;
                this.typeAtt.setType(matcher.replaceFirst(rule.typeTemplate()));
                this.flagAtt.setFlags(rule.flags());
                return true;
            }
            return true;
        }
        return false;
    }

    public record PatternTypingRule(Pattern pattern, int flags, String typeTemplate) {
    }
}

